/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestLocationMapper
extends TestCase {
    static Log log = LogFactory.getLog((Class)TestLocationMapper.class);
    static final String testingDir = "testing/FileManager";
    static final String filename1 = "file:test";
    static final String notFilename = "zzzz";
    static final String filename2 = "file:testing/FileManager/location-mapping-test-file";
    static final String mapping = "location-mapping-test.n3;testing/FileManager/location-mapping-test.n3";

    public TestLocationMapper(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestLocationMapper.class);
    }

    public void testLocationMapper() {
        LocationMapper locMap = new LocationMapper(mapping);
        String alt = locMap.altMapping(filename1);
        TestLocationMapper.assertNotNull((Object)alt);
        TestLocationMapper.assertEquals((String)alt, (String)filename2);
    }

    public void testLocationMapperMiss() {
        LocationMapper locMap = new LocationMapper(mapping);
        String alt = locMap.altMapping(notFilename);
        TestLocationMapper.assertNotNull((Object)alt);
        TestLocationMapper.assertEquals((String)alt, (String)notFilename);
    }

    public void testLocationMapperURLtoFile() {
        LocationMapper locMap = new LocationMapper(mapping);
        String alt = locMap.altMapping("http://example.org/file");
        TestLocationMapper.assertNotNull((Object)alt);
        TestLocationMapper.assertEquals((String)alt, (String)filename2);
    }

    public void testLocationMapperFromModel() {
        String v2;
        String v1;
        String e;
        Model model = FileManager.get().loadModel("testing/FileManager/location-mapping-test.n3");
        LocationMapper loc = new LocationMapper(model);
        LocationMapper locMap = new LocationMapper(mapping);
        Iterator iter = loc.listAltEntries();
        while (iter.hasNext()) {
            e = (String)iter.next();
            v1 = locMap.getAltEntry(e);
            v2 = loc.getAltEntry(e);
            TestLocationMapper.assertEquals((String)"Different entries", (String)v1, (String)v2);
        }
        iter = loc.listAltPrefixes();
        while (iter.hasNext()) {
            e = (String)iter.next();
            v1 = locMap.getAltPrefix(e);
            v2 = loc.getAltPrefix(e);
            TestLocationMapper.assertEquals((String)"Different entries", (String)v1, (String)v2);
        }
    }

    public void testLocationMapperClone1() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(locMap1);
        locMap1.removeAltEntry("http://example.org/file");
        String alt = locMap2.altMapping("http://example.org/file");
        TestLocationMapper.assertNotNull((Object)alt);
        TestLocationMapper.assertEquals((String)alt, (String)filename2);
    }

    public void testLocationMapperClone2() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(locMap1);
        locMap2.addAltPrefix("http://example.org/OTHER", "file:OTHER");
        String alt = locMap2.altMapping("http://example.org/OTHER/f");
        TestLocationMapper.assertNotNull((Object)alt);
        TestLocationMapper.assertEquals((String)alt, (String)"file:OTHER/f");
        alt = locMap1.altMapping("http://example.org/OTHER/f");
        TestLocationMapper.assertNotNull((Object)alt);
        TestLocationMapper.assertEquals((String)alt, (String)"http://example.org/OTHER/f");
    }

    public void testLocationMapperEquals1() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(mapping);
        TestLocationMapper.assertEquals((Object)locMap1, (Object)locMap2);
        TestLocationMapper.assertEquals((int)locMap1.hashCode(), (int)locMap2.hashCode());
    }

    public void testLocationMapperEquals2() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(mapping);
        locMap2.addAltEntry("file:nowhere", "file:somewhere");
        TestLocationMapper.assertFalse((boolean)locMap1.equals((Object)locMap2));
        TestLocationMapper.assertFalse((boolean)locMap2.equals((Object)locMap1));
    }

    public void testLocationMapperToModel1() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(locMap1.toModel());
        TestLocationMapper.assertEquals((Object)locMap1, (Object)locMap2);
        TestLocationMapper.assertEquals((int)locMap1.hashCode(), (int)locMap2.hashCode());
    }

    public void testLocationMapperToModel2() {
        LocationMapper locMap1 = new LocationMapper(mapping);
        LocationMapper locMap2 = new LocationMapper(mapping);
        locMap1 = new LocationMapper(locMap1.toModel());
        locMap2.addAltEntry("file:nowhere", "file:somewhere");
        TestLocationMapper.assertFalse((boolean)locMap1.equals((Object)locMap2));
        TestLocationMapper.assertFalse((boolean)locMap2.equals((Object)locMap1));
    }
}

