/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import java.util.HashSet;
import java.util.Set;
import org.jibx.schema.elements.ImportElement;
import org.jibx.schema.elements.IncludeElement;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.util.HolderBase;
import org.jibx.util.UniqueNameSet;

public class SchemaHolder
extends HolderBase {
    private final SchemaElement m_schema;
    private final UniqueNameSet m_typeNameSet;
    private final UniqueNameSet m_elementNameSet;
    private Set m_fixedSet;

    public SchemaHolder(String uri) {
        super(uri);
        this.m_schema = new SchemaElement();
        this.m_typeNameSet = new UniqueNameSet();
        this.m_elementNameSet = new UniqueNameSet();
        if (uri != null) {
            this.m_schema.setElementFormDefault(0);
            this.m_schema.setTargetNamespace(uri);
            this.m_schema.addNamespaceDeclaration("tns", uri);
        }
    }

    public SchemaHolder(SchemaElement schema) {
        super(schema.getTargetNamespace(), schema.getResolver().getName());
        this.m_schema = schema;
        this.m_elementNameSet = null;
        this.m_typeNameSet = null;
    }

    public SchemaElement getSchema() {
        return this.m_schema;
    }

    public String addTypeName(String base) {
        if (!this.isModifiable()) {
            throw new IllegalStateException("Internal error - file is not modifiable");
        }
        return this.m_typeNameSet.add(base);
    }

    public String addElementName(String base) {
        if (!this.isModifiable()) {
            throw new IllegalStateException("Internal error - file is not modifiable");
        }
        return this.m_elementNameSet.add(base);
    }

    protected void addNamespaceDecl(String prefix, String uri) {
        this.m_schema.addNamespaceDeclaration(prefix, uri);
    }

    public void finish() {
        if (!this.isModifiable()) {
            throw new IllegalStateException("Internal error - file is not modifiable");
        }
        if (this.m_fixedSet == null) {
            this.m_fixedSet = new HashSet();
        }
        for (SchemaHolder holder : this.getReferences()) {
            if (this.m_fixedSet.contains((Object)holder)) continue;
            String ns = holder.getNamespace();
            String file = holder.getFileName();
            if (ns == null || ns.equals(this.getNamespace())) {
                if (file != null) {
                    IncludeElement inc = new IncludeElement();
                    inc.setLocation(file);
                    this.m_schema.getSchemaChildren().add(inc);
                }
            } else {
                ImportElement imp = new ImportElement();
                imp.setLocation(file);
                imp.setNamespace(ns);
                this.m_schema.getSchemaChildren().add(imp);
                this.getPrefix(ns);
            }
            this.m_fixedSet.add(holder);
        }
        super.finish();
    }
}

