/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.tokens.Token;

public class ParserProfileBase
implements ParserProfile {
    protected ErrorHandler errorHandler;
    protected Prologue prologue;
    protected LabelToNode labelMapping;
    protected boolean strictMode = SysRIOT.strictMode;

    public ParserProfileBase(Prologue prologue, ErrorHandler errorHandler) {
        this(prologue, errorHandler, SyntaxLabels.createLabelToNode());
    }

    public ParserProfileBase(Prologue prologue, ErrorHandler errorHandler, LabelToNode labelMapping) {
        this.prologue = prologue;
        this.errorHandler = errorHandler;
        this.labelMapping = labelMapping;
    }

    @Override
    public ErrorHandler getHandler() {
        return this.errorHandler;
    }

    @Override
    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public Prologue getPrologue() {
        return this.prologue;
    }

    @Override
    public void setPrologue(Prologue p) {
        this.prologue = p;
    }

    @Override
    public LabelToNode getLabelToNode() {
        return this.labelMapping;
    }

    @Override
    public void setLabelToNode(LabelToNode mapper) {
        this.labelMapping = mapper;
    }

    @Override
    public String resolveIRI(String uriStr, long line, long col) {
        return this.prologue.getResolver().resolveToString(uriStr);
    }

    @Override
    public IRI makeIRI(String uriStr, long line, long col) {
        return this.prologue.getResolver().resolve(uriStr);
    }

    @Override
    public Quad createQuad(Node g, Node s, Node p, Node o, long line, long col) {
        return new Quad(g, s, p, o);
    }

    @Override
    public Triple createTriple(Node s, Node p, Node o, long line, long col) {
        return new Triple(s, p, o);
    }

    @Override
    public Node createURI(String uriStr, long line, long col) {
        return RiotLib.createIRIorBNode(uriStr);
    }

    @Override
    public Node createBlankNode(Node scope, String label, long line, long col) {
        return (Node)this.labelMapping.get(scope, label);
    }

    @Override
    public Node createBlankNode(Node scope, long line, long col) {
        return (Node)this.labelMapping.create();
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype dt, long line, long col) {
        return NodeFactory.createLiteral((String)lexical, (RDFDatatype)dt);
    }

    @Override
    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        return NodeFactory.createLiteral((String)lexical, (String)langTag);
    }

    @Override
    public Node createStringLiteral(String lexical, long line, long col) {
        return NodeFactory.createLiteral((String)lexical);
    }

    @Override
    public Node createNodeFromToken(Node scope, Token token, long line, long col) {
        return null;
    }

    @Override
    public Node create(Node currentGraph, Token token) {
        long line = token.getLine();
        long col = token.getColumn();
        String str2 = token.getImage();
        switch (token.getType()) {
            case BNODE: {
                return this.createBlankNode(currentGraph, str2, line, col);
            }
            case IRI: {
                return this.createURI(str2, line, col);
            }
            case PREFIXED_NAME: {
                String prefix = str2;
                String suffix = token.getImage2();
                String expansion = this.expandPrefixedName(prefix, suffix, token);
                return this.createURI(expansion, line, col);
            }
            case DECIMAL: {
                return this.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDdecimal, line, col);
            }
            case DOUBLE: {
                return this.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDdouble, line, col);
            }
            case INTEGER: {
                return this.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDinteger, line, col);
            }
            case LITERAL_DT: {
                String uriStr;
                Token tokenDT = token.getSubToken2();
                switch (tokenDT.getType()) {
                    case IRI: {
                        uriStr = tokenDT.getImage();
                        break;
                    }
                    case PREFIXED_NAME: {
                        String prefix = tokenDT.getImage();
                        String suffix = tokenDT.getImage2();
                        uriStr = this.expandPrefixedName(prefix, suffix, tokenDT);
                        break;
                    }
                    default: {
                        throw new RiotException("Expected IRI for datatype: " + token);
                    }
                }
                uriStr = this.resolveIRI(uriStr, tokenDT.getLine(), tokenDT.getColumn());
                RDFDatatype dt = NodeFactory.getType((String)uriStr);
                return this.createTypedLiteral(str2, dt, line, col);
            }
            case LITERAL_LANG: {
                return this.createLangLiteral(str2, token.getImage2(), line, col);
            }
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                return this.createStringLiteral(str2, line, col);
            }
        }
        Node x = this.createNodeFromToken(currentGraph, token, line, col);
        if (x != null) {
            return x;
        }
        this.errorHandler.fatal("Not a valid token for an RDF term: " + token, line, col);
        return null;
    }

    private String expandPrefixedName(String prefix, String localPart, Token token) {
        String expansion = this.prologue.getPrefixMap().expand(prefix, localPart);
        if (expansion == null) {
            this.errorHandler.fatal("Undefined prefix: " + prefix, token.getLine(), token.getColumn());
        }
        return expansion;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public void setStrictMode(boolean mode) {
        this.strictMode = mode;
    }
}

