/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggAvgDistinct
extends AggregatorBase {
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvgDistinct(Expr expr) {
        super("AVG", true, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggAvgDistinct(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccAvgDistinct(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    @Override
    public int hashCode() {
        return 0x171 ^ this.getExprList().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggAvgDistinct)) {
            return false;
        }
        AggAvgDistinct a = (AggAvgDistinct)other;
        return this.exprList.equals(a.exprList);
    }

    class AccAvgDistinct
    extends AccumulatorDistinctExpr {
        private NodeValue total;
        private int count;
        static final boolean DEBUG = false;

        public AccAvgDistinct(Expr expr) {
            super(expr);
            this.total = noValuesToAvg;
            this.count = 0;
        }

        @Override
        protected void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                ++this.count;
                this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("avg: not a number: " + nv);
            }
        }

        @Override
        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.numDivide(this.total, nvCount);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

