/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpBase;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.atlas.lib.Pair;

public class TransformFilterInequality
extends TransformCopy {
    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        Op op = TransformFilterInequality.apply(opFilter.getExprs(), subOp);
        if (op == null) {
            return super.transform(opFilter, subOp);
        }
        return op;
    }

    private static Op apply(ExprList exprs, Op subOp) {
        Pair<List<Pair<Var, NodeValue>>, ExprList> p = TransformFilterInequality.preprocessFilterInequality(exprs);
        if (p == null || p.getLeft().size() == 0) {
            return null;
        }
        List<Pair<Var, NodeValue>> inequalities = p.getLeft();
        Collection<Var> varsMentioned = TransformFilterInequality.varsMentionedInInequalityFilters(inequalities);
        ExprList remaining = p.getRight();
        Op op = subOp;
        if (TransformFilterInequality.testSpecialCaseUnused(subOp, inequalities, remaining)) {
            return OpTable.empty();
        }
        if (TransformFilterInequality.testSpecialCase1(subOp, inequalities, remaining)) {
            List<Op> ops = TransformFilterInequality.extractOptionals(subOp);
            ops = TransformFilterInequality.processSpecialCase1(ops, inequalities);
            op = TransformFilterInequality.rebuild((Op2)subOp, ops);
            op = OpFilter.filter(exprs, op);
            return op;
        }
        if (!TransformFilterInequality.safeToTransform(varsMentioned, op)) {
            return null;
        }
        op = TransformFilterInequality.processFilterWorker(op, inequalities);
        if (remaining.size() > 0) {
            op = OpFilter.filter(remaining, op);
        }
        return op;
    }

    private static Pair<List<Pair<Var, NodeValue>>, ExprList> preprocessFilterInequality(ExprList exprs) {
        ArrayList<Pair<Var, NodeValue>> exprsFilterInequality = new ArrayList<Pair<Var, NodeValue>>();
        ExprList exprsOther = new ExprList();
        for (Expr e2 : exprs.getList()) {
            Pair<Var, NodeValue> p = TransformFilterInequality.preprocess(e2);
            if (p != null) {
                exprsFilterInequality.add(p);
                continue;
            }
            exprsOther.add(e2);
        }
        if (exprsFilterInequality.size() == 0) {
            return null;
        }
        return Pair.create(exprsFilterInequality, exprsOther);
    }

    private static Pair<Var, NodeValue> preprocess(Expr e2) {
        if (!(e2 instanceof E_NotEquals)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return null;
        }
        if (!ARQ.isStrictMode() && constant.isLiteral()) {
            return null;
        }
        return Pair.create(var, constant);
    }

    private static Collection<Var> varsMentionedInInequalityFilters(List<Pair<Var, NodeValue>> inequalities) {
        HashSet<Var> vars = new HashSet<Var>();
        for (Pair<Var, NodeValue> p : inequalities) {
            vars.add(p.getLeft());
        }
        return vars;
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, Op op) {
        OpTable opTable;
        if (op instanceof OpBGP || op instanceof OpQuadPattern) {
            return true;
        }
        if (op instanceof OpFilter) {
            OpFilter opf = (OpFilter)op;
            return TransformFilterInequality.safeToTransform(varsEquality, opf.getSubOp());
        }
        if (op instanceof OpSequence) {
            OpN opN = (OpN)op;
            for (Op subOp : opN.getElements()) {
                if (TransformFilterInequality.safeToTransform(varsEquality, subOp)) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpJoin || op instanceof OpUnion) {
            Op2 op2 = (Op2)op;
            return TransformFilterInequality.safeToTransform(varsEquality, op2.getLeft()) && TransformFilterInequality.safeToTransform(varsEquality, op2.getRight());
        }
        if (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin = (Op2)op;
            if (!TransformFilterInequality.safeToTransform(varsEquality, opleftjoin.getLeft()) || !TransformFilterInequality.safeToTransform(varsEquality, opleftjoin.getRight())) {
                return false;
            }
            Op opLeft = opleftjoin.getLeft();
            Set<Var> varsLeft = OpVars.visibleVars(opLeft);
            return varsLeft.containsAll(varsEquality);
        }
        if (op instanceof OpGraph) {
            OpGraph opg = (OpGraph)op;
            return TransformFilterInequality.safeToTransform(varsEquality, opg.getSubOp());
        }
        if (op instanceof OpModifier) {
            OpModifier opMod = (OpModifier)op;
            if (opMod instanceof OpProject) {
                OpProject opProject = (OpProject)op;
                for (Var v : opProject.getVars()) {
                    if (!varsEquality.contains((Object)v)) continue;
                    return false;
                }
            }
            return TransformFilterInequality.safeToTransform(varsEquality, opMod.getSubOp());
        }
        if (op instanceof OpGroup) {
            OpGroup opGroup = (OpGroup)op;
            VarExprList varExprList = opGroup.getGroupVars();
            return TransformFilterInequality.safeToTransform(varsEquality, varExprList) && TransformFilterInequality.safeToTransform(varsEquality, opGroup.getSubOp());
        }
        return op instanceof OpTable && (opTable = (OpTable)op).isJoinIdentity();
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, VarExprList varsExprList) {
        return CollectionUtils.disjoint(varsExprList.getVars(), varsEquality);
    }

    private static boolean testSpecialCaseUnused(Op op, List<Pair<Var, NodeValue>> equalities, ExprList remaining) {
        Set<Var> patternVars = OpVars.visibleVars(op);
        for (Pair<Var, NodeValue> p : equalities) {
            if (patternVars.contains((Object)p.getLeft())) continue;
            return true;
        }
        return false;
    }

    private static boolean testSpecialCase1(Op op, List<Pair<Var, NodeValue>> equalities, ExprList remaining) {
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            op = opleftjoin2.getLeft();
        }
        return TransformFilterInequality.isUnitTable(op);
    }

    private static List<Op> extractOptionals(Op op) {
        ArrayList<Op> chain = new ArrayList<Op>();
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            chain.add(opleftjoin2.getRight());
            op = opleftjoin2.getLeft();
        }
        return chain;
    }

    private static List<Op> processSpecialCase1(List<Op> ops, List<Pair<Var, NodeValue>> inequalities) {
        ArrayList<Op> ops2 = new ArrayList<Op>();
        Collection<Var> vars = TransformFilterInequality.varsMentionedInInequalityFilters(inequalities);
        Iterator<Op> i$ = ops.iterator();
        while (i$.hasNext()) {
            Op op;
            Op op2 = op = i$.next();
            if (TransformFilterInequality.safeToTransform(vars, op)) {
                op2 = TransformFilterInequality.processFilterWorker(op, inequalities);
            }
            ops2.add(op2);
        }
        return ops2;
    }

    private static Op rebuild(Op2 subOp, List<Op> ops) {
        OpBase chain = OpTable.unit();
        for (Op op : ops) {
            chain = subOp.copy(chain, op);
        }
        return chain;
    }

    private static boolean isUnitTable(Op op) {
        return op instanceof OpTable && ((OpTable)op).isJoinIdentity();
    }

    private static Op processFilterWorker(Op op, List<Pair<Var, NodeValue>> inequalities) {
        HashMap<Var, Set<NodeValue>> possibleValues = new HashMap<Var, Set<NodeValue>>();
        for (Pair<Var, NodeValue> inequalityTest : inequalities) {
            if (!possibleValues.containsKey((Object)inequalityTest.getLeft())) {
                possibleValues.put(inequalityTest.getLeft(), new HashSet());
            }
            ((Set)possibleValues.get((Object)inequalityTest.getLeft())).add(inequalityTest.getRight());
        }
        Table table = TransformFilterInequality.buildTable(possibleValues);
        return OpMinus.create(op, OpTable.create(table));
    }

    private static Table buildTable(Map<Var, Set<NodeValue>> possibleValues) {
        if (possibleValues.size() == 0) {
            return TableFactory.createEmpty();
        }
        Table table = TableFactory.create();
        for (Var v : possibleValues.keySet()) {
            for (NodeValue value : possibleValues.get((Object)v)) {
                BindingMap b = BindingFactory.create();
                b.add(v, value.asNode());
                table.addBinding(b);
            }
        }
        return table;
    }
}

