/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.iri.IRI;

public class NodeUtils {
    public static EqualityTest sameTerm = new EqualityTest(){

        @Override
        public boolean equal(Node n1, Node n2) {
            return NodeFunctions.sameTerm(n1, n2);
        }
    };
    public static EqualityTest sameValue = new EqualityTest(){

        @Override
        public boolean equal(Node n1, Node n2) {
            NodeValue nv1 = NodeValue.makeNode(n1);
            NodeValue nv2 = NodeValue.makeNode(n2);
            try {
                return NodeValue.sameAs(nv1, nv2);
            }
            catch (ExprEvalException ex) {
                return false;
            }
        }
    };

    public static Node asNode(IRI iri2) {
        return NodeFactory.createURI((String)iri2.toString());
    }

    public static Node asNode(String iri2) {
        return NodeFactory.createURI((String)iri2);
    }

    public static boolean hasLang(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        String x = node.getLiteralLanguage();
        if (x == null) {
            return false;
        }
        return !x.equals("");
    }

    public static String stringLiteral(Node literal) {
        if (!literal.isLiteral()) {
            return null;
        }
        RDFDatatype dType = literal.getLiteralDatatype();
        String langTag = literal.getLiteralLanguage();
        if (langTag != null && !langTag.equals("")) {
            return literal.getLiteralLexicalForm();
        }
        if (dType == null || dType.equals(XSDDatatype.XSDstring)) {
            return literal.getLiteralLexicalForm();
        }
        return null;
    }

    public static Iterator<String> nodesToURIs(Iterator<Node> iter) {
        MapFilter<Node, String> mapper = new MapFilter<Node, String>(){

            public String accept(Node x) {
                return x.getURI();
            }
        };
        ExtendedIterator eIter = WrappedIterator.create(iter);
        MapFilterIterator conv = new MapFilterIterator((MapFilter)mapper, eIter);
        return conv;
    }

    public static Set<Node> convertToNodes(Collection<String> uris) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (String x : uris) {
            nodes.add(NodeFactory.createURI((String)x));
        }
        return nodes;
    }

    public static int compareRDFTerms(Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node1.isLiteral() && node2.isLiteral()) {
            return NodeUtils.compareLiteralsBySyntax(node1, node2);
        }
        if (node1.isVariable()) {
            if (node2.isVariable()) {
                return StrUtils.strCompare(node1.getName(), node2.getName());
            }
            return -1;
        }
        if (node2.isVariable()) {
            return 1;
        }
        if (node1.isBlank()) {
            if (node2.isBlank()) {
                String s1 = node1.getBlankNodeId().getLabelString();
                String s2 = node2.getBlankNodeId().getLabelString();
                return StrUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node1.isURI()) {
            if (node2.isURI()) {
                String s1 = node1.getURI();
                String s2 = node2.getURI();
                return StrUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        throw new ARQInternalErrorException("Compare: " + node1 + "  " + node2);
    }

    private static int compareLiteralsBySyntax(Node node1, Node node2) {
        String lex2;
        if (node1 == null || !node1.isLiteral() || node2 == null || !node2.isLiteral()) {
            throw new ARQInternalErrorException("compareLiteralsBySyntax called with non-literal: (" + node1 + "," + node2 + ")");
        }
        if (node1.equals((Object)node2)) {
            return 0;
        }
        String lex1 = node1.getLiteralLexicalForm();
        int x = StrUtils.strCompare(lex1, lex2 = node2.getLiteralLexicalForm());
        if (x != 0) {
            return x;
        }
        if (NodeUtils.isSimpleString(node1)) {
            return -1;
        }
        if (NodeUtils.isSimpleString(node2)) {
            return 1;
        }
        if (NodeUtils.isLangString(node1) && NodeUtils.isLangString(node2)) {
            String lang2;
            String lang1 = node1.getLiteralLanguage();
            x = StrUtils.strCompareIgnoreCase(lang1, lang2 = node2.getLiteralLanguage());
            if (x != 0) {
                return x;
            }
            x = StrUtils.strCompare(lang1, lang2);
            if (x != 0) {
                return x;
            }
            throw new ARQInternalErrorException("compareLiteralsBySyntax: lexical form and languages tags identical on non.equals literals");
        }
        if (NodeUtils.isLangString(node1)) {
            return -1;
        }
        if (NodeUtils.isLangString(node2)) {
            return 1;
        }
        String dt1 = node1.getLiteralDatatypeURI();
        String dt2 = node2.getLiteralDatatypeURI();
        return StrUtils.strCompare(dt1, dt2);
    }

    public static boolean isSimpleString(Node n) {
        return Util.isSimpleString((Node)n);
    }

    public static boolean isLangString(Node n) {
        return Util.isLangString((Node)n);
    }

    public static interface EqualityTest {
        public boolean equal(Node var1, Node var2);
    }
}

