/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.NotFoundException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.adapters.RDFReaderRIOT;
import org.apache.jena.riot.system.stream.StreamManager;

public class RDFReaderRIOT_Web
extends RDFReaderRIOT {
    private static final String defaultSyntax = "RDF/XML";

    public RDFReaderRIOT_Web() {
        super(defaultSyntax);
    }

    @Override
    public void read(Model model, Reader r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public void read(Model model, InputStream r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public void read(Model model, String url) {
        TypedInputStream in = StreamManager.get().open(url);
        if (in == null) {
            throw new NotFoundException(url);
        }
        String contentType = in.getContentType();
        Lang lang = null;
        if (!Lib.equal(contentType, "text/plain")) {
            lang = RDFLanguages.contentTypeToLang(contentType);
        }
        if (lang == null) {
            lang = RDFLanguages.filenameToLang(url);
        }
        if (lang == null) {
            lang = this.hintlang;
        }
        this.startRead(model);
        RDFDataMgr.read(model, (InputStream)in, url, lang);
        this.finishRead(model);
    }
}

