/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import javax.xml.datatype.XMLGregorianCalendar;

public class NodeValueDT
extends NodeValue {
    private final XMLGregorianCalendar datetime;

    public NodeValueDT(String lex, Node n) {
        super(n);
        if (XSDDatatype.XSDgMonth.equals(this.getNode().getLiteralDatatype()) && lex.endsWith("Z")) {
            lex = lex.substring(0, lex.length() - 1);
            this.datetime = NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(lex);
            this.datetime.setTimezone(0);
            return;
        }
        this.datetime = NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(lex);
    }

    @Override
    public boolean isDateTime() {
        return XSDDatatype.XSDdateTime.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isDate() {
        return XSDDatatype.XSDdate.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isTime() {
        return XSDDatatype.XSDtime.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGYear() {
        return XSDDatatype.XSDgYear.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGYearMonth() {
        return XSDDatatype.XSDgYearMonth.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGMonth() {
        return XSDDatatype.XSDgMonth.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGMonthDay() {
        return XSDDatatype.XSDgMonthDay.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public boolean isGDay() {
        return XSDDatatype.XSDgDay.equals(this.getNode().getLiteralDatatype());
    }

    @Override
    public XMLGregorianCalendar getDateTime() {
        return (XMLGregorianCalendar)this.datetime.clone();
    }

    @Override
    protected Node makeNode() {
        return null;
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

