/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi;

import java.util.List;
import org.dataone.bookkeeper.api.Usage;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterBeanMapper(value=Usage.class)
public interface UsageStore {
    public static final String SELECT_CLAUSE = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u ";
    public static final String SELECT_ALL = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u ";
    public static final String SELECT_BY_ID = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.id = :id";
    public static final String SELECT_BY_INSTANCE_ID = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.instanceId = :instanceId";
    public static final String SELECT_BY_INSTANCE_ID_AND_OWNERS = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.instanceid = :instanceId AND q.subject IN (<subjects>)";
    public static final String SELECT_BY_INSTANCE_ID_AND_QUOTA_ID = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.instanceId = :instanceId AND u.quotaid = :quotaId";
    public static final String SELECT_BY_INSTANCE_ID_AND_QUOTA_ID_AND_OWNERS = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.instanceid = :instanceId AND u.quotaId = :quotaId AND q.subject IN (<subjects>)";
    public static final String SELECT_BY_QUOTA_ID = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.quotaId = :quotaId";
    public static final String SELECT_BY_QUOTA_ID_AND_OWNERS = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.quotaid = :quotaId AND q.subject IN (<subjects>)";
    public static final String SELECT_BY_QUOTA_TYPE = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE q.quotaType = :quotaType";
    public static final String SELECT_BY_QUOTA_OWNERS = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE q.subject IN (<subjects>)";
    public static final String SELECT_BY_QUOTA_TYPE_AND_OWNERS = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE q.quotaType = :quotaType AND q.subject IN (<subjects>)";
    public static final String SELECT_BY_INSTANCE_ID_AND_QUOTA_TYPE = "SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.instanceid = :instanceId AND q.quotaType = :quotaType";

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u ")
    public List<Usage> listUsages();

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.id = :id")
    public Usage getUsage(@Bind(value="id") Integer var1);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.instanceId = :instanceId")
    public List<Usage> findUsagesByInstanceId(@Bind(value="instanceId") String var1);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.instanceid = :instanceId AND q.subject IN (<subjects>)")
    public List<Usage> findUsagesByInstanceIdAndSubjects(@Bind(value="instanceId") String var1, @BindList(value="subjects") List<String> var2);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.instanceId = :instanceId AND u.quotaid = :quotaId")
    public Usage findUsageByInstanceIdAndQuotaId(@Bind(value="instanceId") String var1, @Bind(value="quotaId") Integer var2);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.instanceid = :instanceId AND u.quotaId = :quotaId AND q.subject IN (<subjects>)")
    public Usage findUsageByInstanceIdQuotaIdAndSubjects(@Bind(value="instanceId") String var1, @Bind(value="quotaId") Integer var2, @BindList(value="subjects") List<String> var3);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u WHERE u.quotaId = :quotaId")
    public List<Usage> findUsagesByQuotaId(@Bind(value="quotaId") Integer var1);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.quotaid = :quotaId AND q.subject IN (<subjects>)")
    public List<Usage> findUsagesByQuotaIdAndSubjects(@Bind(value="quotaId") Integer var1, @BindList(value="subjects") List<String> var2);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE q.quotaType = :quotaType")
    public List<Usage> findUsagesByQuotaType(@Bind(value="quotaType") String var1);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE q.subject IN (<subjects>)")
    public List<Usage> findUsagesByQuotaSubjects(@BindList(value="subjects") List<String> var1);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE q.quotaType = :quotaType AND q.subject IN (<subjects>)")
    public List<Usage> findUsagesByQuotaTypeAndSubjects(@Bind(value="quotaType") String var1, @BindList(value="subjects") List<String> var2);

    @SqlQuery(value="SELECT u.id, u.object, u.quotaid, u.instanceid, u.quantity, u.status, u.nodeid FROM usages u INNER JOIN quotas q ON q.id = u.quotaid WHERE u.instanceid = :instanceId AND q.quotaType = :quotaType")
    public Usage findUsageByInstanceIdAndQuotaType(@Bind(value="instanceId") String var1, @Bind(value="quotaType") String var2);

    @SqlUpdate(value="INSERT INTO usages (object, quotaId, instanceId, quantity, status, nodeId) VALUES (:object, :quotaId, :instanceId, :quantity, :status, :nodeId) RETURNING id")
    @GetGeneratedKeys
    public Integer insert(@BindBean Usage var1);

    @SqlUpdate(value="UPDATE usages SET object = :object, quotaId = :quotaId, instanceId = :instanceId, quantity = :quantity, status = :status, nodeId = :nodeId WHERE id = :id")
    @GetGeneratedKeys
    public Usage update(@BindBean Usage var1);

    @SqlUpdate(value="DELETE FROM usages WHERE id = :id")
    public void delete(@Bind(value="id") Integer var1);
}

