/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.generator.json;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.JSONParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.annotator.generator.AnnotationGenerator;
import org.dataone.annotator.matcher.ConceptItem;
import org.dataone.annotator.matcher.ConceptMatcher;
import org.dataone.annotator.matcher.ConceptMatcherFactory;
import org.dataone.annotator.matcher.bioportal.BioPortalService;
import org.dataone.annotator.matcher.esor.CosineService;
import org.dataone.annotator.matcher.esor.EsorService;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.Party;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;

public class JsonAnnotatorGenerator
extends AnnotationGenerator {
    private static Log log = LogFactory.getLog(JsonAnnotatorGenerator.class);
    private ConceptMatcher conceptMatcher;
    private ConceptMatcher orcidMatcher;

    public JsonAnnotatorGenerator() throws Exception {
        String matcherClassName = Settings.getConfiguration().getString("annotator.matcher.className");
        this.conceptMatcher = ConceptMatcherFactory.getMatcher(matcherClassName);
    }

    @Override
    public Map<Identifier, String> generateAnnotations(Identifier metadataPid) throws Exception {
        if (this.conceptMatcher instanceof CosineService) {
            return this.generateAnnotationsCosine(metadataPid);
        }
        return this.generateAnnotationsFromEML(metadataPid);
    }

    private Map<Identifier, String> generateAnnotationsFromEML(Identifier metadataPid) throws Exception {
        String creatorText;
        List<ConceptItem> concepts;
        List creators;
        DataPackage dataPackage = this.getDataPackage(metadataPid);
        SystemMetadata sysMeta = D1Client.getCN().getSystemMetadata(null, metadataPid);
        String context = dataPackage.getAbstract();
        HashMap<Identifier, String> annotations = new HashMap<Identifier, String>();
        int entityCount = 1;
        Entity[] entities = dataPackage.getEntityList();
        if (entities != null) {
            for (Entity entity : entities) {
                String entityName = entity.getName();
                log.debug((Object)("Entity name: " + entityName));
                Attribute[] attributes = entity.getAttributeList().getAttributes();
                int attributeCount = 1;
                if (attributes != null) {
                    for (Attribute attribute : attributes) {
                        String attributeName = attribute.getName();
                        String attributeLabel = attribute.getLabel();
                        String attributeDefinition = attribute.getDefinition();
                        String attributeType = attribute.getAttributeType();
                        String attributeScale = attribute.getMeasurementScale();
                        String attributeUnitType = attribute.getUnitType();
                        String attributeUnit = attribute.getUnit();
                        String attributeDomain = attribute.getDomain().getClass().getSimpleName();
                        log.debug((Object)("Attribute name: " + attributeName));
                        log.debug((Object)("Attribute label: " + attributeLabel));
                        log.debug((Object)("Attribute definition: " + attributeDefinition));
                        log.debug((Object)("Attribute type: " + attributeType));
                        log.debug((Object)("Attribute scale: " + attributeScale));
                        log.debug((Object)("Attribute unit type: " + attributeUnitType));
                        log.debug((Object)("Attribute unit: " + attributeUnit));
                        log.debug((Object)("Attribute domain: " + attributeDomain));
                        StringBuffer attributeText = new StringBuffer();
                        attributeText.append(attributeName);
                        attributeText.append(" ");
                        attributeText.append(attributeLabel);
                        attributeText.append(" ");
                        attributeText.append(attributeDefinition);
                        attributeText.append(" ");
                        attributeText.append(attributeUnit);
                        boolean printTemplate = false;
                        if (printTemplate) {
                            log.info((Object)("Manual annotation template\t" + metadataPid.getValue() + "\t" + entityCount + "\t" + attributeCount + "\t" + attributeText + "\t" + attributeName + "\t" + this.conceptMatcher.getClass().getName()));
                            ++attributeCount;
                            continue;
                        }
                        List<ConceptItem> concepts2 = this.conceptMatcher.getConcepts(attributeText.toString(), attributeUnit, context);
                        if (concepts2 != null && concepts2.size() > 0) {
                            for (ConceptItem conceptItem : concepts2) {
                                log.info((Object)("Suggested annotation summary\t" + metadataPid.getValue() + "\t" + entityCount + "\t" + attributeCount + "\t" + attributeText + "\t" + conceptItem.getUri().toString() + "\t" + conceptItem.getLabel() + "\t" + conceptItem.getDefinition() + "\t" + this.conceptMatcher.getClass().getName()));
                            }
                            JSONObject annotation = this.constructAttributeAnnotation(sysMeta, entityCount, attributeCount, attributeName, concepts2);
                            StringWriter sw = new StringWriter();
                            annotation.writeJSONString((Appendable)sw);
                            Identifier pid = new Identifier();
                            pid.setValue(annotation.get((Object)"id").toString());
                            annotations.put(pid, sw.toString());
                        }
                        ++attributeCount;
                    }
                }
                ++entityCount;
            }
        }
        if (this.orcidMatcher != null && (creators = dataPackage.getCreators()) != null && creators.size() > 0 && (concepts = this.orcidMatcher.getConcepts(creatorText = ((Party)creators.get(0)).getOrganization() + " " + ((Party)creators.get(0)).getSurName() + " " + ((Party)creators.get(0)).getGivenNames(), null, null)) != null) {
            JSONObject annotation = this.createAnnotationTemplate(sysMeta);
            JSONArray creatorTags = new JSONArray();
            Iterator<ConceptItem> i$ = concepts.iterator();
            if (i$.hasNext()) {
                ConceptItem item = i$.next();
                String orcidUri = item.getUri().toString();
                creatorTags.add((Object)orcidUri);
            }
            annotation.put((Object)"tags", (Object)creatorTags);
            String xpointer = "#xpointer(/eml/dataset/creator[1]/individual/surname)";
            annotation.put((Object)"field", (Object)"orcid_sm");
            annotation.put((Object)"resource", (Object)xpointer);
            annotation.put((Object)"quote", (Object)((Party)creators.get(0)).getSurName());
            annotation.put((Object)"oa:Motivation", (Object)"prov:wasAttributedTo");
            JSONObject range = new JSONObject();
            range.put((Object)"start", (Object)"//*[@id='creator_1']/div[1]");
            range.put((Object)"end", (Object)"//*[@id='creator_1']/div[1]");
            range.put((Object)"startOffset", (Object)0);
            range.put((Object)"endOffset", (Object)((Party)creators.get(0)).getSurName().length());
            JSONArray ranges = new JSONArray();
            ranges.add((Object)range);
            annotation.put((Object)"ranges", (Object)ranges);
            StringWriter sw = new StringWriter();
            annotation.writeJSONString((Appendable)sw);
            Identifier pid = new Identifier();
            pid.setValue(annotation.get((Object)"id").toString());
            annotations.put(pid, sw.toString());
        }
        return annotations;
    }

    private Map<Identifier, String> generateAnnotationsCosine(Identifier metadataPid) throws Exception {
        SystemMetadata sysMeta = D1Client.getCN().getSystemMetadata(null, metadataPid);
        HashMap<Identifier, String> annotations = new HashMap<Identifier, String>();
        String jsonStr = CosineService.lookupCosine(metadataPid.getValue());
        org.json.JSONObject json = new org.json.JSONObject(jsonStr);
        org.json.JSONArray graph = json.getJSONArray("@graph");
        int entityCount = 1;
        int attributeCount = 1;
        String attributeName = null;
        for (int i = 0; i < graph.length(); ++i) {
            String label;
            org.json.JSONObject entry = graph.getJSONObject(i);
            if (!entry.has("http://purl.org/dc/terms/subject")) continue;
            String pointer = (String)entry.get("@id");
            pointer = pointer.substring(pointer.indexOf("#"));
            String indices = pointer.replaceAll("\\D+", "_");
            indices = indices.substring(1, indices.length() - 1);
            log.debug((Object)("indices=" + indices));
            entityCount = Integer.parseInt(indices.split("_")[0]);
            attributeCount = Integer.parseInt(indices.split("_")[1]);
            attributeName = label = (String)entry.get("rdfs:label");
            org.json.JSONArray subjects = null;
            Object subjObj = entry.get("http://purl.org/dc/terms/subject");
            if (subjObj instanceof org.json.JSONArray) {
                subjects = (org.json.JSONArray)subjObj;
            } else {
                subjects = new org.json.JSONArray();
                subjects.put(subjObj);
            }
            for (int j = 0; j < subjects.length(); ++j) {
                org.json.JSONObject a = subjects.getJSONObject(j);
                String url = a.getString("@id");
                double score = 0.0;
                System.out.println("url=" + url);
                ConceptItem c = new ConceptItem(new URI(url), score);
                ArrayList<ConceptItem> concepts = new ArrayList<ConceptItem>();
                concepts.add(c);
                JSONObject annotation = this.constructAttributeAnnotation(sysMeta, entityCount, attributeCount, attributeName, concepts);
                StringWriter sw = new StringWriter();
                annotation.writeJSONString((Appendable)sw);
                Identifier pid = new Identifier();
                pid.setValue(annotation.get((Object)"id").toString());
                annotations.put(pid, sw.toString());
            }
        }
        return annotations;
    }

    public JSONObject constructAttributeAnnotation(SystemMetadata sysMeta, int entityCount, int attributeCount, String attributeName, List<ConceptItem> concepts) throws Exception {
        JSONObject annotation = this.createAnnotationTemplate(sysMeta);
        String xpointer = "#xpointer(/eml/dataset/dataTable[" + entityCount + "]/attributeList/attribute[" + attributeCount + "])";
        String fieldName = "sem_annotation";
        String matcher = this.conceptMatcher.getClass().getName();
        if (this.conceptMatcher instanceof BioPortalService) {
            fieldName = "sem_annotation_bioportal_sm";
        }
        if (this.conceptMatcher instanceof EsorService) {
            fieldName = "sem_annotation_esor_sm";
        }
        if (this.conceptMatcher instanceof CosineService) {
            fieldName = "sem_annotation_cosine_sm";
        }
        annotation.put((Object)"field", (Object)fieldName);
        annotation.put((Object)"resource", (Object)xpointer);
        annotation.put((Object)"quote", (Object)attributeName);
        annotation.put((Object)"oa:Motivation", (Object)"oa:tagging");
        annotation.put((Object)"source", (Object)matcher);
        JSONObject range = new JSONObject();
        range.put((Object)"start", (Object)("//*[@id='sem_entity_" + entityCount + "_attribute_" + attributeCount + "']"));
        range.put((Object)"end", (Object)("//*[@id='sem_entity_" + entityCount + "_attribute_" + attributeCount + "']"));
        range.put((Object)"startOffset", (Object)0);
        range.put((Object)"endOffset", (Object)attributeName.length());
        JSONArray ranges = new JSONArray();
        ranges.add((Object)range);
        annotation.put((Object)"ranges", (Object)ranges);
        if (concepts != null && concepts.size() > 0) {
            JSONArray tags = new JSONArray();
            Iterator<ConceptItem> i$ = concepts.iterator();
            if (i$.hasNext()) {
                ConceptItem conceptItem = i$.next();
                tags.add((Object)conceptItem.getUri().toString());
            }
            annotation.put((Object)"tags", (Object)tags);
            return annotation;
        }
        return null;
    }

    private Map<Identifier, String> generateAnnotationsFromIndex(Identifier metadataPid) throws Exception {
        String creator;
        String creatorText;
        List<ConceptItem> concepts;
        JSONArray creators;
        JSONArray ranges;
        JSONObject range;
        String paramString = "?q=id:" + URLEncoder.encode("\"" + metadataPid.getValue() + "\"", "UTF-8") + "&fl=attribute,attributeName,origin,id" + "&wt=json";
        log.debug((Object)("paramString=" + paramString));
        InputStream solrStream = D1Client.getCN().query(null, "solr", paramString);
        JSONParser jsonParser = new JSONParser();
        Object results = jsonParser.parse(solrStream);
        solrStream.close();
        log.debug((Object)("results:" + results));
        JSONObject solrResults = (JSONObject)results;
        JSONObject solrDoc = null;
        try {
            solrDoc = (JSONObject)((JSONArray)((JSONObject)solrResults.get((Object)"response")).get((Object)"docs")).get(0);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        SystemMetadata sysMeta = D1Client.getCN().getSystemMetadata(null, metadataPid);
        String context = solrDoc.get((Object)"abstract").toString();
        HashMap<Identifier, String> annotations = new HashMap<Identifier, String>();
        JSONArray attributeNames = (JSONArray)solrDoc.get((Object)"attributeName");
        int attributeCount = 1;
        if (attributeNames != null) {
            for (Object attribute : attributeNames) {
                String attributeName = attribute.toString();
                log.debug((Object)("Attribute name: " + attributeName));
                JSONObject annotation = this.createAnnotationTemplate(sysMeta);
                String xpointer = "#xpointer(//attribute[" + attributeCount + "])";
                String fieldName = "sem_annotation";
                String matcher = this.conceptMatcher.getClass().getName();
                if (this.conceptMatcher instanceof BioPortalService) {
                    fieldName = "sem_annotation_bioportal_sm";
                }
                if (this.conceptMatcher instanceof EsorService) {
                    fieldName = "sem_annotation_esor_sm";
                }
                annotation.put((Object)"field", (Object)fieldName);
                annotation.put((Object)"resource", (Object)xpointer);
                annotation.put((Object)"quote", (Object)attributeName);
                annotation.put((Object)"oa:Motivation", (Object)"oa:tagging");
                annotation.put((Object)"source", (Object)matcher);
                range = new JSONObject();
                range.put((Object)"start", (Object)("//*[@id='attributeName_" + attributeCount + "']/div[1]"));
                range.put((Object)"end", (Object)("//*[@id='attributeName_" + attributeCount + "']/div[1]"));
                range.put((Object)"startOffset", (Object)0);
                range.put((Object)"endOffset", (Object)attributeName.length());
                ranges = new JSONArray();
                ranges.add((Object)range);
                annotation.put((Object)"ranges", (Object)ranges);
                List<ConceptItem> concepts2 = this.conceptMatcher.getConcepts(attributeName, null, context);
                if (concepts2 == null || concepts2.size() <= 0) continue;
                JSONArray tags = new JSONArray();
                Iterator<ConceptItem> i$ = concepts2.iterator();
                if (i$.hasNext()) {
                    ConceptItem conceptItem = i$.next();
                    tags.add((Object)conceptItem.getUri().toString());
                }
                annotation.put((Object)"tags", (Object)tags);
                StringWriter sw = new StringWriter();
                annotation.writeJSONString((Appendable)sw);
                Identifier pid = new Identifier();
                pid.setValue(annotation.get((Object)"id").toString());
                annotations.put(pid, sw.toString());
                ++attributeCount;
            }
        }
        if (this.orcidMatcher != null && (creators = (JSONArray)solrDoc.get((Object)"origin")) != null && creators.size() > 0 && (concepts = this.orcidMatcher.getConcepts(creatorText = (creator = creators.get(0).toString()), null, null)) != null && concepts.size() > 0) {
            JSONObject annotation = this.createAnnotationTemplate(sysMeta);
            JSONArray creatorTags = new JSONArray();
            for (ConceptItem item : concepts) {
                String orcidUri = item.getUri().toString();
                creatorTags.add((Object)orcidUri);
            }
            annotation.put((Object)"tags", (Object)creatorTags);
            String xpointer = "#xpointer(//origin[1])";
            annotation.put((Object)"field", (Object)"orcid_sm");
            annotation.put((Object)"resource", (Object)xpointer);
            annotation.put((Object)"quote", (Object)creator);
            annotation.put((Object)"oa:Motivation", (Object)"prov:wasAttributedTo");
            range = new JSONObject();
            range.put((Object)"start", (Object)"//*[@id='origin_1']/div[1]");
            range.put((Object)"end", (Object)"//*[@id='origin_1']/div[1]");
            range.put((Object)"startOffset", (Object)0);
            range.put((Object)"endOffset", (Object)creator.length());
            ranges = new JSONArray();
            ranges.add((Object)range);
            annotation.put((Object)"ranges", (Object)ranges);
            StringWriter sw = new StringWriter();
            annotation.writeJSONString((Appendable)sw);
            Identifier pid = new Identifier();
            pid.setValue(annotation.get((Object)"id").toString());
            annotations.put(pid, sw.toString());
        }
        return annotations;
    }

    private JSONObject createAnnotationTemplate(SystemMetadata sysMeta) throws Exception {
        JSONObject annotation = new JSONObject();
        String uuid = UUID.randomUUID().toString();
        Identifier annotationPid = new Identifier();
        annotationPid.setValue(uuid);
        annotation.put((Object)"id", (Object)annotationPid.getValue());
        annotation.put((Object)"pid", (Object)sysMeta.getIdentifier().getValue());
        annotation.put((Object)"uri", (Object)(Settings.getConfiguration().getProperty("D1Client.CN_URL") + "/v2/resolve/" + sysMeta.getIdentifier().getValue()));
        annotation.put((Object)"consumer", Settings.getConfiguration().getProperty("annotator.consumerKey"));
        JSONObject permissions = (JSONObject)JSONValue.parse((String)("{\"read\": [\"group:__world__\"], \"update\": [\"" + sysMeta.getRightsHolder().getValue() + "\"" + "], " + "\"delete\": [" + "\"" + sysMeta.getRightsHolder().getValue() + "\"" + "], " + "\"admin\": [" + "\"" + sysMeta.getRightsHolder().getValue() + "\"" + "]" + "}"));
        annotation.put((Object)"permissions", (Object)permissions);
        String now = DateTimeMarshaller.serializeDateToUTC((Date)Calendar.getInstance().getTime());
        annotation.put((Object)"created", (Object)now);
        annotation.put((Object)"updated", (Object)now);
        annotation.put((Object)"user", (Object)sysMeta.getRightsHolder().getValue());
        return annotation;
    }

    private DataPackage getDataPackage(Identifier pid) throws Exception {
        InputStream emlStream = D1Client.getCN().get(null, pid);
        Eml200DataPackageParser parser = new Eml200DataPackageParser();
        parser.parse(emlStream);
        emlStream.close();
        DataPackage dataPackage = parser.getDataPackage();
        return dataPackage;
    }

    public static void main(String[] args) throws Exception {
        JsonAnnotatorGenerator.testGenerate();
        System.exit(0);
    }

    public static void testGenerate() throws Exception {
        Settings.getConfiguration().setProperty("D1Client.CN_URL", (Object)"https://cn-sandbox-2.test.dataone.org/cn");
        Identifier metadataPid = new Identifier();
        metadataPid.setValue("https://pasta.lternet.edu/package/metadata/eml/knb-lter-arc/20032/2");
        JsonAnnotatorGenerator ds = new JsonAnnotatorGenerator();
        for (String jsonString : ds.generateAnnotations(metadataPid).values()) {
            log.debug((Object)("JSON annotation: \n" + jsonString));
        }
    }
}

