/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class QueryIterConcat
extends QueryIter {
    boolean initialized = false;
    List iteratorList = new ArrayList();
    Iterator iterator;
    QueryIterator currentQIter = null;
    Binding binding;
    boolean doneFirst = false;

    public QueryIterConcat(ExecutionContext context) {
        super(context);
    }

    private void init() {
        if (!this.initialized) {
            this.currentQIter = null;
            if (this.iterator == null) {
                this.iterator = this.iteratorList.listIterator();
            }
            if (this.iterator.hasNext()) {
                this.currentQIter = (QueryIterator)this.iterator.next();
            }
            this.initialized = true;
        }
    }

    public void add(QueryIterator qIter) {
        if (qIter != null) {
            this.iteratorList.add(qIter);
        }
    }

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        this.init();
        if (this.currentQIter == null) {
            return false;
        }
        while (!this.currentQIter.hasNext()) {
            this.currentQIter = null;
            if (this.iterator.hasNext()) {
                this.currentQIter = (QueryIterator)this.iterator.next();
            }
            if (this.currentQIter != null) continue;
            return false;
        }
        return true;
    }

    protected Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Utils.className(this));
        }
        if (this.currentQIter == null) {
            throw new NoSuchElementException(Utils.className(this));
        }
        Binding binding = this.currentQIter.nextBinding();
        return binding;
    }

    protected void closeIterator() {
        Iterator iter = this.iteratorList.iterator();
        while (iter.hasNext()) {
            QueryIterator qIter = (QueryIterator)iter.next();
            if (qIter == null) continue;
            qIter.close();
        }
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Utils.className(this));
        out.incIndent();
        Iterator iter = this.iteratorList.iterator();
        while (iter.hasNext()) {
            QueryIterator qIter = (QueryIterator)iter.next();
            qIter.output(out, sCxt);
        }
        out.decIndent();
        out.ensureStartOfLine();
    }
}

