/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.op;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.modify.op.UpdatePattern;
import com.hp.hpl.jena.sparql.syntax.Template;
import java.util.Collection;
import java.util.List;

public abstract class UpdateModifyBase
extends UpdatePattern {
    protected Template deletes = null;
    protected Template inserts = null;

    protected UpdateModifyBase() {
    }

    protected UpdateModifyBase(Template inserts, Template deletes) {
        this.inserts = inserts;
        this.deletes = deletes;
    }

    protected void setDeleteTemplateBase(Template template) {
        this.deletes = template;
    }

    protected void setInsertTemplateBase(Template template) {
        this.inserts = template;
    }

    protected void setDeleteTemplateBase(String template) {
        this.deletes = QueryFactory.createTemplate(template);
    }

    protected void setInsertTemplateBase(String template) {
        this.inserts = QueryFactory.createTemplate(template);
    }

    protected Template getDeleteTemplateBase() {
        return this.deletes;
    }

    protected Template getInsertTemplateBase() {
        return this.inserts;
    }

    protected void exec(Graph graph, List bindings) {
        this.execDeletes(graph, bindings);
        this.execInserts(graph, bindings);
    }

    private void execDeletes(Graph graph, List bindings) {
        if (this.deletes != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
            Collection acc = UpdateModifyBase.subst(this.deletes, qIter);
            graph.getBulkUpdateHandler().delete(acc.iterator());
        }
    }

    private void execInserts(Graph graph, List bindings) {
        if (this.inserts != null) {
            QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
            Collection acc = UpdateModifyBase.subst(this.inserts, qIter);
            graph.getBulkUpdateHandler().add(acc.iterator());
        }
    }
}

