/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BasicPatternJoin {
    public static final String bSS = "http://jena.hpl.hp.com/ARQo/join#bSS";
    public static final String bSP = "http://jena.hpl.hp.com/ARQo/join#bSP";
    public static final String bSO = "http://jena.hpl.hp.com/ARQo/join#bSO";
    public static final String bPS = "http://jena.hpl.hp.com/ARQo/join#bPS";
    public static final String bPP = "http://jena.hpl.hp.com/ARQo/join#bPP";
    public static final String bPO = "http://jena.hpl.hp.com/ARQo/join#bPO";
    public static final String bOS = "http://jena.hpl.hp.com/ARQo/join#bOS";
    public static final String bOP = "http://jena.hpl.hp.com/ARQo/join#bOP";
    public static final String bOO = "http://jena.hpl.hp.com/ARQo/join#bOO";
    public static final String uSS = "http://jena.hpl.hp.com/ARQo/join#uSS";
    public static final String uSP = "http://jena.hpl.hp.com/ARQo/join#uSP";
    public static final String uSO = "http://jena.hpl.hp.com/ARQo/join#uSO";
    public static final String uPS = "http://jena.hpl.hp.com/ARQo/join#uPS";
    public static final String uPP = "http://jena.hpl.hp.com/ARQo/join#uPP";
    public static final String uPO = "http://jena.hpl.hp.com/ARQo/join#uPO";
    public static final String uOS = "http://jena.hpl.hp.com/ARQo/join#uOS";
    public static final String uOP = "http://jena.hpl.hp.com/ARQo/join#uOP";
    public static final String uOO = "http://jena.hpl.hp.com/ARQo/join#uOO";
    public static final String SS = "http://jena.hpl.hp.com/ARQo/join#SS";
    public static final String SP = "http://jena.hpl.hp.com/ARQo/join#SP";
    public static final String SO = "http://jena.hpl.hp.com/ARQo/join#SO";
    public static final String PS = "http://jena.hpl.hp.com/ARQo/join#PS";
    public static final String PP = "http://jena.hpl.hp.com/ARQo/join#PP";
    public static final String PO = "http://jena.hpl.hp.com/ARQo/join#PO";
    public static final String OS = "http://jena.hpl.hp.com/ARQo/join#OS";
    public static final String OP = "http://jena.hpl.hp.com/ARQo/join#OP";
    public static final String OO = "http://jena.hpl.hp.com/ARQo/join#OO";

    public static boolean isJoined(GraphNode node1, GraphNode node2) {
        Triple triple1 = node1.triple();
        Triple triple2 = node2.triple();
        return BasicPatternJoin.isJoined(triple1, triple2);
    }

    public static boolean isJoined(Triple triple1, Triple triple2) {
        if (triple1.subjectMatches(triple2.getSubject())) {
            return true;
        }
        if (triple1.subjectMatches(triple2.getPredicate())) {
            return true;
        }
        if (triple1.subjectMatches(triple2.getObject())) {
            return true;
        }
        if (triple1.predicateMatches(triple2.getSubject())) {
            return true;
        }
        if (triple1.predicateMatches(triple2.getPredicate())) {
            return true;
        }
        if (triple1.predicateMatches(triple2.getObject())) {
            return true;
        }
        if (triple1.objectMatches(triple2.getSubject())) {
            return true;
        }
        if (triple1.objectMatches(triple2.getPredicate())) {
            return true;
        }
        return triple1.objectMatches(triple2.getObject());
    }

    public static List specificTypes(Triple triple1, Triple triple2) {
        ArrayList<String> types = new ArrayList<String>();
        if (triple1.getSubject().isVariable()) {
            if (triple1.subjectMatches(triple2.getSubject())) {
                types.add(uSS);
            }
            if (triple1.subjectMatches(triple2.getPredicate())) {
                types.add(uSP);
            }
            if (triple1.subjectMatches(triple2.getObject())) {
                types.add(uSO);
            }
        } else {
            if (triple1.subjectMatches(triple2.getSubject())) {
                types.add(bSS);
            }
            if (triple1.subjectMatches(triple2.getPredicate())) {
                types.add(bSP);
            }
            if (triple1.subjectMatches(triple2.getObject())) {
                types.add(bSO);
            }
        }
        if (triple1.getPredicate().isVariable()) {
            if (triple1.predicateMatches(triple2.getSubject())) {
                types.add(uPS);
            }
            if (triple1.predicateMatches(triple2.getPredicate())) {
                types.add(uPP);
            }
            if (triple1.predicateMatches(triple2.getObject())) {
                types.add(uPO);
            }
        } else {
            if (triple1.predicateMatches(triple2.getSubject())) {
                types.add(bPS);
            }
            if (triple1.predicateMatches(triple2.getPredicate())) {
                types.add(bPP);
            }
            if (triple1.predicateMatches(triple2.getObject())) {
                types.add(bPO);
            }
        }
        if (triple1.getObject().isVariable()) {
            if (triple1.objectMatches(triple2.getSubject())) {
                types.add(uOS);
            }
            if (triple1.objectMatches(triple2.getPredicate())) {
                types.add(uOP);
            }
            if (triple1.objectMatches(triple2.getObject())) {
                types.add(uOO);
            }
        } else {
            if (triple1.objectMatches(triple2.getSubject())) {
                types.add(bOS);
            }
            if (triple1.objectMatches(triple2.getPredicate())) {
                types.add(bOP);
            }
            if (triple1.objectMatches(triple2.getObject())) {
                types.add(bOO);
            }
        }
        return types;
    }

    public static String specificType(Triple triple1, Triple triple2) {
        List types = BasicPatternJoin.specificTypes(triple1, triple2);
        if (types.size() > 0) {
            return (String)types.get(0);
        }
        return null;
    }

    public static String specificTypeIgnorePP(Triple triple1, Triple triple2) {
        List types = BasicPatternJoin.specificTypes(triple1, triple2);
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (type.equals(uPP) || type.equals(bPP)) continue;
            return type;
        }
        return null;
    }

    public static List genericTypes(Triple triple1, Triple triple2) {
        ArrayList<String> types = new ArrayList<String>();
        if (triple1.subjectMatches(triple2.getSubject())) {
            types.add(SS);
        }
        if (triple1.subjectMatches(triple2.getPredicate())) {
            types.add(SP);
        }
        if (triple1.subjectMatches(triple2.getObject())) {
            types.add(SO);
        }
        if (triple1.predicateMatches(triple2.getSubject())) {
            types.add(PS);
        }
        if (triple1.predicateMatches(triple2.getPredicate())) {
            types.add(PP);
        }
        if (triple1.predicateMatches(triple2.getObject())) {
            types.add(PO);
        }
        if (triple1.objectMatches(triple2.getSubject())) {
            types.add(OS);
        }
        if (triple1.objectMatches(triple2.getPredicate())) {
            types.add(OP);
        }
        if (triple1.objectMatches(triple2.getObject())) {
            types.add(OO);
        }
        return types;
    }

    public static String genericType(Triple triple1, Triple triple2) {
        List types = BasicPatternJoin.genericTypes(triple1, triple2);
        if (types.size() > 0) {
            return (String)types.get(0);
        }
        return null;
    }

    public static String genericTypeIgnorePP(Triple triple1, Triple triple2) {
        List types = BasicPatternJoin.genericTypes(triple1, triple2);
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (type.equals(PP)) continue;
            return type;
        }
        return null;
    }

    public static int numOfVars(Triple triple1, Triple triple2) {
        int numOfVars = 1;
        if (triple1.getSubject().isVariable()) {
            ++numOfVars;
        }
        if (triple1.getPredicate().isVariable()) {
            ++numOfVars;
        }
        if (triple1.getObject().isVariable()) {
            ++numOfVars;
        }
        if (triple2.getSubject().isVariable()) {
            ++numOfVars;
        }
        if (triple2.getPredicate().isVariable()) {
            ++numOfVars;
        }
        if (triple2.getObject().isVariable()) {
            ++numOfVars;
        }
        return numOfVars;
    }

    public static boolean varsOnly(Triple triple1, Triple triple2) {
        return BasicPatternJoin.numOfVars(triple1, triple2) == 6;
    }
}

