/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.sse.writers.WriterLib;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.Iterator;
import java.util.Map;

public class WriterBasePrefix {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;

    public static void output(IndentedWriter iWriter, Fmt fmt, Prologue prologue) {
        boolean printBase = false;
        boolean closeBase = WriterBasePrefix.printBase(iWriter, prologue);
        boolean closePrefix = WriterBasePrefix.printPrefix(iWriter, prologue);
        fmt.format();
        if (closeBase) {
            WriterLib.finish(iWriter, "base");
        }
        if (closePrefix) {
            WriterLib.finish(iWriter, "prefix");
        }
        iWriter.ensureStartOfLine();
        iWriter.flush();
    }

    private static boolean printBase(IndentedWriter iWriter, Prologue prologue) {
        String baseURI = prologue.getBaseURI();
        if (baseURI != null) {
            WriterLib.start(iWriter, "base", -1);
            iWriter.print(FmtUtils.stringForURI(baseURI));
            iWriter.println();
            return true;
        }
        return false;
    }

    private static boolean printPrefix(IndentedWriter iWriter, Prologue prologue) {
        Map m;
        PrefixMapping prefixMapping = prologue.getPrefixMapping();
        if (prefixMapping != null && !(m = prefixMapping.getNsPrefixMap()).isEmpty()) {
            int s = iWriter.getCol();
            WriterLib.start(iWriter, "prefix", -1);
            WriterLib.start(iWriter);
            int len = iWriter.getCurrentOffset();
            iWriter.incIndent(len);
            Iterator iter = m.keySet().iterator();
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    iWriter.println();
                }
                first = false;
                String prefix = (String)iter.next();
                String uri = prefixMapping.getNsPrefixURI(prefix);
                uri = FmtUtils.stringForURI(uri, prologue.getBaseURI());
                WriterLib.start(iWriter);
                iWriter.print(prefix);
                iWriter.print(": ");
                iWriter.print(uri);
                WriterLib.finish(iWriter);
            }
            iWriter.decIndent(len);
            WriterLib.finish(iWriter);
            iWriter.ensureStartOfLine();
            return true;
        }
        return false;
    }

    public static interface Fmt {
        public void format();
    }
}

