/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;

public class FileHeader
implements LoggableObject,
LogReadable {
    private static final int LOG_VERSION = 1;
    private long fileNum;
    private long lastEntryInPrevFileOffset;
    private Timestamp time;
    private int logVersion;

    FileHeader(long fileNum, long lastEntryInPrevFileOffset) {
        this.fileNum = fileNum;
        this.lastEntryInPrevFileOffset = lastEntryInPrevFileOffset;
        Calendar now = Calendar.getInstance();
        this.time = new Timestamp(now.getTimeInMillis());
        this.logVersion = 1;
    }

    public FileHeader() {
    }

    void validate(String fileName, long expectedFileNum) throws DatabaseException {
        if (this.fileNum != expectedFileNum) {
            throw new LogException("Wrong filenum in header for file " + fileName + " expected " + expectedFileNum + " got " + this.fileNum);
        }
    }

    long getLastEntryInPrevFileOffset() {
        return this.lastEntryInPrevFileOffset;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_FILE_HEADER;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(DbLsn justLoggedLsn) throws DatabaseException {
    }

    static int entrySize() {
        return LogUtils.getTimestampLogSize() + 4 + 8 + 4;
    }

    public int getLogSize() {
        return FileHeader.entrySize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writeUnsignedInt(logBuffer, this.fileNum);
        LogUtils.writeLong(logBuffer, this.lastEntryInPrevFileOffset);
        LogUtils.writeInt(logBuffer, this.logVersion);
    }

    public void readFromLog(ByteBuffer logBuffer) throws LogException {
        this.time = LogUtils.readTimestamp(logBuffer);
        this.fileNum = LogUtils.getUnsignedInt(logBuffer);
        this.lastEntryInPrevFileOffset = LogUtils.readLong(logBuffer);
        this.logVersion = LogUtils.readInt(logBuffer);
        if (this.logVersion != 1) {
            throw new LogException("Expected log version 1 but found " + this.logVersion + " -- this version is not supported.");
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<FileHeader num=\"0x");
        sb.append(Long.toHexString(this.fileNum));
        sb.append("\" lastEntryInPrevFileOffset=\"0x");
        sb.append(Long.toHexString(this.lastEntryInPrevFileOffset));
        sb.append("\" logVersion=\"0x");
        sb.append(Integer.toHexString(this.logVersion));
        sb.append("\" time=\"").append(this.time);
        sb.append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.dumpLog(sb, true);
        return sb.toString();
    }
}

