/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemLogEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.utilint.Tracer;
import java.util.Hashtable;
import java.util.Map;

public class LogEntryType {
    private static Map LOG_TYPES = new Hashtable();
    public static final LogEntryType LOG_LN_TRANSACTIONAL = new LogEntryType(1, 0, "LN_TX", new LNLogEntry(LN.class, true));
    public static final LogEntryType LOG_LN = new LogEntryType(2, 0, "LN", new LNLogEntry(LN.class, false));
    public static final LogEntryType LOG_MAPLN_TRANSACTIONAL = new LogEntryType(3, 0, "MapLN_TX", new LNLogEntry(MapLN.class, true));
    public static final LogEntryType LOG_MAPLN = new LogEntryType(4, 0, "MapLN", new LNLogEntry(MapLN.class, false));
    public static final LogEntryType LOG_NAMELN_TRANSACTIONAL = new LogEntryType(5, 0, "NameLN_TX", new LNLogEntry(NameLN.class, true));
    public static final LogEntryType LOG_NAMELN = new LogEntryType(6, 0, "NameLN", new LNLogEntry(NameLN.class, false));
    public static final LogEntryType LOG_DEL_DUPLN_TRANSACTIONAL = new LogEntryType(7, 0, "DelDupLN_TX", new DeletedDupLNLogEntry(true));
    public static final LogEntryType LOG_DEL_DUPLN = new LogEntryType(8, 0, "DelDupLN", new DeletedDupLNLogEntry(false));
    public static final LogEntryType LOG_DUPCOUNTLN_TRANSACTIONAL = new LogEntryType(9, 0, "DupCountLN_TX", new LNLogEntry(DupCountLN.class, true));
    public static final LogEntryType LOG_DUPCOUNTLN = new LogEntryType(10, 0, "DupCountLN", new LNLogEntry(DupCountLN.class, false));
    public static final LogEntryType LOG_FILESUMMARYLN = new LogEntryType(11, 0, "FileSummaryLN", new LNLogEntry(FileSummaryLN.class, false));
    public static final LogEntryType LOG_IN = new LogEntryType(12, 0, "IN", new INLogEntry(IN.class));
    public static final LogEntryType LOG_BIN = new LogEntryType(13, 0, "BIN", new INLogEntry(BIN.class));
    public static final LogEntryType LOG_DIN = new LogEntryType(14, 0, "DIN", new INLogEntry(DIN.class));
    public static final LogEntryType LOG_DBIN = new LogEntryType(15, 0, "DBIN", new INLogEntry(DBIN.class));
    private static final int MAX_NODE_TYPE_NUM = 15;
    public static final LogEntryType LOG_ROOT = new LogEntryType(16, 0, "Root", new SingleItemLogEntry(DbTree.class));
    public static final LogEntryType LOG_TXN_COMMIT = new LogEntryType(17, 0, "Commit", new SingleItemLogEntry(TxnCommit.class));
    public static final LogEntryType LOG_TXN_ABORT = new LogEntryType(18, 0, "Abort", new SingleItemLogEntry(TxnAbort.class));
    public static final LogEntryType LOG_CKPT_START = new LogEntryType(19, 0, "CkptStart", new SingleItemLogEntry(CheckpointStart.class));
    public static final LogEntryType LOG_CKPT_END = new LogEntryType(20, 0, "CkptEnd", new SingleItemLogEntry(CheckpointEnd.class));
    public static final LogEntryType LOG_IN_DELETE_INFO = new LogEntryType(21, 0, "INDelete", new SingleItemLogEntry(INDeleteInfo.class));
    public static final LogEntryType LOG_BIN_DELTA = new LogEntryType(22, 0, "BINDelta", new BINDeltaLogEntry(BINDelta.class));
    public static final LogEntryType LOG_DUP_BIN_DELTA = new LogEntryType(23, 0, "DupBINDelta", new BINDeltaLogEntry(BINDelta.class));
    public static final LogEntryType LOG_TRACE = new LogEntryType(24, 0, "Trace", new SingleItemLogEntry(Tracer.class));
    public static final LogEntryType LOG_FILE_HEADER = new LogEntryType(25, 0, "FileHeader", new SingleItemLogEntry(FileHeader.class));
    private static final int MAX_TYPE_NUM = 25;
    private static final byte PROVISIONAL_MASK = -128;
    private static final byte IGNORE_PROVISIONAL = 127;
    private byte typeNum;
    private byte version;
    private String displayName;
    private LogEntry logEntry;

    public static boolean isNodeType(byte typeNum, byte version) {
        return typeNum <= 15;
    }

    LogEntryType(byte typeNum, byte version) {
        this.typeNum = typeNum;
        this.version = version;
    }

    private LogEntryType(byte typeNum, byte version, String displayName, LogEntry logEntry) {
        this.typeNum = typeNum;
        this.version = version;
        this.logEntry = logEntry;
        this.displayName = displayName;
        LOG_TYPES.put(this, this);
    }

    public boolean isNodeType() {
        return this.typeNum <= 15;
    }

    static LogEntryType findType(byte typeNum, byte version) {
        return (LogEntryType)LOG_TYPES.get(new LogEntryType(typeNum, version));
    }

    LogEntry getSharedLogEntry() {
        return this.logEntry;
    }

    LogEntry getNewLogEntry() throws DatabaseException {
        try {
            return (LogEntry)this.logEntry.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException(e);
        }
    }

    static byte setProvisional(byte version) {
        return (byte)(version | 0xFFFFFF80);
    }

    static boolean isProvisional(byte version) {
        return (version & 0xFFFFFF80) != 0;
    }

    byte getTypeNum() {
        return this.typeNum;
    }

    byte getVersion() {
        return this.version;
    }

    static boolean isValidType(byte typeNum) {
        return typeNum <= 25;
    }

    public String toString() {
        return this.displayName + "/" + this.version;
    }

    boolean equalsType(byte typeNum, byte version) {
        return this.typeNum == typeNum && (this.version & 0x7F) == (version & 0x7F);
    }

    boolean equalsType(byte typeNum) {
        return this.typeNum == typeNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogEntryType)) {
            return false;
        }
        return this.typeNum == ((LogEntryType)obj).typeNum && (this.version & 0x7F) == (((LogEntryType)obj).version & 0x7F);
    }

    public int hashCode() {
        return this.typeNum + (this.version & 0x7F);
    }
}

