/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public abstract class TxnEnd
implements LoggableObject,
LogReadable {
    private long id;
    private Timestamp time;
    private DbLsn lastLsn;

    TxnEnd(long id, DbLsn lastLsn) {
        this.id = id;
        this.time = new Timestamp(System.currentTimeMillis());
        this.lastLsn = lastLsn;
    }

    public TxnEnd() {
        this.lastLsn = new DbLsn();
    }

    public long getId() {
        return this.id;
    }

    DbLsn getLastLsn() {
        return this.lastLsn;
    }

    protected abstract String getTagName();

    public abstract LogEntryType getLogType();

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(DbLsn justLoggedLsn) {
    }

    public int getLogSize() {
        return 8 + LogUtils.getTimestampLogSize() + this.lastLsn.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.id);
        LogUtils.writeTimestamp(logBuffer, this.time);
        this.lastLsn.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer logBuffer) {
        this.id = LogUtils.readLong(logBuffer);
        this.time = LogUtils.readTimestamp(logBuffer);
        this.lastLsn.readFromLog(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<").append(this.getTagName());
        sb.append(" id=\"").append(this.id);
        sb.append("\" time=\"").append(this.time);
        sb.append("\">");
        this.lastLsn.dumpLog(sb, verbose);
        sb.append("</").append(this.getTagName()).append(">");
    }

    public boolean logEntryIsTransactional() {
        return true;
    }

    public long getTransactionId() {
        return this.id;
    }
}

