/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.impl;

import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.util.XMLChar;

public class PrefixMappingImpl
implements PrefixMapping {
    protected Map prefixToURI = CollectionFactory.createHashedMap();
    protected Map URItoPrefix = CollectionFactory.createHashedMap();
    protected boolean locked;

    protected void set(String prefix, String uri) {
        this.prefixToURI.put(prefix, uri);
        this.URItoPrefix.put(uri, prefix);
    }

    protected String get(String prefix) {
        return (String)this.prefixToURI.get(prefix);
    }

    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        this.checkLegal(prefix);
        if (!prefix.equals("")) {
            this.checkProper(uri);
        }
        if (uri == null) {
            throw new NullPointerException("null URIs are prohibited as arguments to setNsPrefix");
        }
        this.set(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        String uri = (String)this.prefixToURI.remove(prefix);
        this.regenerateReverseMapping();
        return this;
    }

    protected void regenerateReverseMapping() {
        this.URItoPrefix.clear();
        Iterator it = this.prefixToURI.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.URItoPrefix.put(e.getValue(), e.getKey());
        }
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException(this);
        }
    }

    private void checkProper(String uri) {
    }

    public static boolean isNiceURI(String uri) {
        if (uri.equals("")) {
            return false;
        }
        char last = uri.charAt(uri.length() - 1);
        return Util.notNameChar(last);
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        this.checkUnlocked();
        Iterator it = other.getNsPrefixMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String prefix = (String)e.getKey();
            String uri = (String)e.getValue();
            if (this.getNsPrefixURI(prefix) != null || this.getNsURIPrefix(uri) != null) continue;
            this.setNsPrefix(prefix, uri);
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(Map other) {
        this.checkUnlocked();
        Iterator it = other.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.setNsPrefix((String)e.getKey(), (String)e.getValue());
        }
        return this;
    }

    private void checkLegal(String prefix) {
        if (prefix.length() > 0 && !XMLChar.isValidNCName((String)prefix)) {
            throw new PrefixMapping.IllegalPrefixException(prefix);
        }
    }

    public String getNsPrefixURI(String prefix) {
        return this.get(prefix);
    }

    public Map getNsPrefixMap() {
        return CollectionFactory.createHashedMap(this.prefixToURI);
    }

    public String getNsURIPrefix(String uri) {
        return (String)this.URItoPrefix.get(uri);
    }

    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String uri = this.get(prefixed.substring(0, colon));
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    public String toString() {
        return "pm:" + this.prefixToURI;
    }

    public String qnameFor(String uri) {
        int split = Util.splitNamespace(uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = (String)this.URItoPrefix.get(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    public String shortForm(String uri) {
        Map.Entry e = this.findMapping(uri, true);
        return e == null ? uri : e.getKey() + ":" + uri.substring(((String)e.getValue()).length());
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return other instanceof PrefixMappingImpl ? this.equals((PrefixMappingImpl)other) : this.equalsByMap(other);
    }

    protected boolean equals(PrefixMappingImpl other) {
        return other.sameAs(this);
    }

    protected boolean sameAs(PrefixMappingImpl other) {
        return ((Object)this.prefixToURI).equals(other.prefixToURI);
    }

    protected final boolean equalsByMap(PrefixMapping other) {
        return ((Object)this.getNsPrefixMap()).equals(other.getNsPrefixMap());
    }

    private Map.Entry findMapping(String uri, boolean partial) {
        Iterator it = this.prefixToURI.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String ss = (String)e.getValue();
            if (!uri.startsWith(ss) || !partial && ss.length() != uri.length()) continue;
            return e;
        }
        return null;
    }
}

