/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestFBRules
extends TestCase {
    protected static Log logger = LogFactory.getLog((Class)TestFBRules.class);
    protected Node p = Node.createURI((String)"p");
    protected Node q = Node.createURI((String)"q");
    protected Node n1 = Node.createURI((String)"n1");
    protected Node n2 = Node.createURI((String)"n2");
    protected Node n3 = Node.createURI((String)"n3");
    protected Node n4 = Node.createURI((String)"n4");
    protected Node n5 = Node.createURI((String)"n5");
    protected Node res = Node.createURI((String)"res");
    protected Node r = Node.createURI((String)"r");
    protected Node s = Node.createURI((String)"s");
    protected Node t = Node.createURI((String)"t");
    protected Node u = Node.createURI((String)"u");
    protected Node v = Node.createURI((String)"v");
    protected Node w = Node.createURI((String)"w");
    protected Node x = Node.createURI((String)"x");
    protected Node a = Node.createURI((String)"a");
    protected Node b = Node.createURI((String)"b");
    protected Node c = Node.createURI((String)"c");
    protected Node d = Node.createURI((String)"d");
    protected Node C1 = Node.createURI((String)"C1");
    protected Node C2 = Node.createURI((String)"C2");
    protected Node C3 = Node.createURI((String)"C3");
    protected Node sP = RDFS.Nodes.subPropertyOf;
    protected Node sC = RDFS.Nodes.subClassOf;
    protected Node ty = RDF.Nodes.type;

    public TestFBRules(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFBRules.class);
    }

    public Reasoner createReasoner(List rules) {
        FBRuleReasoner reasoner = new FBRuleReasoner(rules);
        reasoner.tablePredicate(RDFS.Nodes.subClassOf);
        reasoner.tablePredicate(RDF.Nodes.type);
        reasoner.tablePredicate(this.p);
        return reasoner;
    }

    public InfGraph createInfGraph(String rules, Graph data) {
        return this.createReasoner(Rule.parseRules((String)rules)).bind(data);
    }

    public InfGraph createInfGraph(String rules) {
        return this.createReasoner(Rule.parseRules((String)rules)).bind(Factory.createGraphMem());
    }

    public void testParser() {
        String rf = "(?a rdf:type ?t) -> (?t rdf:type rdfs:Class).";
        String rb = "(?t rdf:type rdfs:Class) <- (?a rdf:type ?t).";
        TestFBRules.assertTrue((!Rule.parseRule((String)rf).isBackward() ? 1 : 0) != 0);
        TestFBRules.assertTrue((boolean)Rule.parseRule((String)rb).isBackward());
    }

    public void testRuleMatcher() {
        String rules = "[r1: (?a p ?b), (?b q ?c) -> (?a, q, ?c)][r2: (?a p ?b), (?b p ?c) -> (?a, p, ?c)][r3: (?a p ?a), (n1 p ?c), (n1, p, ?a) -> (?a, p, ?c)][r4: (n4 ?p ?a) -> (n4, ?a, ?p)]";
        InfGraph infgraph = this.createInfGraph(rules);
        infgraph.add(new Triple(this.n1, this.p, this.n2));
        infgraph.add(new Triple(this.n2, this.p, this.n3));
        infgraph.add(new Triple(this.n2, this.q, this.n3));
        infgraph.add(new Triple(this.n4, this.p, this.n4));
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4), new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3), new Triple(this.n4, this.n4, this.p)});
    }

    public void testEmbeddedFunctors() {
        String rules = "(?C owl:onProperty ?P), (?C owl:allValuesFrom ?D) -> (?C rb:restriction all(?P, ?D)).(?C rb:restriction all(eg:p, eg:D)) -> (?C rb:restriction 'allOK').[ -> (eg:foo eg:prop functor(eg:bar, 1)) ][ (?x eg:prop functor(eg:bar, ?v)) -> (?x eg:propbar ?v) ][ (?x eg:prop functor(?v, ?*)) -> (?x eg:propfunc ?v) ]";
        Model data = ModelFactory.createDefaultModel();
        Resource R1 = data.createResource("urn:x-hp:eg/R1");
        Resource D = data.createResource("urn:x-hp:eg/D");
        Property p = data.createProperty("urn:x-hp:eg/", "p");
        Property propbar = data.createProperty("urn:x-hp:eg/", "propbar");
        Property rbr = data.createProperty("urn:x-hp-jena:rubrik/", "restriction");
        R1.addProperty(OWL.onProperty, (RDFNode)p).addProperty(OWL.allValuesFrom, (RDFNode)D);
        InfGraph infgraph = this.createInfGraph(rules, data.getGraph());
        Model infModel = ModelFactory.createModelForGraph((Graph)infgraph);
        Resource foo = infModel.createResource("urn:x-hp:eg/foo");
        RDFNode flit = infModel.getResource(R1.getURI()).getRequiredProperty(rbr).getObject();
        TestFBRules.assertNotNull((Object)flit);
        TestFBRules.assertEquals((String)flit.toString(), (String)"allOK");
        Literal one = (Literal)foo.getRequiredProperty(propbar).getObject();
        TestFBRules.assertEquals((Object)new Integer(1), (Object)one.getValue());
    }

    public void testBuiltins() {
        String rules = "[r1: (n1 p ?x), addOne(?x, ?y) -> (n1 q ?y)][r2: (n1 p ?x), lessThan(?x, 3) -> (n2 q ?x)][axiom1: -> (n1 p 1)][axiom2: -> (n1 p 4)]";
        InfGraph infgraph = this.createInfGraph(rules);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, this.q, null), new Triple[]{new Triple(this.n1, this.q, Util.makeIntNode((int)2)), new Triple(this.n1, this.q, Util.makeIntNode((int)5))});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n2, this.q, null), new Triple[]{new Triple(this.n2, this.q, Util.makeIntNode((int)1))});
    }

    public void testSchemaBinding() {
        String rules = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][testBRule4: (n3 p ?a) <- (n1, p, ?a)]";
        List ruleList = Rule.parseRules((String)rules);
        Graph schema = Factory.createGraphMem();
        schema.add(new Triple(this.n1, this.p, this.n3));
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.q, this.n4));
        data.add(new Triple(this.n1, this.q, this.n3));
        Reasoner reasoner = this.createReasoner(ruleList);
        Reasoner boundReasoner = reasoner.bindSchema(schema);
        InfGraph infgraph = boundReasoner.bind(data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n3, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
    }

    public void testRemoveBuiltin() {
        String rules = "[rule1: (?x p ?y), (?x q ?y) -> remove(0)]";
        InfGraph infgraph = this.createInfGraph(rules);
        infgraph.add(new Triple(this.n1, this.p, Util.makeIntNode((int)1)));
        infgraph.add(new Triple(this.n1, this.p, Util.makeIntNode((int)2)));
        infgraph.add(new Triple(this.n1, this.q, Util.makeIntNode((int)2)));
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode((int)1)), new Triple(this.n1, this.q, Util.makeIntNode((int)2))});
    }

    public void testRebind() {
        String rules = "[rule1: (?x p ?y) -> (?x q ?y)]";
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n1, this.q, this.n2)});
        Graph ndata = Factory.createGraphMem();
        ndata.add(new Triple(this.n1, this.p, this.n3));
        infgraph.rebind(ndata);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3)});
    }

    public void testRebind2() {
        String NS = "http://jena.hpl.hp.com/test#";
        Model base = ModelFactory.createDefaultModel();
        Resource A = base.createResource(NS + "A");
        Resource B = base.createResource(NS + "B");
        Resource I = base.createResource(NS + "i");
        A.addProperty(RDFS.subClassOf, (RDFNode)B);
        I.addProperty(RDF.type, (RDFNode)A);
        InfModel inf = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getRDFSReasoner(), (Model)base);
        TestFBRules.assertTrue((inf.containsResource((RDFNode)A) && inf.containsResource((RDFNode)I) ? 1 : 0) != 0);
        base.removeAll();
        inf.rebind();
        TestFBRules.assertFalse((inf.containsResource((RDFNode)A) || inf.containsResource((RDFNode)I) ? 1 : 0) != 0);
    }

    public void testRebindAll() {
        String NS = "http://jena.hpl.hp.com/example#";
        List rules1 = Rule.parseRules((String)"(?x http://jena.hpl.hp.com/example#p ?y) -> (?x http://jena.hpl.hp.com/example#q ?y).");
        List rules2 = Rule.parseRules((String)"(?x http://jena.hpl.hp.com/example#q ?y) -> (?x http://jena.hpl.hp.com/example#r ?y).");
        Model m = ModelFactory.createDefaultModel();
        Property p = m.createProperty(NS + "p");
        Property q = m.createProperty(NS + "q");
        Property r = m.createProperty(NS + "r");
        Resource a = m.createResource(NS + "a");
        Resource b = m.createResource(NS + "b");
        Statement s1 = m.createStatement(a, p, (RDFNode)b);
        Statement s2 = m.createStatement(a, q, (RDFNode)b);
        Statement s3 = m.createStatement(a, r, (RDFNode)b);
        m.add(s1);
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules1);
        InfModel infModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)m);
        reasoner.addRules(rules2);
        TestUtil.assertIteratorValues(this, (Iterator)infModel.listStatements(a, null, (RDFNode)null), new Object[]{s1, s2});
        ((FBRuleInfGraph)infModel.getGraph()).rebindAll();
        TestUtil.assertIteratorValues(this, (Iterator)infModel.listStatements(a, null, (RDFNode)null), new Object[]{s1, s2, s3});
    }

    public void testClose() {
        String rules = "[rule1: (?x p ?y) -> (?x q ?y)]";
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n1, this.q, this.n2)});
        infgraph.close();
        boolean foundException = false;
        try {
            infgraph.find(this.n1, null, null);
        }
        catch (ClosedException e) {
            foundException = true;
        }
        TestFBRules.assertTrue((String)"Close detected", (boolean)foundException);
    }

    public void testBackchain1() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.p, this.sP, this.q));
        data.add(new Triple(this.q, this.sP, this.r));
        data.add(new Triple(this.C1, this.sC, this.C2));
        data.add(new Triple(this.C2, this.sC, this.C3));
        data.add(new Triple(this.a, this.ty, this.C1));
        String rules = "[rdfs8:  (?a rdfs:subClassOf ?c) <- (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c)][rdfs9:  (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y), (?a rdf:type ?x)][-> (rdf:type rdfs:range rdfs:Class)][rdfs3:  (?y rdf:type ?c) <- (?x ?p ?y), (?p rdfs:range ?c)][rdfs7:  (?a rdfs:subClassOf ?a) <- (?a rdf:type rdfs:Class)]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.C1, this.sC, this.a), new Object[0]);
    }

    public void testBackchain2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.c, this.q, this.d));
        String rules = "[r1: (c r ?x) <- (?x p f(?x b))][r2: (?y p f(a ?y)) <- (c q ?y)]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[0]);
        data.add(new Triple(this.c, this.q, this.a));
        rules = "[r1: (c r ?x) <- (?x p f(?x a))][r2: (?y p f(a ?y)) <- (c q ?y)]";
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
        data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.q, this.a));
        data.add(new Triple(this.a, this.q, this.b));
        data.add(new Triple(this.a, this.q, this.c));
        data.add(new Triple(this.b, this.q, this.d));
        data.add(new Triple(this.b, this.q, this.b));
        rules = "[r1: (c r ?x) <- (?x p ?x)][r2: (?x p ?y) <- (a q ?x), (b q ?y)]";
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.b)});
        rules = "[r1: (c r ?x) <- (?x p ?x)][r2: (a p ?x) <- (a q ?x)]";
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.c, this.r, null), new Object[]{new Triple(this.c, this.r, this.a)});
    }

    public void testBackchain3() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, this.r));
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.r, this.sC, this.C1));
        data.add(new Triple(this.C1, this.ty, OWL.Restriction.asNode()));
        data.add(new Triple(this.C1, OWL.onProperty.asNode(), this.p));
        data.add(new Triple(this.C1, OWL.allValuesFrom.asNode(), this.c));
        String rules = "[rdfs9:   (?a rdf:type ?y) <- (?x rdfs:subClassOf ?y) (?a rdf:type ?x)][restriction2: (?C owl:equivalentClass all(?P, ?D)) <- (?C rdf:type owl:Restriction), (?C owl:onProperty ?P), (?C owl:allValuesFrom ?D)][rs2: (?X rdf:type all(?P,?C)) <- (?D owl:equivalentClass all(?P,?C)), (?X rdf:type ?D)][rp4: (?Y rdf:type ?C) <- (?X rdf:type all(?P, ?C)), (?X ?P ?Y)]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.b, this.ty, this.c), new Object[]{new Triple(this.b, this.ty, this.c)});
    }

    public void testHybrid1() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.p, this.ty, this.s));
        String rules = "[r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
    }

    public void testHybrid2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.r, this.b));
        data.add(new Triple(this.p, this.ty, this.s));
        String rules = "[a1: -> (a rdf:type t)][r0: (?x r ?y) -> (?x p ?y)][r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]][r2: (?p rdf:type s) -> [r2b: (?x ?p ?x) <- (?x rdf:type t)]]";
        FBRuleInfGraph infgraph = (FBRuleInfGraph)this.createInfGraph(rules, data);
        infgraph.setDerivationLogging(true);
        infgraph.prepare();
        TestFBRules.assertTrue((String)"Forward rule count", (infgraph.getNRulesFired() == 3L ? 1 : 0) != 0);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator di = infgraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestFBRules.assertTrue((boolean)di.hasNext());
        RuleDerivation d = (RuleDerivation)di.next();
        TestFBRules.assertTrue((boolean)d.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, d.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestFBRules.assertTrue((!di.hasNext() ? 1 : 0) != 0);
    }

    public void testHybridRDFS() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.p, RDFS.range.asNode(), this.C1));
        String rules = "[rdfs2:  (?p rdfs:domain ?c) -> [(?x rdf:type ?c) <- (?x ?p ?y)] ][rdfs3:  (?p rdfs:range ?c)  -> [(?y rdf:type ?c) <- (?x ?p ?y)] ][rdfs5a: (?a rdfs:subPropertyOf ?b), (?b rdfs:subPropertyOf ?c) -> (?a rdfs:subPropertyOf ?c)][rdfs5b: (?a rdf:type rdf:Property) -> (?a rdfs:subPropertyOf ?a)][rdfs6:  (?p rdfs:subPropertyOf ?q) -> [ (?a ?q ?b) <- (?a ?p ?b)] ][rdfs7:  (?a rdf:type rdfs:Class) -> (?a rdfs:subClassOf ?a)][rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)][rdfs9:  (?x rdfs:subClassOf ?y) -> [ (?a rdf:type ?y) <- (?a rdf:type ?x)] ]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.b, this.ty, null), new Object[]{new Triple(this.b, this.ty, this.C1)});
    }

    public void testHybridRDFS2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.b));
        data.add(new Triple(this.p, this.sP, this.r));
        data.add(new Triple(this.r, RDFS.range.asNode(), this.C1));
        String rules = "[rdfs3:  (?p rdfs:range ?c)  -> [(?y rdf:type ?c) <- (?x ?p ?y)] ][rdfs6:  (?p rdfs:subPropertyOf ?q) -> [ (?a ?q ?b) <- (?a ?p ?b)] ]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.b, this.ty, this.C1), new Object[]{new Triple(this.b, this.ty, this.C1)});
    }

    public void testMakeInstance() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, this.C1));
        String rules = "[r1:  (?x p ?t) <- (?x rdf:type C1), makeInstance(?x, p, C2, ?t)][r2:  (?t rdf:type C2) <- (?x rdf:type C1), makeInstance(?x, p, C2, ?t)]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        Node valueInstance = this.getValue((Graph)infgraph, this.a, this.p);
        TestFBRules.assertNotNull((Object)valueInstance);
        Node valueInstance2 = this.getValue((Graph)infgraph, this.a, this.p);
        TestFBRules.assertEquals((Object)valueInstance, (Object)valueInstance2);
        Node valueType = this.getValue((Graph)infgraph, valueInstance, RDF.type.asNode());
        TestFBRules.assertEquals((Object)valueType, (Object)this.C2);
    }

    public void testMakeInstances() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, this.C1));
        String rules = "[r1:  (?x p ?t) <- (?x rdf:type C1), makeInstance(?x, p, ?t)]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        Node valueInstance = this.getValue((Graph)infgraph, this.a, this.p);
        TestFBRules.assertNotNull((Object)valueInstance);
        Node valueInstance2 = this.getValue((Graph)infgraph, this.a, this.p);
        TestFBRules.assertEquals((Object)valueInstance, (Object)valueInstance2);
    }

    public void testMakeInstanceBug() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.ty, this.r));
        data.add(new Triple(this.r, this.sC, Functor.makeFunctorNode((String)"some", (Node[])new Node[]{this.p, this.C1})));
        String rules = "[some1: (?C rdfs:subClassOf some(?P, ?D)) ->[some1b: (?X ?P ?T) <- (?X rdf:type ?C), unbound(?T), noValue(?X, ?P), makeInstance(?X, ?P, ?D, ?T) ][some1b2: (?T rdf:type ?D) <- (?X rdf:type ?C), bound(?T), makeInstance(?X, ?P, ?D, ?T) ]]";
        InfGraph infgraph = this.createInfGraph(rules, data);
        Node valueInstance = this.getValue((Graph)infgraph, this.a, this.p);
        TestFBRules.assertNotNull((Object)valueInstance);
        Node valueType = this.getValue((Graph)infgraph, valueInstance, this.ty);
        TestFBRules.assertEquals((Object)valueType, (Object)this.C1);
    }

    public void testNumericFunctors() {
        String rules = "[r1: (?x p f(a, ?x)) -> (?x q f(?x)) ][r1: (?x p f(a, 0)) -> (?x s res) ]";
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)2)));
        data.add(new Triple(this.n2, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.a, Util.makeIntNode((int)0)})));
        data.add(new Triple(this.n3, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.a, Node.createLiteral((String)"0", (String)"", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)})));
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.s, null), new Triple[]{new Triple(this.n2, this.s, this.res), new Triple(this.n3, this.s, this.res)});
    }

    public void testBuiltins2() {
        Node lt = Node.createURI((String)"lt");
        Node gt = Node.createURI((String)"gt");
        Node le = Node.createURI((String)"le");
        Node ge = Node.createURI((String)"ge");
        Node eq = Node.createURI((String)"eq");
        Node ne = Node.createURI((String)"ne");
        String rules = "[r1: (?x q ?vx), (?y q ?vy), lessThan(?vx, ?vy) -> (?x lt ?y)][r2: (?x q ?vx), (?y q ?vy), greaterThan(?vx, ?vy) -> (?x gt ?y)][r3: (?x q ?vx), (?y q ?vy), le(?vx, ?vy) -> (?x le ?y)][r4: (?x q ?vx), (?y q ?vy), ge(?vx, ?vy) -> (?x ge ?y)][r5: (?x q ?vx), (?y q ?vy), notEqual(?vx, ?vy) -> (?x ne ?y)][r6: (?x q ?vx), (?y q ?vy), equal(?vx, ?vy) -> (?x eq ?y)]";
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.q, Util.makeIntNode((int)2)));
        data.add(new Triple(this.n2, this.q, Util.makeIntNode((int)2)));
        data.add(new Triple(this.n3, this.q, Util.makeIntNode((int)3)));
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, this.n2), new Triple[]{new Triple(this.n1, eq, this.n2), new Triple(this.n1, le, this.n2), new Triple(this.n1, ge, this.n2)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, this.n3), new Triple[]{new Triple(this.n1, ne, this.n3), new Triple(this.n1, lt, this.n3), new Triple(this.n1, le, this.n3)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n3, null, this.n1), new Triple[]{new Triple(this.n3, ne, this.n1), new Triple(this.n3, gt, this.n1), new Triple(this.n3, ge, this.n1)});
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.q, Util.makeIntNode((int)2)));
        data.add(new Triple(this.n2, this.q, Util.makeDoubleNode((double)2.2)));
        data.add(new Triple(this.n3, this.q, Util.makeDoubleNode((double)2.3)));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, this.n2), new Triple[]{new Triple(this.n1, ne, this.n2), new Triple(this.n1, le, this.n2), new Triple(this.n1, lt, this.n2)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n2, null, this.n3), new Triple[]{new Triple(this.n2, ne, this.n3), new Triple(this.n2, le, this.n3), new Triple(this.n2, lt, this.n3)});
        data = Factory.createGraphMem();
        XSDDatatype dt = new XSDDatatype("dateTime");
        data.add(new Triple(this.n1, this.q, Node.createLiteral((String)"2000-03-04T20:00:00Z", (String)"", (RDFDatatype)XSDDatatype.XSDdateTime)));
        data.add(new Triple(this.n2, this.q, Node.createLiteral((String)"2001-03-04T20:00:00Z", (String)"", (RDFDatatype)XSDDatatype.XSDdateTime)));
        data.add(new Triple(this.n3, this.q, Node.createLiteral((String)"2002-03-04T20:00:00Z", (String)"", (RDFDatatype)XSDDatatype.XSDdateTime)));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, this.n2), new Triple[]{new Triple(this.n1, ne, this.n2), new Triple(this.n1, le, this.n2), new Triple(this.n1, lt, this.n2)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n2, null, this.n3), new Triple[]{new Triple(this.n2, ne, this.n3), new Triple(this.n2, le, this.n3), new Triple(this.n2, lt, this.n3)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n2, null, this.n1), new Triple[]{new Triple(this.n2, ne, this.n1), new Triple(this.n2, ge, this.n1), new Triple(this.n2, gt, this.n1)});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n3, null, this.n2), new Triple[]{new Triple(this.n3, ne, this.n2), new Triple(this.n3, ge, this.n2), new Triple(this.n3, gt, this.n2)});
        rules = "[r1: now(?x) -> (a p ?x)]";
        infgraph = this.createInfGraph(rules);
        infgraph.prepare();
        Graph result = infgraph.getDeductionsGraph();
        TestFBRules.assertEquals((int)1, (int)result.size());
        Triple tr = (Triple)result.find(null, null, null).next();
        Node nowN = tr.getObject();
        TestFBRules.assertTrue((boolean)nowN.isLiteral());
        Object nowO = nowN.getLiteralValue();
        TestFBRules.assertTrue((boolean)(nowO instanceof XSDDateTime));
        rules = "[r1: (?x p ?a), (?x q ?b), sum(?a, ?b, ?c) -> (?x s ?c)][r2: (?x p ?a), (?x q ?b), product(?a, ?b, ?c) -> (?x t ?c)][r3: (?x p ?a), (?x q ?b), difference(?b, ?a, ?c) -> (?x u ?c)][r4: (?x p ?a), (?x q ?b), quotient(?b, ?a, ?c) -> (?x v ?c)][r4: (?x p ?a), (?x q ?b), min(?b, ?a, ?c) -> (?x r ?c)][r4: (?x p ?a), (?x q ?b), max(?b, ?a, ?c) -> (?x x ?c)]";
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)3)));
        data.add(new Triple(this.n1, this.q, Util.makeIntNode((int)5)));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode((int)3)), new Triple(this.n1, this.q, Util.makeIntNode((int)5)), new Triple(this.n1, this.s, Util.makeIntNode((int)8)), new Triple(this.n1, this.t, Util.makeIntNode((int)15)), new Triple(this.n1, this.u, Util.makeIntNode((int)2)), new Triple(this.n1, this.v, Util.makeIntNode((int)1)), new Triple(this.n1, this.r, Util.makeIntNode((int)3)), new Triple(this.n1, this.x, Util.makeIntNode((int)5))});
        rules = "[r1: (?x p ?y), isLiteral(?y) -> (?x s 'literal')][r1: (?x p ?y), notLiteral(?y) -> (?x s 'notLiteral')][r1: (?x p ?y), isBNode(?y) -> (?x s 'bNode')][r1: (?x p ?y), notBNode(?y) -> (?x s 'notBNode')]";
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)3)));
        data.add(new Triple(this.n2, this.p, this.res));
        data.add(new Triple(this.n3, this.p, Node.createAnon()));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, this.s, null), new Triple[]{new Triple(this.n1, this.s, Node.createLiteral((String)"literal", (String)"", null)), new Triple(this.n1, this.s, Node.createLiteral((String)"notBNode", (String)"", null))});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n2, this.s, null), new Triple[]{new Triple(this.n2, this.s, Node.createLiteral((String)"notLiteral", (String)"", null)), new Triple(this.n2, this.s, Node.createLiteral((String)"notBNode", (String)"", null))});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n3, this.s, null), new Triple[]{new Triple(this.n3, this.s, Node.createLiteral((String)"notLiteral", (String)"", null)), new Triple(this.n3, this.s, Node.createLiteral((String)"bNode", (String)"", null))});
        rules = "[r1: (?x p ?y), isDType(?y, rdfs:Literal) -> (?x s 'isLiteral')][r1: (?x p ?y), isDType(?y, http://www.w3.org/2001/XMLSchema#int) -> (?x s 'isXSDInt')][r1: (?x p ?y), isDType(?y, http://www.w3.org/2001/XMLSchema#string) -> (?x s 'isXSDString')][r1: (?x p ?y), notDType(?y, rdfs:Literal) -> (?x s 'notLiteral')][r1: (?x p ?y), notDType(?y, http://www.w3.org/2001/XMLSchema#int) -> (?x s 'notXSDInt')][r1: (?x p ?y), notDType(?y, http://www.w3.org/2001/XMLSchema#string) -> (?x s 'notXSDString')]";
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)3)));
        data.add(new Triple(this.n2, this.p, Node.createLiteral((String)"foo", (String)"", null)));
        data.add(new Triple(this.n3, this.p, Node.createLiteral((String)"foo", (String)"", (RDFDatatype)XSDDatatype.XSDstring)));
        data.add(new Triple(this.n4, this.p, this.n4));
        data.add(new Triple(this.n5, this.p, Node.createLiteral((String)"-1", (String)"", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.s, null), new Triple[]{new Triple(this.n1, this.s, Node.createLiteral((String)"isLiteral", (String)"", null)), new Triple(this.n1, this.s, Node.createLiteral((String)"isXSDInt", (String)"", null)), new Triple(this.n1, this.s, Node.createLiteral((String)"notXSDString", (String)"", null)), new Triple(this.n2, this.s, Node.createLiteral((String)"isLiteral", (String)"", null)), new Triple(this.n2, this.s, Node.createLiteral((String)"notXSDInt", (String)"", null)), new Triple(this.n2, this.s, Node.createLiteral((String)"isXSDString", (String)"", null)), new Triple(this.n3, this.s, Node.createLiteral((String)"isLiteral", (String)"", null)), new Triple(this.n3, this.s, Node.createLiteral((String)"notXSDInt", (String)"", null)), new Triple(this.n3, this.s, Node.createLiteral((String)"isXSDString", (String)"", null)), new Triple(this.n4, this.s, Node.createLiteral((String)"notLiteral", (String)"", null)), new Triple(this.n4, this.s, Node.createLiteral((String)"notXSDInt", (String)"", null)), new Triple(this.n4, this.s, Node.createLiteral((String)"notXSDString", (String)"", null)), new Triple(this.n5, this.s, Node.createLiteral((String)"notLiteral", (String)"", null)), new Triple(this.n5, this.s, Node.createLiteral((String)"notXSDInt", (String)"", null)), new Triple(this.n5, this.s, Node.createLiteral((String)"notXSDString", (String)"", null))});
        rules = "[r1: (?x p ?y), countLiteralValues(?x, p, ?c) -> (?x s ?c)]";
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)2)));
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)2)));
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)3)));
        data.add(new Triple(this.n1, this.p, this.n2));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(this.n1, this.s, null), new Triple[]{new Triple(this.n1, this.s, Util.makeIntNode((int)2))});
        rules = "[r1: (n1 p ?l) -> listMapAsSubject(?l, q, C1)][r2: (n1 p ?l) -> listMapAsObject ( a, q, ?l)]";
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeList((Node[])new Node[]{this.b, this.c, this.d}, (Graph)data)));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.q, null), new Triple[]{new Triple(this.b, this.q, this.C1), new Triple(this.c, this.q, this.C1), new Triple(this.d, this.q, this.C1), new Triple(this.a, this.q, this.b), new Triple(this.a, this.q, this.c), new Triple(this.a, this.q, this.d)});
    }

    public void testStringBuiltins() {
        String rules = "[r1: (?x p ?y) strConcat(?y, rdf:type, 'foo', ?z) -> (?x q ?z) ] \n[r1: (?x p ?y) strConcat(?z) -> (?x q ?z) ] \n[r2: (?x p ?y) uriConcat('http://jena.hpl.hp.com/test#', ?y, ?z) -> (?x q ?z) ]";
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Node.createLiteral((String)"test")));
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.q, null), new Triple[]{new Triple(this.n1, this.q, Node.createLiteral((String)"testhttp://www.w3.org/1999/02/22-rdf-syntax-ns#typefoo")), new Triple(this.n1, this.q, Node.createLiteral((String)"")), new Triple(this.n1, this.q, Node.createURI((String)"http://jena.hpl.hp.com/test#test"))});
        rules = "[r1: (?x p ?y) regex(?y, '(.*)\\\\s(.*) (f.*)') -> (?x q 'ok') ] \n[r2: (?x p ?y) regex(?y, '(.*)\\\\s(.*) (f.*)', ?m1, ?m2, ?m3) -> (?x r ?m2) ] \n";
        data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Node.createLiteral((String)"foo bar foo")));
        data.add(new Triple(this.n2, this.p, Node.createLiteral((String)"foo bar baz")));
        infgraph = this.createInfGraph(rules, data);
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.q, null), new Triple[]{new Triple(this.n1, this.q, Node.createLiteral((String)"ok"))});
        TestUtil.assertIteratorValues(this, (Iterator)infgraph.find(null, this.r, null), new Triple[]{new Triple(this.n1, this.r, Node.createLiteral((String)"bar"))});
    }

    public void testArithmetic() {
        this.doTestArithmetic("sum", 3, 5, 8);
        this.doTestArithmetic("difference", 5, 3, 2);
        this.doTestArithmetic("product", 3, 5, 15);
        this.doTestArithmetic("quotient", 12, 3, 4);
        this.doTestArithmetic("min", 3, 5, 3);
        this.doTestArithmetic("max", 3, 5, 5);
    }

    private void doTestArithmetic(String op, int arg1, int arg2, int expected) {
        String rules = "[r1: (?x p ?a), (?x q ?b), (?x r ?c) " + op + "(?a, ?b, ?c) -> (?x s ?c)]\n " + "[r2: (?x p ?a), (?x q ?b), (?x t ?c) " + op + "(?a, ?b, ?c) -> (?x u ?c)]";
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, Util.makeIntNode((int)arg1)));
        data.add(new Triple(this.n1, this.q, Util.makeIntNode((int)arg2)));
        data.add(new Triple(this.n1, this.r, Util.makeIntNode((int)expected)));
        data.add(new Triple(this.n1, this.t, Util.makeIntNode((int)(expected + 1))));
        InfGraph infgraph = this.createInfGraph(rules, data);
        TestFBRules.assertTrue((boolean)infgraph.contains(this.n1, this.s, Util.makeIntNode((int)expected)));
        TestFBRules.assertFalse((boolean)infgraph.contains(this.n1, this.u, Node.ANY));
    }

    private Node getValue(Graph g, Node s, Node p) {
        ExtendedIterator i = g.find(s, p, null);
        TestFBRules.assertTrue((boolean)i.hasNext());
        Node result = ((Triple)i.next()).getObject();
        if (i.hasNext()) {
            TestFBRules.assertTrue((String)"multiple values not expected", (boolean)false);
            i.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicatesEC4() throws IOException {
        boolean prior = JenaParameters.enableFilteringOfHiddenInfNodes;
        try {
            Object t;
            JenaParameters.enableFilteringOfHiddenInfNodes = false;
            Model premisesM = FileManager.get().loadModel("file:testing/wg/equivalentClass/premises004.rdf");
            Graph data = premisesM.getGraph();
            OWLFBRuleReasoner reasoner = new OWLFBRuleReasoner(OWLFBRuleReasonerFactory.theInstance());
            InfGraph infgraph = reasoner.bind(data);
            Node rbPrototypeProp = Node.createURI((String)"urn:x-hp-jena:rubrik/prototype");
            int count = 0;
            ExtendedIterator i = infgraph.find(null, rbPrototypeProp, null);
            while (i.hasNext()) {
                t = i.next();
                ++count;
            }
            TestFBRules.assertEquals((int)5, (int)count);
            infgraph = reasoner.bindSchema(data).bind(Factory.createGraphMem());
            count = 0;
            i = infgraph.find(null, rbPrototypeProp, null);
            while (i.hasNext()) {
                t = i.next();
                ++count;
            }
            TestFBRules.assertEquals((int)5, (int)count);
        }
        finally {
            JenaParameters.enableFilteringOfHiddenInfNodes = prior;
        }
    }

    public void temp() {
        Graph data = Factory.createGraphMem();
        Graph data2 = Factory.createGraphMem();
        OWLFBRuleReasoner reasoner = new OWLFBRuleReasoner(OWLFBRuleReasonerFactory.theInstance());
        FBRuleInfGraph infgraph = (FBRuleInfGraph)reasoner.bind(data);
        FBRuleInfGraph infgraph2 = (FBRuleInfGraph)reasoner.bind(data2);
        long t1 = System.currentTimeMillis();
        infgraph.prepare();
        long t2 = System.currentTimeMillis();
        System.out.println("Prepare on empty graph = " + (t2 - t1) + "ms");
        t1 = System.currentTimeMillis();
        infgraph2.prepare();
        t2 = System.currentTimeMillis();
        System.out.println("Prepare on empty graph = " + (t2 - t1) + "ms");
    }

    public void listGraph(Graph g) {
        ExtendedIterator i = g.find(null, null, null);
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            logger.info((Object)PrintUtil.print((Triple)t));
        }
        logger.info((Object)"  --------  ");
    }

    public void listFBGraph(String message, FBRuleInfGraph graph) {
        logger.info((Object)message);
        logger.info((Object)"Raw graph data");
        this.listGraph(graph.getRawGraph());
        logger.info((Object)"Static deductions");
        this.listGraph(graph.getDeductionsGraph());
    }
}

