/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary.test;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestSuite;

public class TestVocabJenaModelSpec
extends ModelTestBase {
    public TestVocabJenaModelSpec(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestVocabJenaModelSpec.class);
    }

    public void testURI() {
        TestVocabJenaModelSpec.assertEquals((String)"http://jena.hpl.hp.com/2003/08/jms#", (String)JenaModelSpec.getURI());
        TestVocabJenaModelSpec.assertEquals((String)"http://jena.hpl.hp.com/2003/08/jms#", (String)JenaModelSpec.getURI());
    }

    public void testProperties() {
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("loadWith"), (Object)JenaModelSpec.loadWith);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("ontLanguage"), (Object)JenaModelSpec.ontLanguage);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("docManager"), (Object)JenaModelSpec.docManager);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("importMaker"), (Object)JenaModelSpec.importMaker);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("reasonsWith"), (Object)JenaModelSpec.reasonsWith);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("ruleSetURL"), (Object)JenaModelSpec.ruleSetURL);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("ruleSet"), (Object)JenaModelSpec.ruleSet);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("schemaURL"), (Object)JenaModelSpec.schemaURL);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("hasRule"), (Object)JenaModelSpec.hasRule);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("policyPath"), (Object)JenaModelSpec.policyPath);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("hasConnection"), (Object)JenaModelSpec.hasConnection);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("dbUser"), (Object)JenaModelSpec.dbUser);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("dbPassword"), (Object)JenaModelSpec.dbPassword);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("dbURL"), (Object)JenaModelSpec.dbURL);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("dbType"), (Object)JenaModelSpec.dbType);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("dbClass"), (Object)JenaModelSpec.dbClass);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("maker"), (Object)JenaModelSpec.maker);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("reificationMode"), (Object)JenaModelSpec.reificationMode);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("reasoner"), (Object)JenaModelSpec.reasoner);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("fileBase"), (Object)JenaModelSpec.fileBase);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("typeCreatedBy"), (Object)JenaModelSpec.typeCreatedBy);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsProperty("modelName"), (Object)JenaModelSpec.modelName);
    }

    public void testResource() {
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("MakerSpec"), (Object)JenaModelSpec.MakerSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("FileMakerSpec"), (Object)JenaModelSpec.FileMakerSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("MemMakerSpec"), (Object)JenaModelSpec.MemMakerSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("RDBMakerSpec"), (Object)JenaModelSpec.RDBMakerSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("ModelSpec"), (Object)JenaModelSpec.ModelSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("DefaultModelSpec"), (Object)JenaModelSpec.DefaultModelSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("PlainModelSpec"), (Object)JenaModelSpec.PlainModelSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("InfModelSpec"), (Object)JenaModelSpec.InfModelSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("OntModelSpec"), (Object)JenaModelSpec.OntModelSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("FileModelSpec"), (Object)JenaModelSpec.FileModelSpec);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("rsStandard"), (Object)JenaModelSpec.rsStandard);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("rsMinimal"), (Object)JenaModelSpec.rsMinimal);
        TestVocabJenaModelSpec.assertEquals((Object)this.jmsResource("rsConvenient"), (Object)JenaModelSpec.rsConvenient);
    }

    public void testMakerSubclasses() {
        this.ensure(JenaModelSpec.MemMakerSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.MakerSpec);
        this.ensure(JenaModelSpec.FileMakerSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.MakerSpec);
        this.ensure(JenaModelSpec.RDBMakerSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.MakerSpec);
    }

    public void testSpecSubclasses() {
        this.ensure(JenaModelSpec.DefaultModelSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.ModelSpec);
        this.ensure(JenaModelSpec.PlainModelSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.ModelSpec);
        this.ensure(JenaModelSpec.InfModelSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.PlainModelSpec);
        this.ensure(JenaModelSpec.FileModelSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.PlainModelSpec);
        this.ensure(JenaModelSpec.OntModelSpec, RDFS.subClassOf, (RDFNode)JenaModelSpec.InfModelSpec);
    }

    public void testDomains() {
        this.ensure((Resource)JenaModelSpec.reificationMode, RDFS.domain, (RDFNode)JenaModelSpec.MakerSpec);
        this.ensure((Resource)JenaModelSpec.maker, RDFS.domain, (RDFNode)JenaModelSpec.PlainModelSpec);
        this.ensure((Resource)JenaModelSpec.modelName, RDFS.domain, (RDFNode)JenaModelSpec.ModelSpec);
        this.ensure((Resource)JenaModelSpec.loadWith, RDFS.domain, (RDFNode)JenaModelSpec.ModelSpec);
        this.ensure((Resource)JenaModelSpec.importMaker, RDFS.domain, (RDFNode)JenaModelSpec.OntModelSpec);
        this.ensure((Resource)JenaModelSpec.ontLanguage, RDFS.domain, (RDFNode)JenaModelSpec.OntModelSpec);
        this.ensure((Resource)JenaModelSpec.reasonsWith, RDFS.domain, (RDFNode)JenaModelSpec.InfModelSpec);
        this.ensure((Resource)JenaModelSpec.fileBase, RDFS.domain, (RDFNode)JenaModelSpec.FileMakerSpec);
    }

    protected void ensure(Resource S, Property P, RDFNode O) {
        if (!JenaModelSpec.getSchema().contains(S, P, O)) {
            TestVocabJenaModelSpec.fail((String)("schema omits (" + TestVocabJenaModelSpec.nice((RDFNode)S) + " " + TestVocabJenaModelSpec.nice((RDFNode)P) + " " + TestVocabJenaModelSpec.nice(O) + ")"));
        }
    }

    protected Resource jmsResource(String string) {
        return TestVocabJenaModelSpec.resource(JenaModelSpec.getURI() + string);
    }

    protected Property jmsProperty(String string) {
        return TestVocabJenaModelSpec.property(JenaModelSpec.getURI() + string);
    }
}

