/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.tidy.concurrent.AbstractTidyJob;
import org.dataone.tidy.concurrent.TidyFutureTask;
import org.dataone.tidy.concurrent.TidyJob;

public class TidyJobExecutorCompletionService<V>
implements CompletionService<V> {
    private final Executor executor;
    private final BlockingQueue<Future<V>> completionQueue;
    private static Log logger = LogFactory.getLog(TidyJobExecutorCompletionService.class);

    public TidyJobExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public TidyJobExecutorCompletionService(Executor executor, BlockingQueue<Future<V>> completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue;
    }

    @Override
    private Future<V> submit(TidyJob<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture f = new QueueingFuture(task);
        this.executor.execute(f);
        return f;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        TidyJob defaultTidyJob = null;
        defaultTidyJob = task instanceof TidyJob ? (TidyJob)task : new DefaultTidyJob(task);
        return this.submit(defaultTidyJob);
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        return this.submit(Executors.callable(task, result));
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    private class DefaultTidyJob
    extends AbstractTidyJob {
        Callable job = null;

        DefaultTidyJob(Callable job) {
            this.job = job;
        }

        @Override
        public Object call() throws Exception {
            return this.job.call();
        }
    }

    private class QueueingFuture
    extends TidyFutureTask<Void> {
        public QueueingFuture(TidyJob tidyJob) {
            super(tidyJob);
        }

        @Override
        protected void done() {
            TidyJobExecutorCompletionService.this.completionQueue.add(this);
        }
    }
}

