/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.comp;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorLambda;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.ExpressibleComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FieldComparator
extends StreamComparator
implements Comparator<Tuple>,
ExpressibleComparator,
Serializable {
    private static final long serialVersionUID = 1L;
    private ComparatorLambda comparator;

    public FieldComparator(String field, ComparatorOrder order) {
        super(field, order);
        this.assignComparator();
    }

    public FieldComparator(String leftField, String rightField, ComparatorOrder order) {
        super(leftField, rightField, order);
        this.assignComparator();
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftField);
        if (!this.leftField.equals(this.rightField)) {
            sb.append("=");
            sb.append(this.rightField);
        }
        sb.append(" ");
        sb.append((Object)this.order);
        return new StreamExpressionValue(sb.toString());
    }

    private void assignComparator() {
        this.comparator = ComparatorOrder.DESCENDING == this.order ? new ComparatorLambda(){

            @Override
            public int compare(Tuple leftTuple, Tuple rightTuple) {
                Comparable leftComp = (Comparable)leftTuple.get(FieldComparator.this.leftField);
                Comparable rightComp = (Comparable)rightTuple.get(FieldComparator.this.rightField);
                return rightComp.compareTo(leftComp);
            }
        } : new ComparatorLambda(){

            @Override
            public int compare(Tuple leftTuple, Tuple rightTuple) {
                Comparable leftComp = (Comparable)leftTuple.get(FieldComparator.this.leftField);
                Comparable rightComp = (Comparable)rightTuple.get(FieldComparator.this.rightField);
                return leftComp.compareTo(rightComp);
            }
        };
    }

    @Override
    public int compare(Tuple leftTuple, Tuple rightTuple) {
        return this.comparator.compare(leftTuple, rightTuple);
    }
}

