/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.client;

import java.io.FileInputStream;
import java.net.URL;
import org.apache.axis.client.Stub;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.put.stub.PutServiceElementType;
import org.ecoinformatics.ecogrid.put.stub.PutServiceLocator;
import org.ecoinformatics.ecogrid.put.stub.PutServicePortType;

public class PutServiceClient {
    private static final int QUERY_OPERATION = 1;
    private static final int GET_OPERATION = 2;
    private String serviceURL = null;
    private PutServicePortType ecogrid = null;

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("Usage: java org.ecoinformatics.ecogrid.client.PutServiceClient obj_type filename ecogrid_obj_id sessionId GSH");
            System.out.println("       where obj_type is \"data\" or \"metadata\".");
            System.exit(0);
        }
        System.out.println("datatype is: " + stringArray[0]);
        System.out.println("localfilename is: " + stringArray[1]);
        System.out.println("ecogrid object ID is:" + stringArray[2]);
        System.out.println("GSH is: " + stringArray[4]);
        int n = 1;
        String string = stringArray[0];
        if (string.compareToIgnoreCase("data") == 0) {
            n = 1;
        } else if (string.compareToIgnoreCase("metadata") == 0) {
            n = 2;
        } else {
            System.out.println("Unknow object type ==> " + stringArray[0] + ". The object type is either \"data\" or \"metadata\".");
            System.exit(0);
        }
        try {
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            PutServiceClient putServiceClient = new PutServiceClient(string5);
            putServiceClient.put(string2, string3, n, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PutServiceClient(String string) throws Exception {
        this.serviceURL = string;
        long l = System.currentTimeMillis();
        PutServiceLocator putServiceLocator = new PutServiceLocator();
        this.ecogrid = putServiceLocator.getPut(new URL(this.serviceURL));
        Stub stub = (Stub)this.ecogrid;
        stub.setTimeout(10000000);
        long l2 = System.currentTimeMillis();
        EcogridUtils.debugMessage("The time to create instance is =========== " + (l2 - l) / 1000L, 30);
    }

    public void put(String string, String string2, int n, String string3) throws Exception {
        byte[] byArray = this.GetBytesFromFile(string);
        PutServiceElementType putServiceElementType = new PutServiceElementType(byArray, string2, string, n, string3);
        this.ecogrid.put(putServiceElementType);
    }

    public void put(byte[] byArray, String string, String string2, int n, String string3) throws Exception {
        PutServiceElementType putServiceElementType = new PutServiceElementType(byArray, string, string2, n, string3);
        this.ecogrid.put(putServiceElementType);
    }

    public void put(byte[] byArray, String string, int n, String string2) throws Exception {
        PutServiceElementType putServiceElementType = new PutServiceElementType(byArray, string, null, n, string2);
        this.ecogrid.put(putServiceElementType);
    }

    byte[] GetBytesFromFile(String string) {
        byte[] byArray = new byte[2000];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.read(byArray, 0, 2000);
            boolean bl = false;
            while (n > 0) {
                int n2;
                if (byArray2 == null) {
                    byArray2 = new byte[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray2[n2] = byArray[n2];
                    }
                } else {
                    byArray3 = new byte[byArray2.length];
                    for (n2 = 0; n2 < byArray2.length; ++n2) {
                        byArray3[n2] = byArray2[n2];
                    }
                    byArray2 = null;
                    byArray2 = new byte[byArray3.length + n];
                    for (n2 = 0; n2 < byArray3.length; ++n2) {
                        byArray2[n2] = byArray3[n2];
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray2[byArray3.length + n2] = byArray[n2];
                    }
                    byArray3 = null;
                }
                n = fileInputStream.read(byArray, 0, 2000);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in reading data from file: " + exception.getMessage());
            System.exit(1);
        }
        return byArray2;
    }
}

