/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dataone.cn.hazelcast.HazelcastClientInstance;
import org.dataone.cn.indexer.XMLNamespace;
import org.dataone.cn.indexer.XMLNamespaceConfig;
import org.dataone.cn.indexer.resourcemap.ResourceEntry;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceMap {
    private Set<ResourceEntry> mappedReferences;
    private Set<String> contains = null;
    private Document doc = null;
    private String identifier = null;
    XPathFactory factory = null;
    public static String XPATH_RESOURCE_MAP_IDENTIFIER = "/rdf:RDF/rdf:Description/rdf:type[@rdf:resource='http://www.openarchives.org/ore/terms/ResourceMap']/parent::*/dcterms:identifier/text()";
    private static NamespaceContext nameSpaceContext;
    public static final String NS_DCTERMS = "http://purl.org/dc/terms/";
    public static final String NS_CITO = "http://purl.org/spar/cito/";
    public static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String ATTRIBUTE_ABOUT = "about";
    public static final String ATTRIBUTE_RESOURCE = "resource";
    public static final String TAG_DOCUMENTS = "documents";
    public static final String TAG_IDENTIFIER = "identifier";
    public static final String TAG_IS_DOCUMENTED_BY = "isDocumentedBy";
    private HashMap<String, String> descriptionURIToIdentifierMap = null;
    private HazelcastInstance hzClient;
    private static final String HZ_SYSTEM_METADATA;
    private IMap<Identifier, SystemMetadata> systemMetadata;
    private static final String RESOURCE_MAP_FORMAT = "http://www.openarchives.org/ore/terms";

    public ResourceMap(Document doc) throws XPathExpressionException {
        this.doc = doc;
        this.setIdentifier(this.parseIdentfier(doc));
        this.mappedReferences = this.getMappedReferences();
        this.contains = new HashSet<String>();
        this.contains.addAll(this.descriptionURIToIdentifierMap.values());
    }

    private String parseIdentfier(Document doc) throws XPathExpressionException {
        this.factory = XPathFactory.newInstance();
        XPath xPath = this.factory.newXPath();
        xPath.setNamespaceContext(ResourceMap.getNameSpaceContext());
        XPathExpression resourceMapIdentifierXpath = xPath.compile(XPATH_RESOURCE_MAP_IDENTIFIER);
        String resourceMapIdentifier = (String)resourceMapIdentifierXpath.evaluate(doc, XPathConstants.STRING);
        return resourceMapIdentifier;
    }

    public Set<ResourceEntry> getMappedReferences() {
        if (this.mappedReferences == null || this.mappedReferences.isEmpty()) {
            this.startHazelClient();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xp = factory.newXPath();
            xp.setNamespaceContext(ResourceMap.getNameSpaceContext());
            HashSet<ResourceEntry> resourceEntries = new HashSet<ResourceEntry>();
            try {
                xp.setNamespaceContext(ResourceMap.getNameSpaceContext());
                XPathExpression identifierDescriptionsExpression = xp.compile("/rdf:RDF/rdf:Description[dcterms:identifier]");
                NodeList descriptions = (NodeList)identifierDescriptionsExpression.evaluate(this.doc, XPathConstants.NODESET);
                this.parseResourceIdentifierMap(descriptions);
                for (int i = 0; i < descriptions.getLength(); ++i) {
                    Element descriptionElement = (Element)descriptions.item(i);
                    ResourceEntry resourceEntry = new ResourceEntry(descriptionElement, this);
                    Identifier pid = new Identifier();
                    pid.setValue(resourceEntry.getIdentifier());
                    SystemMetadata smd = (SystemMetadata)this.systemMetadata.get((Object)pid);
                    if (!SolrDoc.visibleInIndex(smd) || resourceEntry.getIdentifier().equals(this.getIdentifier())) continue;
                    resourceEntries.add(resourceEntry);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            this.mappedReferences = resourceEntries;
        }
        return this.mappedReferences;
    }

    private void parseResourceIdentifierMap(NodeList descriptions) {
        this.descriptionURIToIdentifierMap = new HashMap();
        for (int i = 0; i < descriptions.getLength(); ++i) {
            Element descriptionElement = (Element)descriptions.item(i);
            String uri = descriptionElement.getAttributeNS(NS_RDF, ATTRIBUTE_ABOUT);
            Element identifierElement = (Element)descriptionElement.getElementsByTagNameNS(NS_DCTERMS, TAG_IDENTIFIER).item(0);
            String identifierText = identifierElement.getTextContent();
            if (identifierText.equals(this.getIdentifier())) continue;
            this.descriptionURIToIdentifierMap.put(uri, identifierText);
        }
    }

    public Set<String> getContains() {
        return this.contains;
    }

    public void setContains(Set<String> contains) {
        this.contains = contains;
    }

    public void setMappedReferences(Set<ResourceEntry> mappedReferences) {
        this.mappedReferences = mappedReferences;
    }

    public static NamespaceContext getNameSpaceContext() {
        if (nameSpaceContext == null) {
            ArrayList<XMLNamespace> namespaces = new ArrayList<XMLNamespace>();
            namespaces.add(new XMLNamespace("cito", NS_CITO));
            namespaces.add(new XMLNamespace("dc", "http://purl.org/dc/elements/1.1/"));
            namespaces.add(new XMLNamespace("dcterms", NS_DCTERMS));
            namespaces.add(new XMLNamespace("foaf", "http://xmlns.com/foaf/0.1/"));
            namespaces.add(new XMLNamespace("ore", "http://www.openarchives.org/ore/terms/"));
            namespaces.add(new XMLNamespace("rdf", NS_RDF));
            namespaces.add(new XMLNamespace("rdfs1", "http://www.w3.org/2001/01/rdf-schema#"));
            nameSpaceContext = new XMLNamespaceConfig(namespaces);
        }
        return nameSpaceContext;
    }

    public List<String> getAllDocumentIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getIdentifier());
        for (ResourceEntry resourceEntry : this.getMappedReferences()) {
            ids.add(resourceEntry.getIdentifier());
        }
        return ids;
    }

    public List<SolrDoc> mergeIndexedDocuments(List<SolrDoc> docs) {
        ArrayList<SolrDoc> mergedDocuments = new ArrayList<SolrDoc>();
        for (ResourceEntry mappedReference : this.mappedReferences) {
            SolrDoc mergeDocument = null;
            for (SolrDoc doc : docs) {
                if (!doc.getIdentifier().equals(mappedReference.getIdentifier())) continue;
                mergeDocument = doc;
                break;
            }
            if (mergeDocument == null) continue;
            mergedDocuments.add(this.mergeMappedReference(mappedReference, mergeDocument));
        }
        return mergedDocuments;
    }

    private SolrDoc mergeMappedReference(ResourceEntry resourceEntry, SolrDoc mergeDocument) {
        if (!mergeDocument.hasField("id")) {
            mergeDocument.addField(new SolrElementField("id", resourceEntry.getIdentifier()));
        }
        for (String documentedBy : resourceEntry.getDocumentedBy()) {
            if (mergeDocument.hasFieldWithValue(TAG_IS_DOCUMENTED_BY, documentedBy)) continue;
            mergeDocument.addField(new SolrElementField(TAG_IS_DOCUMENTED_BY, documentedBy));
        }
        for (String documents : resourceEntry.getDocuments()) {
            if (mergeDocument.hasFieldWithValue(TAG_DOCUMENTS, documents)) continue;
            mergeDocument.addField(new SolrElementField(TAG_DOCUMENTS, documents));
        }
        for (String resourceMap : resourceEntry.getResourceMaps()) {
            if (mergeDocument.hasFieldWithValue("resourcemap", resourceMap)) continue;
            mergeDocument.addField(new SolrElementField("resourcemap", resourceMap));
        }
        mergeDocument.setMerged(true);
        return mergeDocument;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceMap: ").append(this.getIdentifier()).append("\n");
        for (String contain : this.contains) {
            sb.append("\tContains: ").append(contain).append("\n");
        }
        for (ResourceEntry mappedReference : this.mappedReferences) {
            sb.append(mappedReference.toString());
        }
        return sb.toString();
    }

    public String getIdentifierFromResource(String resourceURI) {
        String mappedIdentifier = this.descriptionURIToIdentifierMap.get(resourceURI);
        return mappedIdentifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public static boolean representsResourceMap(String formatId) {
        return RESOURCE_MAP_FORMAT.equals(formatId);
    }

    private void startHazelClient() {
        if (this.hzClient == null) {
            this.hzClient = HazelcastClientInstance.getHazelcastClient();
            this.systemMetadata = this.hzClient.getMap(HZ_SYSTEM_METADATA);
        }
    }

    static {
        HZ_SYSTEM_METADATA = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    }
}

