/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.Entity;

public class SelectionItem {
    private static final String SEPERATOR = ".";
    private static final String BLANKSTR = "";
    private Entity entity = null;
    private Attribute attribute = null;

    public SelectionItem(Entity entity, Attribute attribute) {
        this.entity = entity;
        this.attribute = attribute;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toSQLString() throws UnWellFormedQueryException {
        String selectionItem = BLANKSTR;
        String entityName = null;
        String attributeName = null;
        if (this.entity != null) {
            try {
                entityName = DataManager.getDBTableName(this.entity);
            }
            catch (SQLException sqle) {
                System.err.println("entity name is null " + sqle.getMessage());
            }
            if (entityName != null && !entityName.trim().equals(BLANKSTR)) {
                selectionItem = entityName + SEPERATOR;
            }
        }
        if (this.attribute == null) return "null";
        try {
            attributeName = DataManager.getDBFieldName(this.entity, this.attribute);
        }
        catch (SQLException sqle) {
            System.err.println("attribute name is null " + sqle.getMessage());
        }
        if (attributeName == null) throw new UnWellFormedQueryException("Selected attribute name couldn't be null or blank");
        if (attributeName.trim().equals(BLANKSTR)) throw new UnWellFormedQueryException("Selected attribute name couldn't be null or blank");
        return selectionItem + attributeName;
    }
}

