/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMapConfig
implements DataSerializable {
    private String name;
    private String valueCollectionType = ValueCollectionType.SET.toString();
    private List<EntryListenerConfig> listenerConfigs;

    public MultiMapConfig() {
    }

    public MultiMapConfig(MultiMapConfig defConfig) {
        this.name = defConfig.getName();
        this.valueCollectionType = defConfig.getValueCollectionType().toString();
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.valueCollectionType);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.valueCollectionType = in.readUTF();
    }

    public String getName() {
        return this.name;
    }

    public MultiMapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public ValueCollectionType getValueCollectionType() {
        return ValueCollectionType.valueOf(this.valueCollectionType.toUpperCase());
    }

    public MultiMapConfig setValueCollectionType(String valueCollectionType) {
        this.valueCollectionType = valueCollectionType;
        return this;
    }

    public MultiMapConfig setValueCollectionType(ValueCollectionType valueCollectionType) {
        this.valueCollectionType = valueCollectionType.toString();
        return this;
    }

    public MultiMapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public void setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiMapConfig");
        sb.append("{listenerConfigs=").append(this.listenerConfigs);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", valueCollectionType='").append(this.valueCollectionType).append('\'');
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueCollectionType {
        SET,
        LIST;

    }
}

