/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamOps;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.BinRDF;

public class WriterGraphThrift
implements WriterGraphRIOT {
    private final boolean withValues;

    public WriterGraphThrift(RDFFormat fmt) {
        this.withValues = RDFFormat.RDF_THRIFT_VALUES.equals(fmt);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.THRIFT;
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        throw new NotImplemented("Writing binary data to a java.io.Writer is not supported. Please use an OutputStream");
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        StreamRDF stream = BinRDF.streamToOutputStream(out, this.withValues);
        stream.start();
        StreamOps.graphToStream(graph, stream);
        stream.finish();
    }
}

