/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaWildcardType;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.List;

public class DefaultJavaWildcardType
extends DefaultJavaType
implements JavaWildcardType {
    private BoundType boundType;
    private List<JavaType> bounds = Collections.emptyList();

    public DefaultJavaWildcardType() {
        super("?");
    }

    public DefaultJavaWildcardType(JavaType type, BoundType boundType) {
        this();
        this.bounds = Collections.singletonList(type);
        this.boundType = boundType;
    }

    public String getFullyQualifiedName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getFullyQualifiedName());
        }
        return builder.toString();
    }

    public String getGenericValue() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getGenericValue());
        }
        return builder.toString();
    }

    public String getGenericFullyQualifiedName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getGenericFullyQualifiedName());
        }
        return builder.toString();
    }

    public String getCanonicalName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getCanonicalName());
        }
        return builder.toString();
    }

    public String getGenericCanonicalName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getGenericCanonicalName());
        }
        return builder.toString();
    }

    public String getValue() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.getValue());
        }
        return builder.toString();
    }

    public String toGenericString() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type : this.bounds) {
            builder.append(type.toGenericString());
        }
        return builder.toString();
    }

    private StringBuilder getPreparedStringBuilder() {
        StringBuilder builder = new StringBuilder("?");
        if (BoundType.EXTENDS.equals((Object)this.boundType)) {
            builder.append(" extends ");
        } else if (BoundType.SUPER.equals((Object)this.boundType)) {
            builder.append(" super ");
        }
        return builder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoundType {
        EXTENDS,
        SUPER;

    }
}

