/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.AVLGroupTree;
import com.tdunning.math.stats.AbstractTDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AVLTreeDigest
extends AbstractTDigest {
    private double compression;
    private AVLGroupTree summary;
    long count = 0L;
    public static final int VERBOSE_ENCODING = 1;
    public static final int SMALL_ENCODING = 2;

    public AVLTreeDigest(double compression) {
        this.compression = compression;
        this.summary = new AVLGroupTree(false);
    }

    @Override
    public TDigest recordAllData() {
        if (this.summary.size() != 0) {
            throw new IllegalStateException("Can only ask to record added data on an empty summary");
        }
        this.summary = new AVLGroupTree(true);
        return super.recordAllData();
    }

    @Override
    void add(double x, int w, Centroid base) {
        if (x != base.mean() || w != base.count()) {
            throw new IllegalArgumentException();
        }
        this.add(x, w, base.data());
    }

    @Override
    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    public void add(double x, int w, List<Double> data) {
        this.checkValue(x);
        int start = this.summary.floor(x);
        if (start == 0) {
            start = this.summary.first();
        }
        if (start == 0) {
            assert (this.summary.size() == 0);
            this.summary.add(x, w, data);
            this.count = w;
        } else {
            double minDistance = Double.MAX_VALUE;
            int lastNeighbor = 0;
            int neighbor = start;
            while (neighbor != 0) {
                double z = Math.abs(this.summary.mean(neighbor) - x);
                if (z < minDistance) {
                    start = neighbor;
                    minDistance = z;
                } else if (z > minDistance) {
                    lastNeighbor = neighbor;
                    break;
                }
                neighbor = this.summary.next(neighbor);
            }
            int closest = 0;
            long sum = this.summary.headSum(start);
            double n = 0.0;
            int neighbor2 = start;
            while (neighbor2 != lastNeighbor) {
                assert (minDistance == Math.abs(this.summary.mean(neighbor2) - x));
                double q = this.count == 1L ? 0.5 : ((double)sum + (double)(this.summary.count(neighbor2) - 1) / 2.0) / (double)(this.count - 1L);
                double k = (double)(4L * this.count) * q * (1.0 - q) / this.compression;
                if ((double)(this.summary.count(neighbor2) + w) <= k) {
                    n += 1.0;
                    if (this.gen.nextDouble() < 1.0 / n) {
                        closest = neighbor2;
                    }
                }
                sum += (long)this.summary.count(neighbor2);
                neighbor2 = this.summary.next(neighbor2);
            }
            if (closest == 0) {
                this.summary.add(x, w, data);
            } else {
                double centroid = this.summary.mean(closest);
                int count = this.summary.count(closest);
                List<Double> d = this.summary.data(closest);
                if (d != null) {
                    if (w == 1) {
                        d.add(x);
                    } else {
                        d.addAll(data);
                    }
                }
                centroid = AVLTreeDigest.weightedAverage(centroid, count, x, w);
                this.summary.update(closest, centroid, count += w, d);
            }
            this.count += (long)w;
            if ((double)this.summary.size() > 20.0 * this.compression) {
                this.compress();
            }
        }
    }

    @Override
    public void compress() {
        int i;
        if (this.summary.size() <= 1) {
            return;
        }
        AVLGroupTree centroids = this.summary;
        this.summary = new AVLGroupTree(this.recordAllData);
        int[] nodes = new int[centroids.size()];
        nodes[0] = centroids.first();
        for (i = 1; i < nodes.length; ++i) {
            nodes[i] = centroids.next(nodes[i - 1]);
            assert (nodes[i] != 0);
        }
        assert (centroids.next(nodes[nodes.length - 1]) == 0);
        for (i = centroids.size() - 1; i > 0; --i) {
            int other = this.gen.nextInt(i + 1);
            int tmp = nodes[other];
            nodes[other] = nodes[i];
            nodes[i] = tmp;
        }
        for (int node : nodes) {
            this.add(centroids.mean(node), centroids.count(node), centroids.data(node));
        }
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public double cdf(double x) {
        double left;
        AVLGroupTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return x < values.mean(values.first()) ? 0.0 : 1.0;
        }
        double r = 0.0;
        Iterator<Centroid> it = values.iterator();
        Centroid a = it.next();
        Centroid b = it.next();
        double right = left = (b.mean() - a.mean()) / 2.0;
        while (it.hasNext()) {
            if (x < a.mean() + right) {
                double value = (r + (double)a.count() * AVLTreeDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.count;
                return value > 0.0 ? value : 0.0;
            }
            r += (double)a.count();
            a = b;
            left = right;
            b = it.next();
            right = (b.mean() - a.mean()) / 2.0;
        }
        if (x < a.mean() + right) {
            return (r + (double)a.count() * AVLTreeDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.count;
        }
        return 1.0;
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        AVLGroupTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return values.iterator().next().mean();
        }
        double index = q * (double)(this.count - 1L);
        double previousMean = Double.NaN;
        double previousIndex = 0.0;
        int next = values.floorSum((long)index);
        assert (next != 0);
        long total = values.headSum(next);
        int prev = values.prev(next);
        if (prev != 0) {
            previousMean = values.mean(prev);
            previousIndex = (double)total - ((double)values.count(prev) + 1.0) / 2.0;
        }
        while (true) {
            double nextIndex;
            if ((nextIndex = (double)total + ((double)values.count(next) - 1.0) / 2.0) >= index) {
                if (Double.isNaN(previousMean)) {
                    assert (total == 0L) : total;
                    if (nextIndex == previousIndex) {
                        return values.mean(next);
                    }
                    int next2 = values.next(next);
                    double nextIndex2 = (double)(total + (long)values.count(next)) + ((double)values.count(next2) - 1.0) / 2.0;
                    previousMean = (nextIndex2 * values.mean(next) - nextIndex * values.mean(next2)) / (nextIndex2 - nextIndex);
                }
                return AVLTreeDigest.quantile(index, previousIndex, nextIndex, previousMean, values.mean(next));
            }
            if (values.next(next) == 0) {
                double nextIndex2 = this.count - 1L;
                double nextMean2 = (values.mean(next) * (nextIndex2 - previousIndex) - previousMean * (nextIndex2 - nextIndex)) / (nextIndex - previousIndex);
                return AVLTreeDigest.quantile(index, nextIndex, nextIndex2, values.mean(next), nextMean2);
            }
            total += (long)values.count(next);
            previousMean = values.mean(next);
            previousIndex = nextIndex;
            next = values.next(next);
        }
    }

    @Override
    public Collection<Centroid> centroids() {
        return Collections.unmodifiableCollection(this.summary);
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        return 16 + this.summary.size() * 12;
    }

    @Override
    public int smallByteSize() {
        int bound = this.byteSize();
        ByteBuffer buf = ByteBuffer.allocate(bound);
        this.asSmallBytes(buf);
        return buf.position();
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        buf.putInt(1);
        buf.putDouble(this.compression());
        buf.putInt(this.summary.size());
        for (Centroid centroid : this.summary) {
            buf.putDouble(centroid.mean());
        }
        for (Centroid centroid : this.summary) {
            buf.putInt(centroid.count());
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        buf.putInt(2);
        buf.putDouble(this.compression());
        buf.putInt(this.summary.size());
        double x = 0.0;
        for (Centroid centroid : this.summary) {
            double delta = centroid.mean() - x;
            x = centroid.mean();
            buf.putFloat((float)delta);
        }
        for (Centroid centroid : this.summary) {
            int n = centroid.count();
            AVLTreeDigest.encode(buf, n);
        }
    }

    public static AVLTreeDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == 1) {
            int i;
            double compression = buf.getDouble();
            AVLTreeDigest r = new AVLTreeDigest(compression);
            int n = buf.getInt();
            double[] means = new double[n];
            for (i = 0; i < n; ++i) {
                means[i] = buf.getDouble();
            }
            for (i = 0; i < n; ++i) {
                r.add(means[i], buf.getInt());
            }
            return r;
        }
        if (encoding == 2) {
            int i;
            double compression = buf.getDouble();
            AVLTreeDigest r = new AVLTreeDigest(compression);
            int n = buf.getInt();
            double[] means = new double[n];
            double x = 0.0;
            for (i = 0; i < n; ++i) {
                double delta = buf.getFloat();
                means[i] = x += delta;
            }
            for (i = 0; i < n; ++i) {
                int z = AVLTreeDigest.decode(buf);
                r.add(means[i], z);
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }
}

