/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;

public abstract class DatasetChangesBatched
implements DatasetChanges {
    private QuadAction currentAction = null;
    private Node currentSubject = null;
    private Node currentGraph = null;
    private List<Quad> batchQuads = null;
    private boolean mergeBlankNodes = false;

    protected DatasetChangesBatched() {
        this(false);
    }

    protected DatasetChangesBatched(boolean mergeBNodes) {
        this.mergeBlankNodes = mergeBNodes;
    }

    @Override
    public final void start() {
        this.startBatched();
        this.startBatch();
    }

    @Override
    public final void finish() {
        this.finishBatch();
        this.finishBatched();
    }

    @Override
    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        if (this.mergeBlankNodes && s.isBlank()) {
            if (this.batchQuads == null) {
                this.startBatch();
            }
        } else if (!(Lib.equal(this.currentAction, qaction) && Lib.equal(this.currentGraph, g) && Lib.equal(this.currentSubject, s))) {
            this.finishBatch();
            this.startBatch();
            this.currentAction = qaction;
            this.currentGraph = g;
            this.currentSubject = s;
        }
        this.batchQuads.add(new Quad(g, s, p, o));
    }

    private void startBatch() {
        if (this.batchQuads == null) {
            this.batchQuads = new ArrayList<Quad>();
        }
    }

    protected void finishBatch() {
        if (this.batchQuads == null || this.batchQuads.size() == 0) {
            return;
        }
        this.dispatch(this.currentAction, this.batchQuads);
        this.batchQuads = null;
    }

    protected abstract void dispatch(QuadAction var1, List<Quad> var2);

    protected abstract void startBatched();

    protected abstract void finishBatched();
}

