/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.data.Variable;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.ValueScaler;

class PrintText
extends CommentText {
    static final String UNIT_MARKER = "([^%]?)%(s|S)";
    static final Pattern UNIT_PATTERN = Pattern.compile("([^%]?)%(s|S)");
    private final String srcName;
    private final boolean includedInGraph;
    private final boolean strftime;

    PrintText(String srcName, String text, boolean includedInGraph, boolean strftime) {
        super(text);
        this.srcName = srcName;
        this.includedInGraph = includedInGraph;
        this.strftime = strftime;
    }

    @Override
    boolean isPrint() {
        return !this.includedInGraph;
    }

    @Override
    void resolveText(Locale l, DataProcessor dproc, ValueScaler valueScaler) {
        super.resolveText(l, dproc, valueScaler);
        Variable.Value v = dproc.getVariable(this.srcName);
        if (this.resolvedText == null) {
            return;
        }
        if (this.strftime) {
            if (v != Variable.INVALIDVALUE) {
                long time = v.timestamp;
                try {
                    GregorianCalendar c = new GregorianCalendar(dproc.getTimeZone(), l);
                    c.setTimeInMillis(time * 1000L);
                    this.resolvedText = String.format(l, this.resolvedText, c);
                }
                catch (Exception e) {
                    throw new RuntimeException("can't format '" + this.resolvedText + "'", e);
                }
            } else {
                this.resolvedText = "-";
            }
        } else {
            double value = v.value;
            Matcher matcher = UNIT_PATTERN.matcher(this.resolvedText);
            if (matcher.find()) {
                ValueScaler.Scaled scaled = valueScaler.scale(value, matcher.group(2).equals("s"));
                this.resolvedText = this.resolvedText.substring(0, matcher.start()) + matcher.group(1) + scaled.unit + this.resolvedText.substring(matcher.end());
                value = scaled.value;
            }
            try {
                this.resolvedText = Util.sprintf(l, this.resolvedText, value);
            }
            catch (Exception e) {
                throw new RuntimeException("can't format '" + this.resolvedText + "'", e);
            }
        }
        this.trimIfGlue();
    }
}

