/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sonatype.guice.asm.ClassReader;
import org.sonatype.guice.asm.ClassVisitor;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;

public final class ClassSpaceScanner {
    private static final Logger LOGGER = Logger.getLogger(ClassSpaceScanner.class.getName());
    private static final int ASM_FLAGS = 7;
    private final ClassSpace space;

    public ClassSpaceScanner(ClassSpace space) {
        this.space = space;
    }

    public void accept(ClassSpaceVisitor visitor) {
        visitor.visit(this.space);
        Enumeration<URL> e = this.space.findEntries(null, "*.class", true);
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (null == cv) continue;
            ClassSpaceScanner.accept(cv, url);
        }
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accept(ClassVisitor visitor, URL url) {
        if (null == url) {
            return;
        }
        try {
            InputStream in = url.openStream();
            try {
                new ClassReader(in).accept(visitor, 7);
            }
            finally {
                in.close();
            }
        }
        catch (Throwable e) {
            ClassSpaceScanner.reportResourceProblem(url, e);
        }
    }

    private static void reportResourceProblem(URL url, Throwable cause) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Problem scanning resource: " + url + " cause: " + cause);
        }
    }
}

