/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.BasicStroke;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.render.RenderingContext;

public class BorderPainter {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    public static final int ALL = 15;

    public static void paint(Rectangle bounds, int sides, BorderPropertySet border, RenderingContext ctx, int xOffset, boolean bevel) {
        if ((sides & 1) == 1 && border.noTop()) {
            --sides;
        }
        if ((sides & 2) == 2 && border.noLeft()) {
            sides -= 2;
        }
        if ((sides & 4) == 4 && border.noBottom()) {
            sides -= 4;
        }
        if ((sides & 8) == 8 && border.noRight()) {
            sides -= 8;
        }
        if ((sides & 1) == 1 && border.topColor() != FSRGBColor.TRANSPARENT) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 1, border.topStyle(), xOffset, bevel);
        }
        if ((sides & 2) == 2 && border.leftColor() != FSRGBColor.TRANSPARENT) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 2, border.leftStyle(), xOffset, bevel);
        }
        if ((sides & 4) == 4 && border.bottomColor() != FSRGBColor.TRANSPARENT) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 4, border.bottomStyle(), xOffset, bevel);
        }
        if ((sides & 8) == 8 && border.rightColor() != FSRGBColor.TRANSPARENT) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 8, border.rightStyle(), xOffset, bevel);
        }
    }

    private static Rectangle shrinkRect(Rectangle rect, BorderPropertySet border, int sides) {
        Rectangle r2 = new Rectangle();
        r2.x = rect.x + ((sides & 2) == 0 ? 0 : (int)border.left());
        r2.width = rect.width - ((sides & 2) == 0 ? 0 : (int)border.left()) - ((sides & 8) == 0 ? 0 : (int)border.right());
        r2.y = rect.y + ((sides & 1) == 0 ? 0 : (int)border.top());
        r2.height = rect.height - ((sides & 1) == 0 ? 0 : (int)border.top()) - ((sides & 4) == 0 ? 0 : (int)border.bottom());
        return r2;
    }

    private static void paintBorderSide(OutputDevice outputDevice, BorderPropertySet border, Rectangle bounds, int sides, int currentSide, IdentValue borderSideStyle, int xOffset, boolean bevel) {
        if (borderSideStyle == IdentValue.RIDGE || borderSideStyle == IdentValue.GROOVE) {
            BorderPropertySet bd2 = new BorderPropertySet((int)(border.top() / 2.0f), (int)(border.right() / 2.0f), (int)(border.bottom() / 2.0f), (int)(border.left() / 2.0f));
            if (borderSideStyle == IdentValue.RIDGE) {
                BorderPainter.paintBorderSidePolygon(outputDevice, bounds, border, border.darken(borderSideStyle), border.lighten(borderSideStyle), sides, currentSide, bevel);
                BorderPainter.paintBorderSidePolygon(outputDevice, bounds, bd2, border.lighten(borderSideStyle), border.darken(borderSideStyle), sides, currentSide, bevel);
            } else {
                BorderPainter.paintBorderSidePolygon(outputDevice, bounds, border, border.lighten(borderSideStyle), border.darken(borderSideStyle), sides, currentSide, bevel);
                BorderPainter.paintBorderSidePolygon(outputDevice, bounds, bd2, border.darken(borderSideStyle), border.lighten(borderSideStyle), sides, currentSide, bevel);
            }
        } else if (borderSideStyle == IdentValue.OUTSET) {
            BorderPainter.paintBorderSidePolygon(outputDevice, bounds, border, border.lighten(borderSideStyle), border.darken(borderSideStyle), sides, currentSide, bevel);
        } else if (borderSideStyle == IdentValue.INSET) {
            BorderPainter.paintBorderSidePolygon(outputDevice, bounds, border, border.darken(borderSideStyle), border.lighten(borderSideStyle), sides, currentSide, bevel);
        } else if (borderSideStyle == IdentValue.SOLID) {
            BorderPainter.paintSolid(outputDevice, bounds, border, border, sides, currentSide, bevel);
        } else if (borderSideStyle == IdentValue.DOUBLE) {
            BorderPainter.paintDoubleBorder(outputDevice, border, bounds, sides, currentSide, bevel);
        } else {
            int thickness = 0;
            if (currentSide == 1) {
                thickness = (int)border.top();
            }
            if (currentSide == 4) {
                thickness = (int)border.bottom();
            }
            if (currentSide == 8) {
                thickness = (int)border.right();
            }
            if (currentSide == 2) {
                thickness = (int)border.left();
            }
            if (borderSideStyle == IdentValue.DASHED) {
                outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                BorderPainter.paintPatternedRect(outputDevice, bounds, border, border, new float[]{8.0f + (float)(thickness * 2), 4.0f + (float)thickness}, sides, currentSide, xOffset);
                outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (borderSideStyle == IdentValue.DOTTED) {
                outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                BorderPainter.paintPatternedRect(outputDevice, bounds, border, border, new float[]{thickness, thickness}, sides, currentSide, xOffset);
                outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
    }

    private static DoubleBorderInfo calcDoubleBorderInfo(int width) {
        DoubleBorderInfo result = new DoubleBorderInfo();
        if (width == 1) {
            result.setOuter(1);
        } else if (width == 2) {
            result.setOuter(1);
            result.setInner(1);
        } else {
            int extra = width % 3;
            switch (extra) {
                case 0: {
                    result.setOuter(width / 3);
                    result.setCenter(width / 3);
                    result.setInner(width / 3);
                    break;
                }
                case 1: {
                    result.setOuter((width + 2) / 3 - 1);
                    result.setCenter((width + 2) / 3);
                    result.setInner((width + 2) / 3 - 1);
                    break;
                }
                case 2: {
                    result.setOuter((width + 1) / 3);
                    result.setCenter((width + 1) / 3 - 1);
                    result.setInner((width + 1) / 3);
                }
            }
        }
        return result;
    }

    private static void paintDoubleBorder(OutputDevice outputDevice, BorderPropertySet border, Rectangle bounds, int sides, int currentSide, boolean bevel) {
        DoubleBorderInfo topBorderInfo = BorderPainter.calcDoubleBorderInfo((int)border.top());
        DoubleBorderInfo rightBorderInfo = BorderPainter.calcDoubleBorderInfo((int)border.right());
        DoubleBorderInfo bottomBorderInfo = BorderPainter.calcDoubleBorderInfo((int)border.bottom());
        DoubleBorderInfo leftBorderInfo = BorderPainter.calcDoubleBorderInfo((int)border.left());
        BorderPropertySet outer = new BorderPropertySet(topBorderInfo.getOuter(), rightBorderInfo.getOuter(), bottomBorderInfo.getOuter(), leftBorderInfo.getOuter());
        BorderPropertySet center = new BorderPropertySet(topBorderInfo.getCenter(), rightBorderInfo.getCenter(), bottomBorderInfo.getCenter(), leftBorderInfo.getCenter());
        BorderPropertySet inner = new BorderPropertySet(topBorderInfo.getInner(), rightBorderInfo.getInner(), bottomBorderInfo.getInner(), leftBorderInfo.getInner());
        Rectangle b2 = BorderPainter.shrinkRect(bounds, outer, bevel ? sides : currentSide);
        b2 = BorderPainter.shrinkRect(b2, center, bevel ? sides : currentSide);
        BorderPainter.paintSolid(outputDevice, bounds, outer, border, sides, currentSide, bevel);
        BorderPainter.paintSolid(outputDevice, b2, inner, border, sides, currentSide, bevel);
    }

    private static Polygon getBorderSidePolygon(Rectangle bounds, BorderPropertySet border, int sides, int currentSide, boolean bevel) {
        int rightCorner = 0;
        int leftCorner = 0;
        int topCorner = 0;
        int bottomCorner = 0;
        if (bevel) {
            rightCorner = (sides & 8) == 8 ? (int)border.right() : 0;
            leftCorner = (sides & 2) == 2 ? (int)border.left() : 0;
            topCorner = (sides & 1) == 1 ? (int)border.top() : 0;
            bottomCorner = (sides & 4) == 4 ? (int)border.bottom() : 0;
        }
        Polygon poly = null;
        if (currentSide == 1) {
            if ((int)border.top() != 1) {
                poly = new Polygon();
                poly.addPoint(bounds.x, bounds.y);
                poly.addPoint(bounds.x + bounds.width, bounds.y);
                poly.addPoint(bounds.x + bounds.width - rightCorner, bounds.y + (int)border.top() - 0);
                poly.addPoint(bounds.x + leftCorner, bounds.y + (int)border.top() - 0);
            }
        } else if (currentSide == 4) {
            if ((int)border.bottom() != 1) {
                poly = new Polygon();
                poly.addPoint(bounds.x + bounds.width - rightCorner, bounds.y + bounds.height - (int)border.bottom());
                poly.addPoint(bounds.x + leftCorner, bounds.y + bounds.height - (int)border.bottom());
                poly.addPoint(bounds.x, bounds.y + bounds.height);
                poly.addPoint(bounds.x + bounds.width, bounds.y + bounds.height - 0);
            }
        } else if (currentSide == 8) {
            if ((int)border.right() != 1) {
                poly = new Polygon();
                poly.addPoint(bounds.x + bounds.width, bounds.y);
                poly.addPoint(bounds.x + bounds.width - (int)border.right(), bounds.y + topCorner);
                poly.addPoint(bounds.x + bounds.width - (int)border.right(), bounds.y + bounds.height - bottomCorner);
                poly.addPoint(bounds.x + bounds.width, bounds.y + bounds.height);
            }
        } else if (currentSide == 2 && (int)border.left() != 1) {
            poly = new Polygon();
            poly.addPoint(bounds.x, bounds.y);
            poly.addPoint(bounds.x + (int)border.left(), bounds.y + topCorner);
            poly.addPoint(bounds.x + (int)border.left(), bounds.y + bounds.height - bottomCorner);
            poly.addPoint(bounds.x, bounds.y + bounds.height);
        }
        return poly;
    }

    private static void paintPatternedRect(OutputDevice outputDevice, Rectangle bounds, BorderPropertySet border, BorderPropertySet color, float[] pattern, int sides, int currentSide, int xOffset) {
        Stroke old_stroke = outputDevice.getStroke();
        if (currentSide == 1) {
            outputDevice.setColor(color.topColor());
            outputDevice.setStroke(new BasicStroke((int)border.top(), 0, 2, 0.0f, pattern, xOffset));
            outputDevice.drawBorderLine(bounds, 1, (int)border.top(), false);
        } else if (currentSide == 2) {
            outputDevice.setColor(color.leftColor());
            outputDevice.setStroke(new BasicStroke((int)border.left(), 0, 2, 0.0f, pattern, 0.0f));
            outputDevice.drawBorderLine(bounds, 2, (int)border.left(), false);
        } else if (currentSide == 8) {
            outputDevice.setColor(color.rightColor());
            outputDevice.setStroke(new BasicStroke((int)border.right(), 0, 2, 0.0f, pattern, 0.0f));
            outputDevice.drawBorderLine(bounds, 8, (int)border.right(), false);
        } else if (currentSide == 4) {
            outputDevice.setColor(color.bottomColor());
            outputDevice.setStroke(new BasicStroke((int)border.bottom(), 0, 2, 0.0f, pattern, xOffset));
            outputDevice.drawBorderLine(bounds, 4, (int)border.bottom(), false);
        }
        outputDevice.setStroke(old_stroke);
    }

    private static void paintBorderSidePolygon(OutputDevice outputDevice, Rectangle bounds, BorderPropertySet border, BorderPropertySet high, BorderPropertySet low, int sides, int currentSide, boolean bevel) {
        if (currentSide == 1) {
            BorderPainter.paintSolid(outputDevice, bounds, border, high, sides, currentSide, bevel);
        } else if (currentSide == 4) {
            BorderPainter.paintSolid(outputDevice, bounds, border, low, sides, currentSide, bevel);
        } else if (currentSide == 8) {
            BorderPainter.paintSolid(outputDevice, bounds, border, low, sides, currentSide, bevel);
        } else if (currentSide == 2) {
            BorderPainter.paintSolid(outputDevice, bounds, border, high, sides, currentSide, bevel);
        }
    }

    private static void paintSolid(OutputDevice outputDevice, Rectangle bounds, BorderPropertySet border, BorderPropertySet bcolor, int sides, int currentSide, boolean bevel) {
        Polygon poly = BorderPainter.getBorderSidePolygon(bounds, border, sides, currentSide, bevel);
        if (currentSide == 1) {
            outputDevice.setColor(bcolor.topColor());
            if ((int)border.top() == 1) {
                outputDevice.drawBorderLine(bounds, 1, (int)border.top(), true);
            } else {
                outputDevice.fill(poly);
            }
        } else if (currentSide == 4) {
            outputDevice.setColor(bcolor.bottomColor());
            if ((int)border.bottom() == 1) {
                outputDevice.drawBorderLine(bounds, 4, (int)border.bottom(), true);
            } else {
                outputDevice.fill(poly);
            }
        } else if (currentSide == 8) {
            outputDevice.setColor(bcolor.rightColor());
            if ((int)border.right() == 1) {
                outputDevice.drawBorderLine(bounds, 8, (int)border.right(), true);
            } else {
                outputDevice.fill(poly);
            }
        } else if (currentSide == 2) {
            outputDevice.setColor(bcolor.leftColor());
            if ((int)border.left() == 1) {
                outputDevice.drawBorderLine(bounds, 2, (int)border.left(), true);
            } else {
                outputDevice.fill(poly);
            }
        }
    }

    private static class DoubleBorderInfo {
        private int _outer;
        private int _center;
        private int _inner;

        private DoubleBorderInfo() {
        }

        public int getCenter() {
            return this._center;
        }

        public void setCenter(int center) {
            this._center = center;
        }

        public int getInner() {
            return this._inner;
        }

        public void setInner(int inner) {
            this._inner = inner;
        }

        public int getOuter() {
            return this._outer;
        }

        public void setOuter(int outer) {
            this._outer = outer;
        }
    }
}

