/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;

public class FileUtils {
    public static File getTmpDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalStateException();
        }
        return file;
    }

    public static void delete(File file) {
        if (file == null) {
            return;
        }
        Thread.yield();
        Log.info("Deleting temporary file " + file);
        boolean bl = file.delete();
        if (!bl) {
            Log.error("Cannot delete: " + file);
        }
    }

    public static File createTempFile(String string, String string2) throws IOException {
        if (!string2.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        File file = File.createTempFile(string, string2);
        Log.info("Creating temporary file: " + file);
        if (!OptionFlags.getInstance().isKeepTmpFiles()) {
            file.deleteOnExit();
        }
        return file;
    }

    public static void copyToFile(File file, File file2) throws IOException {
        int n;
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            ((OutputStream)bufferedOutputStream).write(n);
        }
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
    }

    public static void copyToStream(File file, OutputStream outputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            ((OutputStream)bufferedOutputStream).write(n);
        }
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
    }

    public static void copyToStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            ((OutputStream)bufferedOutputStream).write(n);
        }
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
    }
}

