/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedCommand
implements Command {
    private final Command cmd;

    public ProtectedCommand(Command command) {
        this.cmd = command;
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        try {
            return this.cmd.execute(list);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            Log.error("Error " + throwable);
            String string = "You should send a mail to plantuml@gmail.com with this log";
            Log.error(string);
            string = string + " " + new String(byteArrayOutputStream.toByteArray());
            return CommandExecutionResult.error(string);
        }
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return this.cmd.getHelpMessageForDeprecated(list);
    }

    @Override
    public boolean isDeprecated(List<String> list) {
        return this.cmd.isDeprecated(list);
    }

    @Override
    public CommandControl isValid(List<String> list) {
        return this.cmd.isValid(list);
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }
}

