/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.Lazy;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class DrawFileFactory {
    public static DrawFile create(final ColorMapper colorMapper, final UDrawable uDrawable, final double d, final double d2, final double d3, final Color color, Object object) {
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("visi", ".png");
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(d * d3, d2 * d3, color);
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                uDrawable.drawU(new UGraphicG2d(colorMapper, emptyImageBuilder.getGraphics2D(), bufferedImage, d3));
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file;
            }
        };
        Lazy<File> lazy2 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("visi", ".eps");
                UGraphicEps.copyEpsToFile(colorMapper, uDrawable, file);
                return file;
            }
        };
        Lazy<String> lazy3 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                return UGraphicG2d.getSvgString(colorMapper, uDrawable);
            }
        };
        return DrawFile.create(lazy, lazy3, lazy2, object);
    }
}

