/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class UnderlineTrick {
    private final BufferedImage im;
    private final int searchedColor;
    private final int underlineColor;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: fileName searchedColor underlineColor");
            System.exit(0);
        }
        File file = new File(stringArray[0]);
        BufferedImage bufferedImage = ImageIO.read(file);
        Color color = new Color(Integer.parseInt(stringArray[1], 16));
        Color color2 = new Color(Integer.parseInt(stringArray[2], 16));
        new UnderlineTrick(bufferedImage, color, color2).process();
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }

    public UnderlineTrick(BufferedImage bufferedImage, Color color, Color color2) {
        this.im = bufferedImage;
        this.searchedColor = color.getRGB();
        this.underlineColor = color2.getRGB();
    }

    public void process() {
        for (int i = 0; i < this.im.getHeight(); ++i) {
            Segment segment;
            Segment segment2;
            int n = 0;
            while (n < this.im.getWidth() && (segment2 = this.searchSegment(n, i)) != null && (segment = this.searchSegment(segment2.end + 1, i)) != null) {
                this.drawLine(segment2.end, segment.start, i);
                n = segment.end + 1;
            }
        }
    }

    private void drawLine(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            this.im.setRGB(i, n3, this.underlineColor);
        }
    }

    private Segment searchSegment(int n, int n2) {
        for (int i = n; i < this.im.getWidth(); ++i) {
            Segment segment = this.searchSegmentExact(i, n2);
            if (segment == null) continue;
            return segment;
        }
        return null;
    }

    private Segment searchSegmentExact(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 6; ++n3) {
            if (this.im.getRGB(n + n3, n2) == this.searchedColor) continue;
            return null;
        }
        for (n3 = n; n3 < this.im.getWidth(); ++n3) {
            if (this.im.getRGB(n3, n2) == this.searchedColor) continue;
            return new Segment(n, n3 - 1);
        }
        return new Segment(n, this.im.getWidth() - 1);
    }

    static class Segment {
        private final int start;
        private final int end;

        Segment(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public String toString() {
            return "" + this.start + "-" + this.end;
        }
    }
}

