/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.plantuml.graph2.MagicPointsFactory;
import net.sourceforge.plantuml.graph2.MyCurve;
import net.sourceforge.plantuml.graph2.RectanglesCollection;

public class CubicCurveFactory {
    private final Point2D.Double start;
    private final Point2D.Double end;
    private final RectanglesCollection forbiddenRect = new RectanglesCollection();
    private final List<MyCurve> forbiddenCurves = new ArrayList<MyCurve>();

    public CubicCurveFactory(Point2D point2D, Point2D point2D2) {
        this.start = new Point2D.Double(point2D.getX(), point2D.getY());
        this.end = new Point2D.Double(point2D2.getX(), point2D2.getY());
    }

    public void addForbidden(Rectangle2D.Double double_) {
        this.forbiddenRect.add(double_);
    }

    public void addForbidden(MyCurve myCurve) {
        this.forbiddenCurves.add(myCurve);
    }

    public MyCurve getCubicCurve2D() {
        MyCurve myCurve = new MyCurve(new CubicCurve2D.Double(this.start.getX(), this.start.getY(), this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY(), this.end.getX(), this.end.getY()));
        if (myCurve.intersects(this.forbiddenRect) || myCurve.intersects(this.forbiddenCurves)) {
            HashSet<Point2D.Double> hashSet = new HashSet<Point2D.Double>();
            hashSet.addAll(MagicPointsFactory.get(this.start, this.end));
            for (Rectangle2D.Double double_ : this.forbiddenRect) {
                hashSet.addAll(MagicPointsFactory.get(double_));
            }
            System.err.println("s1 " + hashSet.size());
            long l = System.currentTimeMillis();
            double d = Double.MAX_VALUE;
            for (Point2D.Double double_ : hashSet) {
                for (Point2D.Double double_2 : hashSet) {
                    MyCurve myCurve2 = new MyCurve(new CubicCurve2D.Double(this.start.getX(), this.start.getY(), double_.getX(), double_.getY(), double_2.getX(), double_2.getY(), this.end.getX(), this.end.getY()));
                    if (!(myCurve2.getLenght() < d) || myCurve2.intersects(this.forbiddenRect) || myCurve2.intersects(this.forbiddenCurves)) continue;
                    myCurve = myCurve2;
                    d = myCurve2.getLenght();
                }
            }
            long l2 = System.currentTimeMillis() - l;
            System.err.println("s2 = " + l2);
            System.err.println("TPS1 = " + RectanglesCollection.TPS1);
            System.err.println("TPS2 = " + RectanglesCollection.TPS2);
        }
        return myCurve;
    }
}

