/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseDivider
extends AbstractTextualComponent {
    private final HtmlColor background;

    public ComponentRoseDivider(HtmlColor htmlColor, UFont uFont, HtmlColor htmlColor2, List<? extends CharSequence> list) {
        super(list, htmlColor, uFont, HorizontalAlignement.CENTER, 4, 4, 4);
        this.background = htmlColor2;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextWidth(stringBounder);
        double d2 = this.getTextHeight(stringBounder);
        double d3 = (dimension2D.getWidth() - d - 6.0) / 2.0;
        double d4 = (dimension2D.getHeight() - d2) / 2.0;
        uGraphic.getParam().setColor(HtmlColor.BLACK);
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 - 1.0, new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 + 2.0, new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.getParam().setColor(HtmlColor.BLACK);
        uGraphic.getParam().setBackcolor(this.background);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d3, d4, new URectangle(d + 6.0, d2));
        uGraphic.getParam().setStroke(new UStroke());
        textBlock.drawU(uGraphic, d3 + 6.0, d4 + (double)this.getMarginY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

