/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SkinParamBackcoloredReference;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantEngloberContexted;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.Constraint;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDelayText;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalDivider;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalNewpage;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalReference;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingElse;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingHeader;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingTail;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Pushable;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Message;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1MessageExo;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrawableSetInitializer {
    private ComponentType defaultLineType;
    private final DrawableSet drawableSet;
    private final boolean showTail;
    private double freeX = 0.0;
    private double freeY = 0.0;
    private final double autonewpage;
    private ConstraintSet constraintSet;
    private double lastFreeY = 0.0;
    private List<InGroupableList> inGroupableLists = new ArrayList<InGroupableList>();

    public DrawableSetInitializer(Skin skin, ISkinParam iSkinParam, boolean bl, double d) {
        this.drawableSet = new DrawableSet(skin, iSkinParam);
        this.showTail = bl;
        this.autonewpage = d;
    }

    private boolean hasDelay() {
        for (Event event : this.drawableSet.getAllEvents()) {
            if (!(event instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public DrawableSet createDrawableSet(StringBounder stringBounder) {
        if (this.freeY != 0.0) {
            throw new IllegalStateException();
        }
        this.defaultLineType = this.hasDelay() ? ComponentType.CONTINUE_LINE : ComponentType.PARTICIPANT_LINE;
        for (Participant iterator : this.drawableSet.getAllParticipants()) {
            this.prepareParticipant(stringBounder, iterator);
        }
        this.lastFreeY = this.freeY = this.drawableSet.getHeadHeight(stringBounder);
        this.drawableSet.setTopStartingY(this.freeY);
        for (Participant participant : this.drawableSet.getAllParticipants()) {
            LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(participant);
            for (int i = 0; i < participant.getInitialLife(); ++i) {
                livingParticipantBox.getLifeLine().addSegmentVariation(LifeSegmentVariation.LARGER, this.freeY, participant.getLiveSpecificBackColor());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (LivingParticipantBox livingParticipantBox : this.drawableSet.getAllLivingParticipantBox()) {
            arrayList.add(livingParticipantBox.getParticipantBox());
        }
        this.constraintSet = new ConstraintSet(arrayList, this.freeX);
        for (Event event : new ArrayList<Event>(this.drawableSet.getAllEvents())) {
            double d = this.freeY - this.lastFreeY;
            if (this.autonewpage > 0.0 && d > 0.0 && d + this.getTotalHeight(0.0, stringBounder) > this.autonewpage) {
                this.prepareNewpageSpecial(stringBounder, new Newpage(null), event);
            }
            if (event instanceof MessageExo) {
                this.prepareMessageExo(stringBounder, (MessageExo)event);
                continue;
            }
            if (event instanceof Message) {
                this.prepareMessage(stringBounder, (Message)event);
                continue;
            }
            if (event instanceof Note) {
                this.prepareNote(stringBounder, (Note)event);
                continue;
            }
            if (event instanceof LifeEvent) {
                this.prepareLiveEvent(stringBounder, (LifeEvent)event);
                continue;
            }
            if (event instanceof GroupingLeaf) {
                this.prepareGroupingLeaf(stringBounder, (GroupingLeaf)event);
                continue;
            }
            if (event instanceof GroupingStart) {
                this.prepareGroupingStart(stringBounder, (GroupingStart)event);
                continue;
            }
            if (event instanceof Newpage) {
                this.prepareNewpage(stringBounder, (Newpage)event);
                continue;
            }
            if (event instanceof Divider) {
                this.prepareDivider(stringBounder, (Divider)event);
                continue;
            }
            if (event instanceof Delay) {
                this.prepareDelay(stringBounder, (Delay)event, arrayList);
                continue;
            }
            if (event instanceof Reference) {
                this.prepareReference(stringBounder, (Reference)event);
                continue;
            }
            throw new IllegalStateException();
        }
        this.constraintSet.takeConstraintIntoAccount(stringBounder);
        this.takeParticipantEngloberTitleWidth3(stringBounder);
        this.prepareMissingSpace(stringBounder);
        this.drawableSet.setDimension(new Dimension2DDouble(this.freeX, this.getTotalHeight(this.freeY, stringBounder)));
        return this.drawableSet;
    }

    private void takeParticipantEngloberTitleWidth3(StringBounder stringBounder) {
        for (ParticipantEngloberContexted participantEngloberContexted : this.drawableSet.getExistingParticipantEnglober()) {
            double d = this.drawableSet.getEngloberPreferedWidth(stringBounder, participantEngloberContexted.getParticipantEnglober());
            ParticipantBox participantBox = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getFirst2()).getParticipantBox();
            ParticipantBox participantBox2 = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getLast2()).getParticipantBox();
            double d2 = this.drawableSet.getX1(participantEngloberContexted);
            double d3 = this.drawableSet.getX2(stringBounder, participantEngloberContexted);
            double d4 = d - (d3 - d2);
            if (!(d4 > 0.0)) continue;
            this.constraintSet.pushToLeftParticipantBox(d4 / 2.0, participantBox, true);
            this.constraintSet.pushToLeftParticipantBox(d4 / 2.0, participantBox2, false);
        }
    }

    private void takeParticipantEngloberTitleWidth2(StringBounder stringBounder) {
        for (ParticipantEngloberContexted participantEngloberContexted : this.drawableSet.getExistingParticipantEnglober()) {
            double d = this.drawableSet.getEngloberPreferedWidth(stringBounder, participantEngloberContexted.getParticipantEnglober());
            ParticipantBox participantBox = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getFirst2()).getParticipantBox();
            ParticipantBox participantBox2 = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getLast2()).getParticipantBox();
            double d2 = this.drawableSet.getX1(participantEngloberContexted);
            double d3 = this.drawableSet.getX2(stringBounder, participantEngloberContexted);
            double d4 = d - (d3 - d2);
            System.err.println("x1=" + d2 + " x2=" + d3 + " preferredWidth=" + d + " missing=" + d4);
            if (d4 > 0.0) {
                this.constraintSet.getConstraintAfter(participantBox2).push(d4);
                this.constraintSet.takeConstraintIntoAccount(stringBounder);
            }
            double d5 = d3;
        }
    }

    private void takeParticipantEngloberTitleWidth(StringBounder stringBounder) {
        ParticipantBox participantBox = null;
        for (ParticipantEngloberContexted participantEngloberContexted : this.drawableSet.getExistingParticipantEnglober()) {
            Object object;
            Object object2;
            ParticipantBox participantBox2;
            double d = this.drawableSet.getEngloberPreferedWidth(stringBounder, participantEngloberContexted.getParticipantEnglober());
            ParticipantBox participantBox3 = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getFirst2()).getParticipantBox();
            if (participantBox3 == (participantBox2 = this.drawableSet.getLivingParticipantBox(participantEngloberContexted.getLast2()).getParticipantBox())) {
                object2 = this.constraintSet.getConstraintBefore(participantBox3);
                object = this.constraintSet.getConstraintAfter(participantBox2);
                double d2 = ((Constraint)object2).getParticipant1().getPreferredWidth(stringBounder);
                double d3 = ((Constraint)object).getParticipant2().getPreferredWidth(stringBounder);
                ((Constraint)object2).ensureValue(d / 2.0 + d2 / 2.0 + 5.0);
                ((Constraint)object).ensureValue(d / 2.0 + d3 / 2.0 + 5.0);
            } else {
                object2 = this.constraintSet.getPrevious(participantBox3);
                object = this.constraintSet.getNext(participantBox2);
                Constraint constraint = this.constraintSet.getConstraint((Pushable)object2, (Pushable)object);
                constraint.ensureValue(d + object2.getPreferredWidth(stringBounder) / 2.0 + object.getPreferredWidth(stringBounder) / 2.0 + 10.0);
            }
            participantBox = participantBox2;
        }
    }

    private double getTotalHeight(double d, StringBounder stringBounder) {
        return d + this.drawableSet.getTailHeight(stringBounder, this.showTail) + 0.0;
    }

    public double getYposition(StringBounder stringBounder, Newpage newpage) {
        if (newpage == null) {
            throw new IllegalArgumentException();
        }
        GraphicalNewpage graphicalNewpage = (GraphicalNewpage)this.drawableSet.getEvent(newpage);
        return graphicalNewpage.getStartingY();
    }

    private void prepareMissingSpace(StringBounder stringBounder) {
        this.freeX = this.constraintSet.getMaxX();
        double d = 0.0;
        double d2 = 0.0;
        for (GraphicalElement graphicalElement : this.drawableSet.getAllGraphicalElements()) {
            double d3;
            double d4;
            GraphicalElement graphicalElement2;
            double d5 = graphicalElement.getStartingX(stringBounder);
            double d6 = -d5;
            if (d6 > d) {
                d = d6;
            }
            if (graphicalElement instanceof Arrow) {
                Arrow arrow = (Arrow)graphicalElement;
                arrow.setMaxX(this.freeX);
            }
            double d7 = graphicalElement.getPreferredWidth(stringBounder);
            if (graphicalElement instanceof Arrow && d7 < ((Arrow)(graphicalElement2 = (Arrow)graphicalElement)).getActualWidth(stringBounder)) {
                d7 = ((Arrow)graphicalElement2).getActualWidth(stringBounder);
            }
            if (graphicalElement instanceof GroupingHeader && d7 < ((GroupingGraphicalElement)(graphicalElement2 = (GroupingHeader)graphicalElement)).getActualWidth(stringBounder)) {
                d7 = ((GroupingGraphicalElement)graphicalElement2).getActualWidth(stringBounder);
            }
            if (!((d4 = (d3 = d5 + d7) - this.freeX) > d2)) continue;
            d2 = d4;
        }
        if (d > 0.0) {
            this.constraintSet.pushToLeft(d);
        }
        this.freeX = this.constraintSet.getMaxX() + d2;
    }

    private void prepareNewpage(StringBounder stringBounder, Newpage newpage) {
        GraphicalNewpage graphicalNewpage = new GraphicalNewpage(this.freeY, this.drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, this.drawableSet.getSkinParam(), null));
        this.lastFreeY = this.freeY;
        this.freeY += graphicalNewpage.getPreferredHeight(stringBounder);
        this.drawableSet.addEvent(newpage, graphicalNewpage);
    }

    private void prepareNewpageSpecial(StringBounder stringBounder, Newpage newpage, Event event) {
        GraphicalNewpage graphicalNewpage = new GraphicalNewpage(this.freeY, this.drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, this.drawableSet.getSkinParam(), null));
        this.lastFreeY = this.freeY;
        this.freeY += graphicalNewpage.getPreferredHeight(stringBounder);
        this.drawableSet.addEvent(newpage, graphicalNewpage, event);
    }

    private void prepareDivider(StringBounder stringBounder, Divider divider) {
        GraphicalDivider graphicalDivider = new GraphicalDivider(this.freeY, this.drawableSet.getSkin().createComponent(ComponentType.DIVIDER, this.drawableSet.getSkinParam(), divider.getText()));
        this.freeY += graphicalDivider.getPreferredHeight(stringBounder);
        this.drawableSet.addEvent(divider, graphicalDivider);
    }

    private void prepareDelay(StringBounder stringBounder, Delay delay, Collection<ParticipantBox> collection) {
        Component component = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_TEXT, this.drawableSet.getSkinParam(), delay.getText());
        GraphicalDelayText graphicalDelayText = new GraphicalDelayText(this.freeY, component);
        for (ParticipantBox participantBox : collection) {
            participantBox.addDelay(graphicalDelayText);
        }
        this.freeY += graphicalDelayText.getPreferredHeight(stringBounder);
        this.drawableSet.addEvent(delay, graphicalDelayText);
    }

    private void prepareGroupingStart(StringBounder stringBounder, GroupingStart groupingStart) {
        if (groupingStart.getType() != GroupingType.START) {
            throw new IllegalStateException();
        }
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.drawableSet.getSkinParam(), groupingStart.getBackColorElement(), groupingStart.getBackColorGeneral());
        List<String> list = groupingStart.getTitle().equals("group") ? Arrays.asList(groupingStart.getComment()) : Arrays.asList(groupingStart.getTitle(), groupingStart.getComment());
        Component component = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_HEADER, skinParamBackcolored, list);
        InGroupableList inGroupableList = new InGroupableList(groupingStart, this.freeY);
        for (InGroupableList inGroupableList2 : this.inGroupableLists) {
            inGroupableList2.addInGroupable(inGroupableList);
        }
        this.inGroupableLists.add(inGroupableList);
        GroupingHeader groupingHeader = new GroupingHeader(this.freeY, component, inGroupableList);
        inGroupableList.setMinWidth(((GraphicalElement)groupingHeader).getPreferredWidth(stringBounder));
        this.freeY += ((GraphicalElement)groupingHeader).getPreferredHeight(stringBounder);
        this.drawableSet.addEvent(groupingStart, groupingHeader);
    }

    private void prepareGroupingLeaf(StringBounder stringBounder, GroupingLeaf groupingLeaf) {
        GroupingGraphicalElement groupingGraphicalElement;
        if (groupingLeaf.getType() == GroupingType.ELSE) {
            SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.drawableSet.getSkinParam(), null, groupingLeaf.getJustBefore().getBackColorGeneral());
            GraphicalElement graphicalElement = this.drawableSet.getEvent(groupingLeaf.getJustBefore());
            Component component = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_ELSE, skinParamBackcolored, Arrays.asList(groupingLeaf.getComment()));
            Component component2 = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_BODY, skinParamBackcolored, null);
            double d = graphicalElement.getStartingY();
            if (graphicalElement instanceof GroupingHeader) {
                d += graphicalElement.getPreferredHeight(stringBounder);
            }
            groupingGraphicalElement = new GroupingElse(this.freeY, d, component2, component, this.getTopGroupingStructure());
            this.freeY += groupingGraphicalElement.getPreferredHeight(stringBounder);
        } else if (groupingLeaf.getType() == GroupingType.END) {
            SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.drawableSet.getSkinParam(), null, groupingLeaf.getJustBefore().getBackColorGeneral());
            GraphicalElement graphicalElement = this.drawableSet.getEvent(groupingLeaf.getJustBefore());
            Component component = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_BODY, skinParamBackcolored, null);
            Component component3 = this.drawableSet.getSkin().createComponent(ComponentType.GROUPING_TAIL, skinParamBackcolored, null);
            double d = graphicalElement.getStartingY();
            if (graphicalElement instanceof GroupingHeader) {
                d += component3.getPreferredHeight(stringBounder);
            }
            groupingGraphicalElement = new GroupingTail(this.freeY, d, component, component3, this.getTopGroupingStructure());
            this.freeY += component3.getPreferredHeight(stringBounder);
            int n = this.inGroupableLists.size() - 1;
            this.inGroupableLists.remove(n);
        } else {
            throw new IllegalStateException();
        }
        this.drawableSet.addEvent(groupingLeaf, groupingGraphicalElement);
    }

    private void prepareNote(StringBounder stringBounder, Note note) {
        Object object;
        Object object2;
        LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(note.getParticipant());
        if (note.getParticipant2() == null) {
            object2 = null;
        } else {
            object2 = this.drawableSet.getLivingParticipantBox(note.getParticipant2());
            if (livingParticipantBox.getParticipantBox().getCenterX(stringBounder) > ((LivingParticipantBox)object2).getParticipantBox().getCenterX(stringBounder)) {
                object = livingParticipantBox;
                livingParticipantBox = object2;
                object2 = object;
            }
        }
        object = new SkinParamBackcolored(this.drawableSet.getSkinParam(), note.getSpecificBackColor());
        NoteBox noteBox = new NoteBox(this.freeY, this.drawableSet.getSkin().createComponent(ComponentType.NOTE, (ISkinParam)object, note.getStrings()), livingParticipantBox, (LivingParticipantBox)object2, note.getPosition(), note.getUrl());
        for (InGroupableList inGroupableList : this.inGroupableLists) {
            inGroupableList.addInGroupable(noteBox);
        }
        this.drawableSet.addEvent(note, noteBox);
        this.freeY += noteBox.getPreferredHeight(stringBounder);
    }

    private void prepareLiveEvent(StringBounder stringBounder, LifeEvent lifeEvent) {
        if (lifeEvent.getType() != LifeEventType.DESTROY && lifeEvent.getType() != LifeEventType.CREATE) {
            throw new IllegalStateException();
        }
    }

    private void prepareMessage(StringBounder stringBounder, Message message) {
        Step1Message step1Message = new Step1Message(stringBounder, message, this.drawableSet, this.freeY);
        this.freeY = step1Message.prepareMessage(this.constraintSet, this.inGroupableLists);
    }

    private void prepareReference(StringBounder stringBounder, Reference reference) {
        LivingParticipantBox livingParticipantBox = this.drawableSet.getLivingParticipantBox(this.drawableSet.getFirst(reference.getParticipant()));
        LivingParticipantBox livingParticipantBox2 = this.drawableSet.getLivingParticipantBox(this.drawableSet.getLast(reference.getParticipant()));
        SkinParamBackcoloredReference skinParamBackcoloredReference = new SkinParamBackcoloredReference(this.drawableSet.getSkinParam(), reference.getBackColorElement(), reference.getBackColorGeneral());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ref");
        arrayList.addAll(reference.getStrings());
        Component component = this.drawableSet.getSkin().createComponent(ComponentType.REFERENCE, skinParamBackcoloredReference, arrayList);
        GraphicalReference graphicalReference = new GraphicalReference(this.freeY, component, livingParticipantBox, livingParticipantBox2, reference.getUrl());
        ParticipantBox participantBox = livingParticipantBox.getParticipantBox();
        ParticipantBox participantBox2 = livingParticipantBox2.getParticipantBox();
        double d = graphicalReference.getPreferredWidth(stringBounder) - participantBox.getPreferredWidth(stringBounder) / 2.0 - participantBox2.getPreferredWidth(stringBounder) / 2.0;
        Constraint constraint = livingParticipantBox == livingParticipantBox2 ? this.constraintSet.getConstraintAfter(participantBox) : this.constraintSet.getConstraint(participantBox, participantBox2);
        constraint.ensureValue(d);
        if (this.inGroupableLists != null) {
            for (InGroupableList inGroupableList : this.inGroupableLists) {
                inGroupableList.addInGroupable(graphicalReference);
                inGroupableList.addInGroupable(livingParticipantBox);
                if (livingParticipantBox == livingParticipantBox2) continue;
                inGroupableList.addInGroupable(livingParticipantBox2);
            }
        }
        this.freeY += graphicalReference.getPreferredHeight(stringBounder);
        this.drawableSet.addEvent(reference, graphicalReference);
    }

    private void prepareMessageExo(StringBounder stringBounder, MessageExo messageExo) {
        Step1MessageExo step1MessageExo = new Step1MessageExo(stringBounder, messageExo, this.drawableSet, this.freeY);
        this.freeY = step1MessageExo.prepareMessage(this.constraintSet, this.inGroupableLists);
    }

    private InGroupableList getTopGroupingStructure() {
        if (this.inGroupableLists.size() == 0) {
            return null;
        }
        return this.inGroupableLists.get(this.inGroupableLists.size() - 1);
    }

    private void prepareParticipant(StringBounder stringBounder, Participant participant) {
        ParticipantBox participantBox;
        Object object;
        Object object2;
        if (participant.getType() == ParticipantType.PARTICIPANT) {
            object2 = new SkinParamBackcolored(this.drawableSet.getSkinParam(), participant.getSpecificBackColor());
            object = this.drawableSet.getSkin().createComponent(ComponentType.PARTICIPANT_HEAD, (ISkinParam)object2, participant.getDisplay());
            Component component = this.drawableSet.getSkin().createComponent(ComponentType.PARTICIPANT_TAIL, (ISkinParam)object2, participant.getDisplay());
            Component component2 = this.drawableSet.getSkin().createComponent(this.defaultLineType, this.drawableSet.getSkinParam(), participant.getDisplay());
            Component component3 = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_LINE, this.drawableSet.getSkinParam(), participant.getDisplay());
            participantBox = new ParticipantBox((Component)object, component2, component, component3, this.freeX);
        } else if (participant.getType() == ParticipantType.ACTOR) {
            object2 = new SkinParamBackcolored(this.drawableSet.getSkinParam(), participant.getSpecificBackColor());
            object = this.drawableSet.getSkin().createComponent(ComponentType.ACTOR_HEAD, (ISkinParam)object2, participant.getDisplay());
            Component component = this.drawableSet.getSkin().createComponent(ComponentType.ACTOR_TAIL, (ISkinParam)object2, participant.getDisplay());
            Component component4 = this.drawableSet.getSkin().createComponent(this.defaultLineType, this.drawableSet.getSkinParam(), participant.getDisplay());
            Component component5 = this.drawableSet.getSkin().createComponent(ComponentType.DELAY_LINE, this.drawableSet.getSkinParam(), participant.getDisplay());
            participantBox = new ParticipantBox((Component)object, component4, component, component5, this.freeX);
        } else {
            throw new IllegalArgumentException();
        }
        object2 = this.drawableSet.getSkin().createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, this.drawableSet.getSkinParam(), null);
        object = new LifeLine(participantBox, object2.getPreferredWidth(stringBounder));
        this.drawableSet.setLivingParticipantBox(participant, new LivingParticipantBox(participantBox, (LifeLine)object));
        this.freeX = participantBox.getMaxX(stringBounder);
    }

    public void addParticipant(Participant participant, ParticipantEnglober participantEnglober) {
        this.drawableSet.addParticipant(participant, participantEnglober);
    }

    public void addEvent(Event event) {
        this.drawableSet.addEvent(event, null);
    }
}

