/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration;

import edu.uiuc.ncsa.security.core.exceptions.ConfigurationException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Configurations {
    public static void killLog4J() {
        ArrayList<Logger> loggers = Collections.list(LogManager.getCurrentLoggers());
        loggers.add(LogManager.getRootLogger());
        for (Logger logger : loggers) {
            logger.setLevel(Level.OFF);
        }
    }

    public static XMLConfiguration getConfiguration(File file) {
        if (file == null) {
            throw new ConfigurationException("Error: no configuration file");
        }
        if (!file.exists()) {
            throw new ConfigurationException("Error: file \"" + file.getAbsolutePath() + "\" does not exist");
        }
        if (!file.isFile()) {
            throw new ConfigurationException("Error: \"" + file.getAbsolutePath() + "\" is not a file");
        }
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        try {
            return new XMLConfiguration(file);
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            throw new ConfigurationException("Error: Could not create configuration from file \"" + file + "\"", e);
        }
    }

    public static XMLConfiguration getConfiguration(URL resourceName) {
        try {
            AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
            return new XMLConfiguration(resourceName);
        }
        catch (org.apache.commons.configuration.ConfigurationException cx) {
            throw new ConfigurationException("Error: could not get configuration for resource " + resourceName, cx);
        }
    }

    public static String getNodeValue(ConfigurationNode node, String name) {
        List list = node.getChildren(name);
        if (list.isEmpty()) {
            return null;
        }
        return ((ConfigurationNode)list.get(0)).getValue().toString();
    }

    public static String getFirstAttribute(ConfigurationNode node, String name) {
        List list = node.getAttributes(name);
        if (list.isEmpty()) {
            return null;
        }
        ConfigurationNode cn = (ConfigurationNode)list.get(0);
        return cn.getValue().toString();
    }

    public static String getNodeValue(ConfigurationNode node, String name, String defaultValue) {
        String x = Configurations.getNodeValue(node, name);
        return x == null ? defaultValue : x;
    }

    public static ConfigurationNode getConfig(XMLConfiguration cfg, String topNodeName, String configName) {
        List list = cfg.configurationsAt(topNodeName);
        ConfigurationNode configurationNode = null;
        for (int i = 0; i < list.size(); ++i) {
            SubnodeConfiguration cn = (SubnodeConfiguration)list.get(i);
            List nameAttribs = cn.getRootNode().getAttributes("name");
            for (int j = 0; j < nameAttribs.size(); ++j) {
                ConfigurationNode attrcn = (ConfigurationNode)nameAttribs.get(j);
                if (!attrcn.getValue().equals(configName)) continue;
                configurationNode = cn.getRootNode();
            }
            if (configurationNode == null) continue;
            String alias = Configurations.getFirstAttribute(configurationNode, "alias");
            if (alias != null && 0 < alias.length()) {
                return Configurations.getConfig(cfg, topNodeName, alias);
            }
            return configurationNode;
        }
        throw new ConfigurationException("Configuration \"" + configName + "\" not found");
    }
}

