/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import org.apache.jena.atlas.lib.ActionKeyValue;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheStats;
import org.apache.jena.atlas.lib.cache.CacheWrapper;

public class CacheStatsSimple<Key, Value>
extends CacheWrapper<Key, Value>
implements CacheStats<Key, Value> {
    private long cacheEntries = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private long cacheEjects = 0L;

    public CacheStatsSimple(Cache<Key, Value> cache) {
        super(cache);
        cache.setDropHandler(new EjectMonitor(null));
    }

    @Override
    public Value get(Key key) {
        if (this.cache.containsKey(key)) {
            ++this.cacheMisses;
        } else {
            ++this.cacheHits;
        }
        return this.cache.get(key);
    }

    @Override
    public Value put(Key key, Value value) {
        Value v = this.cache.put(key, value);
        if (v == null) {
            ++this.cacheEntries;
        }
        return v;
    }

    @Override
    public boolean remove(Key key) {
        boolean b = this.cache.remove(key);
        if (b) {
            --this.cacheEntries;
        }
        return b;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.cacheEntries = 0L;
    }

    @Override
    public void setDropHandler(ActionKeyValue<Key, Value> dropHandler) {
        this.cache.setDropHandler(new EjectMonitor(dropHandler));
    }

    @Override
    public final long getCacheEntries() {
        return this.cacheEntries;
    }

    @Override
    public final long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public final long getCacheMisses() {
        return this.cacheMisses;
    }

    @Override
    public final long getCacheEjects() {
        return this.cacheEjects;
    }

    private class EjectMonitor
    implements ActionKeyValue<Key, Value> {
        private ActionKeyValue<Key, Value> other;

        EjectMonitor(ActionKeyValue<Key, Value> other) {
            this.other = other;
        }

        @Override
        public void apply(Key key, Value thing) {
            CacheStatsSimple.this.cacheEjects++;
            if (this.other != null) {
                this.other.apply(key, thing);
            }
        }
    }
}

