/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class HINFORecord
extends Record {
    private static HINFORecord member = new HINFORecord();
    private String cpu;
    private String os;

    private HINFORecord() {
    }

    private HINFORecord(Name name, short dclass, int ttl) {
        super(name, (short)13, dclass, ttl);
    }

    static HINFORecord getMember() {
        return member;
    }

    public HINFORecord(Name name, short dclass, int ttl, String cpu, String os) {
        this(name, dclass, ttl);
        this.cpu = cpu;
        this.os = os;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        HINFORecord rec = new HINFORecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.cpu = in.readString();
        rec.os = in.readString();
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        HINFORecord rec = new HINFORecord(name, dclass, ttl);
        rec.cpu = st.nextToken();
        rec.os = st.nextToken();
        return rec;
    }

    public String getCPU() {
        return this.cpu;
    }

    public String getOS() {
        return this.os;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.cpu == null || this.os == null) {
            return;
        }
        out.writeString(this.cpu);
        out.writeString(this.os);
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cpu != null && this.os != null) {
            sb.append("\"");
            sb.append(this.cpu);
            sb.append("\" \"");
            sb.append(this.os);
            sb.append("\"");
        }
        return sb.toString();
    }
}

