/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.ore;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.util.EncodingUtilities;
import org.dataone.vocabulary.DC_TERMS;
import org.dataone.vocabulary.PROV;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParser;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.OREParserFactory;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ORESerialiserFactory;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;
import org.dspace.foresite.Triple;

public class ProvResourceMapBuilder {
    private static String D1_URI_PREFIX;
    private Model rdfModel = ModelFactory.createDefaultModel();
    private static Log log;
    private static final String DEFAULT_RDF_FORMAT = "RDF/XML";

    public ProvResourceMapBuilder() {
        this.setNamespacePrefixes();
    }

    public ResourceMap addWasDerivedFrom(ResourceMap resourceMap, Identifier primaryDataId, Identifier derivedDataId) throws OREException, URISyntaxException {
        Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)derivedDataId.getValue())), (Predicate)PROV.predicate("wasDerivedFrom"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)primaryDataId.getValue())));
        resourceMap.addTriple(triple);
        return resourceMap;
    }

    public ResourceMap addWasDerivedFrom(ResourceMap resourceMap, Map<Identifier, List<Identifier>> idMap) throws OREException, URISyntaxException {
        for (Identifier derivedDataId : idMap.keySet()) {
            List<Identifier> primaryDataIds = idMap.get(derivedDataId);
            for (Identifier primaryDataId : primaryDataIds) {
                Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)derivedDataId.getValue())), (Predicate)PROV.predicate("wasDerivedFrom"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)primaryDataId.getValue())));
                resourceMap.addTriple(triple);
            }
        }
        return resourceMap;
    }

    public ResourceMap addWasGeneratedBy(ResourceMap resourceMap, Identifier subjectId, Identifier objectId) throws OREException, URISyntaxException {
        Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)subjectId.getValue())), (Predicate)PROV.predicate("wasGeneratedBy"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)objectId.getValue())));
        resourceMap.addTriple(triple);
        return resourceMap;
    }

    public ResourceMap addWasGeneratedBy(ResourceMap resourceMap, Map<Identifier, List<Identifier>> idMap) throws OREException, URISyntaxException {
        for (Identifier subjectId : idMap.keySet()) {
            List<Identifier> objectIds = idMap.get(subjectId);
            for (Identifier objectId : objectIds) {
                Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)subjectId.getValue())), (Predicate)PROV.predicate("wasGeneratedBy"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)objectId.getValue())));
                resourceMap.addTriple(triple);
            }
        }
        return resourceMap;
    }

    public ResourceMap addWasInformedBy(ResourceMap resourceMap, Identifier subjectId, Identifier objectId) throws OREException, URISyntaxException {
        Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)subjectId.getValue())), (Predicate)PROV.predicate("wasInformedBy"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)objectId.getValue())));
        resourceMap.addTriple(triple);
        return resourceMap;
    }

    public ResourceMap addWasInformedBy(ResourceMap resourceMap, Map<Identifier, List<Identifier>> idMap) throws OREException, URISyntaxException {
        for (Identifier subjectId : idMap.keySet()) {
            List<Identifier> objectIds = idMap.get(subjectId);
            for (Identifier objectId : objectIds) {
                Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)subjectId.getValue())), (Predicate)PROV.predicate("wasInformedBy"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)objectId.getValue())));
                resourceMap.addTriple(triple);
            }
        }
        return resourceMap;
    }

    public ResourceMap addUsed(ResourceMap resourceMap, Identifier subjectId, Identifier objectId) throws OREException, URISyntaxException {
        Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)subjectId.getValue())), (Predicate)PROV.predicate("used"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)objectId.getValue())));
        resourceMap.addTriple(triple);
        return resourceMap;
    }

    public ResourceMap addUsed(ResourceMap resourceMap, Map<Identifier, List<Identifier>> idMap) throws OREException, URISyntaxException {
        for (Identifier subjectId : idMap.keySet()) {
            List<Identifier> objectIds = idMap.get(subjectId);
            for (Identifier objectId : objectIds) {
                Triple triple = OREFactory.createTriple((URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)subjectId.getValue())), (Predicate)PROV.predicate("used"), (URI)new URI(D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)objectId.getValue())));
                resourceMap.addTriple(triple);
            }
        }
        return resourceMap;
    }

    public ResourceMap insertRelationship(ResourceMap resourceMap, Resource subject, Property predicate, List<RDFNode> objects) throws OREException {
        this.setModel(resourceMap);
        if (subject == null) {
            throw new OREException("Subject cannot be null. Please set the subject Resource.");
        }
        Statement statement = null;
        for (RDFNode object : objects) {
            boolean exists = false;
            if (object == null) {
                throw new OREException("Object cannot be null. Please set the object Resource.");
            }
            if (subject.isAnon()) {
                Statement idStatement = subject.getProperty(DC_TERMS.identifier);
                SimpleSelector idSelector = new SimpleSelector(null, idStatement.getPredicate(), idStatement.getObject());
                StmtIterator statements = this.rdfModel.listStatements((Selector)idSelector);
                if (statements.hasNext()) {
                    exists = true;
                    subject = statements.nextStatement().getSubject();
                } else {
                    subject = this.rdfModel.createResource(subject.getId()).addProperty(DC_TERMS.identifier, subject.getId().getLabelString());
                    exists = true;
                }
            } else {
                exists = this.rdfModel.containsResource((RDFNode)subject);
            }
            if (!exists) {
                exists = this.rdfModel.containsResource(object);
            }
            if (!exists) {
                throw new OREException("Either the subject or object of the statement must exist in the model.  Please ensure one is present.");
            }
            statement = this.rdfModel.createStatement(subject, predicate, object);
            this.rdfModel.add(statement);
        }
        return this.getModel();
    }

    public ResourceMap insertRelationship(ResourceMap resourceMap, String blankSubjectID, Property predicate, List<RDFNode> objects) throws OREException {
        if (blankSubjectID == null || blankSubjectID.isEmpty()) {
            throw new OREException("blankSubjectID cannot be null or empty. Please set the blankSubjectID.");
        }
        AnonId anonId = new AnonId(blankSubjectID);
        Resource blankSubject = ModelFactory.createDefaultModel().createResource(anonId).addProperty(DC_TERMS.identifier, blankSubjectID);
        return this.insertRelationship(resourceMap, blankSubject, predicate, objects);
    }

    private void setModel(ResourceMap resourceMap) throws OREException {
        this.rdfModel = ModelFactory.createDefaultModel();
        ORESerialiser serialiser = ORESerialiserFactory.getInstance((String)DEFAULT_RDF_FORMAT);
        try {
            ResourceMapDocument oreDocument = serialiser.serialise(resourceMap);
            InputStream inputStream = IOUtils.toInputStream((String)oreDocument.toString());
            this.rdfModel.read(inputStream, null);
        }
        catch (ORESerialiserException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new OREException(e.getCause());
        }
    }

    public ResourceMap getModel() throws OREException {
        ResourceMap resourceMap = null;
        OREParser oreParser = OREParserFactory.getInstance((String)DEFAULT_RDF_FORMAT);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.setNamespacePrefixes();
        this.rdfModel.write((OutputStream)outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try {
            resourceMap = oreParser.parse((InputStream)inputStream);
        }
        catch (OREParserException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new OREException(e.getCause());
        }
        return resourceMap;
    }

    private void setNamespacePrefixes() {
        String provPrefix = this.rdfModel.getNsURIPrefix("http://www.w3.org/ns/prov#");
        this.rdfModel.removeNsPrefix(provPrefix);
        this.rdfModel.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        String provonePrefix = this.rdfModel.getNsURIPrefix("https://purl.org/dataone/ontologies/provenance/ProvONE/v1/owl/provone.owl#");
        this.rdfModel.removeNsPrefix(provonePrefix);
        this.rdfModel.setNsPrefix("provone", "https://purl.org/dataone/ontologies/provenance/ProvONE/v1/owl/provone.owl#");
        String citoPrefix = this.rdfModel.getNsURIPrefix("cito");
        this.rdfModel.removeNsPrefix(citoPrefix);
        this.rdfModel.setNsPrefix("cito", "http://purl.org/spar/cito/");
    }

    static {
        log = LogFactory.getLog(ProvResourceMapBuilder.class);
        String baseUrl = Settings.getConfiguration().getString("D1Client.CN_URL");
        D1_URI_PREFIX = StringUtils.isBlank((String)baseUrl) ? "https://fake.test.dataone.org/cn/v1/resolve/" : baseUrl + "/v1/resolve/";
    }
}

