/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.portal;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.util.DateTimeMarshaller;

public class TokenGenerator {
    public static Log log = LogFactory.getLog(TokenGenerator.class);
    private static TokenGenerator instance = null;
    private String consumerKey = null;
    private RSAPublicKey publicKey = null;
    private RSAPrivateKey privateKey = null;

    public static TokenGenerator getInstance() throws IOException {
        if (instance == null) {
            instance = new TokenGenerator();
        }
        return instance;
    }

    private TokenGenerator() throws IOException {
        String privateKeyFileName = Settings.getConfiguration().getString("cn.server.privatekey.filename");
        String privateKeyPassword = null;
        if (privateKeyFileName != null) {
            this.privateKey = (RSAPrivateKey)CertificateManager.getInstance().loadPrivateKeyFromFile(privateKeyFileName, privateKeyPassword);
        }
        this.consumerKey = Settings.getConfiguration().getString("annotator.consumerKey");
        String certificateFileName = Settings.getConfiguration().getString("cn.server.publiccert.filename");
        log.debug((Object)("certificateFileName=" + certificateFileName));
        if (certificateFileName != null) {
            this.publicKey = (RSAPublicKey)CertificateManager.getInstance().loadCertificateFromFile(certificateFileName).getPublicKey();
        } else {
            Certificate cert = this.fetchServerCertificate();
            log.debug((Object)("using certificate from server: " + cert));
            if (cert != null) {
                this.publicKey = (RSAPublicKey)cert.getPublicKey();
            }
        }
    }

    public Certificate fetchServerCertificate() {
        try {
            String baseUrl = D1Client.getCN().getNodeBaseServiceUrl();
            log.debug((Object)("fetching cert from server: " + baseUrl));
            URL url = new URL(baseUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            Certificate serverCertificate = conn.getServerCertificates()[0];
            return serverCertificate;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getJWT(String userId, String fullName) throws JOSEException, ParseException, IOException {
        RSASSASigner signer = new RSASSASigner(this.privateKey);
        Calendar now = Calendar.getInstance();
        JWTClaimsSet claimsSet = new JWTClaimsSet();
        claimsSet.setClaim("consumerKey", (Object)this.consumerKey);
        claimsSet.setClaim("userId", (Object)userId);
        claimsSet.setClaim("fullName", (Object)fullName);
        claimsSet.setClaim("issuedAt", (Object)DateTimeMarshaller.serializeDateToUTC((Date)now.getTime()));
        claimsSet.setClaim("ttl", (Object)64800000);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), (ReadOnlyJWTClaimsSet)claimsSet);
        signedJWT.sign((JWSSigner)signer);
        String token = signedJWT.serialize();
        return token;
    }

    public Session getSession(String token) {
        AuthTokenSession session = null;
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            RSASSAVerifier verifier = new RSASSAVerifier(this.publicKey);
            if (!signedJWT.verify((JWSVerifier)verifier)) {
                return null;
            }
            Calendar now = Calendar.getInstance();
            Date issuedAt = DateTimeMarshaller.deserializeDateToUTC((String)signedJWT.getJWTClaimsSet().getClaim("issuedAt").toString());
            long ttl = Long.valueOf(signedJWT.getJWTClaimsSet().getClaim("ttl").toString());
            Calendar expiration = Calendar.getInstance();
            expiration.setTimeInMillis(issuedAt.getTime() + ttl);
            if (!expiration.after(now)) {
                return null;
            }
            String userId = signedJWT.getJWTClaimsSet().getClaim("userId").toString();
            Subject subject = new Subject();
            subject.setValue(userId);
            session = new AuthTokenSession(token);
            session.setSubject(subject);
            SubjectInfo subjectInfo = null;
            try {
                subjectInfo = D1Client.getCN().getSubjectInfo(subject);
            }
            catch (BaseException be) {
                log.warn((Object)be.getMessage(), (Throwable)be);
            }
            if (subjectInfo == null) {
                subjectInfo = new SubjectInfo();
                Person person = new Person();
                person.setSubject(subject);
                person.setFamilyName("Unknown");
                person.addGivenName("Unknown");
                subjectInfo.setPersonList(Arrays.asList(person));
            }
            session.setSubjectInfo(subjectInfo);
        }
        catch (Exception e) {
            log.warn((Object)("Could not get session from provided token: " + token), (Throwable)e);
            e.printStackTrace();
            return null;
        }
        return session;
    }
}

