/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.impl.SimpleAuthority;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GatewayAuthority
extends SimpleAuthority {
    public static final String ASDL_URI = "asdl-uri";
    public static final String ASDL_FILE = "asdl-file";
    public static final String ASDL_ELEMENT = "asdl-element";
    public static final String ASDL_STRING = "asdl-string";
    private static final int DEFAULT_PORT = -1;
    public static final String NAMESPACE = "http://www.ibm.com/LSID/Standard/ASDL";
    public static final String PREFIX = "asdl";
    public static final String ROOT = "lsid-authority";
    private static final String SERVICE = "service";
    private static final String SERVICES = "services";
    private static final String SERVICE_PTR = "service-ptr";
    private static final String DATA_SERVICES = "data-services";
    private static final String META_DATA_SERVICES = "meta-data-services";
    private static final String NAME_ATTR = "name";
    private static final String PROTOCOL = "protocol";
    private static final String HOSTNAME = "hostname";
    private static final String PATH = "path";
    private static final String TYPE_ATTR = "type";
    private static final String PORT = "port";
    private static final String INSERT_LSID_ATTR = "insert-lsid";
    private static final String SOAP_ENDPOINT = "soap-endpoint";
    private static final String LSID_ELT = "lsid";
    private static final String LSIDS = "lsids";
    private static final String URN_ATTR = "urn";
    private static final String SOAP = "soap";
    private static final String HTTP = "http";
    private static final String FTP = "ftp";
    private static final String LOCALHOST = "localhost";
    private static final String MASK = "*";
    private Element envNS;
    private String gatewayName = null;
    private LSID[] lsids;
    private Hashtable lsidEntries = new Hashtable();
    private Hashtable serviceEntries = new Hashtable();

    public static void main(String[] args) throws Exception {
        GatewayAuthority ga = new GatewayAuthority();
        ga.load(new File("c:/wsad5/workspace/NCBIAuthority/com/ibm/lsid/server/impl/ncbi/mdasdl.xml"));
        LSIDRequestContext ctx = new LSIDRequestContext();
        ctx.setLsid(new LSID("urn:lsid:ncbi.nlm.nih.gov.lsid.i3c.org:types:mrna"));
        ctx.setReqUrl("http://3.56.78.9:1000/foo/bar");
        String str = ga.getAvailableServices(ctx).getValue().toString();
        System.out.println(str);
    }

    public void load(URL uri) throws LSIDServerException {
        try {
            this.load(uri.openStream());
        }
        catch (IOException e) {
            throw new LSIDServerException(e, "Error getting Gateway Authority ASDL at: " + uri);
        }
    }

    public void load(File file) throws LSIDServerException {
        try {
            this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new LSIDServerException(e, "Gateway Authority ASDL file not found: " + file);
        }
    }

    public void load(String xml) throws LSIDServerException {
        this.load(new ByteArrayInputStream(xml.getBytes()));
    }

    /*
     * Loose catch block
     */
    public void load(InputStream xml) throws LSIDServerException {
        block11: {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(xml));
            Node root = parser.getDocument().getFirstChild();
            while (!(root instanceof Element)) {
                root = root.getNextSibling();
            }
            this.load((Element)root);
            Object var6_5 = null;
            try {
                if (xml != null) {
                    xml.close();
                }
                break block11;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block11;
            {
                catch (IOException e) {
                    throw new LSIDServerException(e, "Error parsing Gateway Authority ASDL");
                }
                catch (SAXException e) {
                    throw new LSIDServerException(e, "Error parsing Gateway Authority ASDL");
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (xml != null) {
                        xml.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void load(Element ASDL) throws LSIDServerException {
        Element elt;
        int i;
        this.envNS = ASDL.getOwnerDocument().createElement("nsmappings");
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:asdl", NAMESPACE);
        this.gatewayName = ASDL.getAttribute(NAME_ATTR);
        String xpathStr = "asdl:services/asdl:service";
        try {
            NodeList services = XPathAPI.selectNodeList((Node)ASDL, (String)xpathStr, (Node)this.envNS);
            if (services != null) {
                i = 0;
                while (i < services.getLength()) {
                    elt = (Element)services.item(i);
                    ServiceEntry service = new ServiceEntry(elt);
                    this.serviceEntries.put(service.name, service);
                    ++i;
                }
            }
        }
        catch (TransformerException e) {
            throw new LSIDServerException(e, "Error loading services from Gateway Authority ASDL");
        }
        xpathStr = "asdl:lsids/asdl:lsid";
        try {
            NodeList lsids = XPathAPI.selectNodeList((Node)ASDL, (String)xpathStr, (Node)this.envNS);
            if (lsids != null) {
                this.lsids = new LSID[lsids.getLength()];
                i = 0;
                while (i < lsids.getLength()) {
                    elt = (Element)lsids.item(i);
                    LSIDEntry lsid = new LSIDEntry(elt);
                    this.lsids[i] = lsid.lsid;
                    this.lsidEntries.put(lsid.lsid.toString(), lsid);
                    ++i;
                }
            }
        }
        catch (TransformerException e) {
            throw new LSIDServerException(e, "Error loading meta data services from Gateway Authority ASDL");
        }
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
        String asdlUri = config.getProperty(ASDL_URI);
        String asdlFile = config.getProperty(ASDL_FILE);
        String asdlElement = config.getProperty(ASDL_ELEMENT);
        String asdlString = config.getProperty(ASDL_STRING);
        if (asdlUri != null) {
            try {
                this.load(new URL(asdlUri));
            }
            catch (MalformedURLException e) {
                throw new LSIDServerException(e, "Bad location for XML authority ASDL: " + asdlUri);
            }
        } else if (asdlFile != null) {
            this.load(new File(asdlFile));
        } else if (asdlElement != null) {
            this.load(asdlElement);
        } else if (asdlString != null) {
            this.load(asdlString);
        }
    }

    protected LSIDMetadataPort[] getMetadataLocations(LSID lsid, String url) {
        String maskedUrn;
        LSIDEntry entry = (LSIDEntry)this.lsidEntries.get(lsid.toString());
        if (entry == null && (entry = (LSIDEntry)this.lsidEntries.get(maskedUrn = "urn:lsid:" + lsid.getAuthority().toString() + ":" + lsid.getNamespace() + ":" + MASK)) == null) {
            return new LSIDMetadataPort[0];
        }
        ServiceEntry[] entries = entry.metaDataServices;
        LSIDMetadataPort[] retEntries = new ServiceEntry[entries.length];
        if (entries == null) {
            return new LSIDMetadataPort[0];
        }
        try {
            URL r = new URL(url);
            int i = 0;
            while (i < entries.length) {
                retEntries[i] = entries[i].lsid.getObject().equals(MASK) ? new ServiceEntry(entries[i], lsid) : entries[i];
                if (retEntries[i].getProtocol().equals(SOAP)) {
                    if (retEntries[i].getLocation().indexOf(LOCALHOST) != -1) {
                        URL u = new URL(retEntries[i].getLocation());
                        URL l = new URL(HTTP, r.getHost(), r.getPort(), u.getPath());
                        String loc = retEntries[i].path.location;
                        retEntries[i].path = new LSIDPath(l.toString());
                        retEntries[i].path.location = loc;
                    }
                } else if (retEntries[i].getProtocol().equals(HTTP) && retEntries[i].hostname.equals(LOCALHOST)) {
                    retEntries[i].hostname = r.getHost();
                    retEntries[i].port = r.getPort();
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return new LSIDMetadataPort[0];
        }
        return retEntries;
    }

    protected LSIDDataPort[] getDataLocations(LSID lsid, String url) {
        LSIDEntry entry = (LSIDEntry)this.lsidEntries.get(lsid.toString());
        if (entry == null) {
            return new LSIDDataPort[0];
        }
        LSIDDataPort[] entries = entry.dataServices;
        ServiceEntry[] retEntries = new ServiceEntry[entries.length];
        if (entries == null) {
            return new LSIDDataPort[0];
        }
        try {
            URL r = new URL(url);
            int i = 0;
            while (i < entries.length) {
                retEntries[i] = entries[i].lsid.getObject().equals(MASK) ? new ServiceEntry((ServiceEntry)entries[i], lsid) : entries[i];
                if (retEntries[i].getProtocol().equals(SOAP)) {
                    if (retEntries[i].getLocation().indexOf(LOCALHOST) != -1) {
                        URL u = new URL(retEntries[i].getLocation());
                        URL l = new URL(HTTP, r.getHost(), r.getPort(), u.getPath());
                        String loc = retEntries[i].path.location;
                        retEntries[i].path = new LSIDPath(l.toString());
                        retEntries[i].path.location = loc;
                    }
                } else if (retEntries[i].getProtocol().equals(HTTP) && retEntries[i].hostname.equals(LOCALHOST)) {
                    retEntries[i].hostname = r.getHost();
                    retEntries[i].port = r.getPort();
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return new LSIDDataPort[0];
        }
        return entries;
    }

    public void notifyForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        throw new LSIDServerException(501, "Not Implemented in Gateway");
    }

    public void revokeNotificationForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        throw new LSIDServerException(501, "Not Implemented in Gateway");
    }

    private class LSIDPath {
        static final String IN_QUERY = "query";
        static final String IN_PATH = "path";
        String path;
        String location;
        String type = "urlEncoded";

        LSIDPath(Element elt) throws TransformerException {
            String location = elt.getAttribute(GatewayAuthority.INSERT_LSID_ATTR);
            String t = elt.getAttribute(GatewayAuthority.TYPE_ATTR);
            if (t != null && !t.equals("")) {
                this.type = t;
            }
            this.location = location;
            this.path = XPathAPI.selectSingleNode((Node)elt, (String)"text()").getNodeValue();
        }

        LSIDPath(String path) {
            this.path = path;
        }

        String getPath(LSID lsid) {
            if (this.location != null) {
                if (this.location.equals(IN_QUERY)) {
                    if (this.path.indexOf(63) != -1) {
                        return this.path + "&lsid=" + lsid.toString();
                    }
                    return this.path + "?lsid=" + lsid.toString();
                }
                if (this.location.equals("path")) {
                    if (this.path.endsWith("/")) {
                        return this.path + lsid.toString();
                    }
                    return this.path + "/" + lsid.toString();
                }
                return this.path;
            }
            return this.path;
        }
    }

    private class ServiceEntry
    implements LSIDDataPort,
    LSIDMetadataPort {
        LSID lsid;
        String name;
        String protocol;
        String hostname;
        LSIDPath path;
        int port = -1;
        private LSIDCredentials lsidCredentials = null;
        private Map headers = new HashMap();

        public void addProtocolHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Map getProtocolHeaders() {
            return this.headers;
        }

        public LSIDCredentials getLsidCredentials() {
            return this.lsidCredentials;
        }

        public void setLsidCredentials(LSIDCredentials lsidCredentials) {
            this.lsidCredentials = lsidCredentials;
        }

        ServiceEntry(ServiceEntry entry, LSID lsid) {
            this.hostname = entry.hostname;
            this.path = entry.path;
            this.protocol = entry.protocol;
            this.port = entry.port;
            this.lsid = lsid;
            this.name = entry.name;
        }

        ServiceEntry(Element elt) throws TransformerException {
            this.name = elt.getAttribute(GatewayAuthority.NAME_ATTR);
            Element soapNode = (Element)XPathAPI.selectSingleNode((Node)elt, (String)"asdl:soap-endpoint", (Node)GatewayAuthority.this.envNS);
            if (soapNode != null) {
                this.path = new LSIDPath(soapNode);
                this.protocol = GatewayAuthority.SOAP;
            } else {
                Node portNode;
                Element pathNode;
                Node hostnameNode;
                Node protocolNode = XPathAPI.selectSingleNode((Node)elt, (String)"asdl:protocol/text()", (Node)GatewayAuthority.this.envNS);
                if (protocolNode != null) {
                    this.protocol = protocolNode.getNodeValue();
                }
                if ((hostnameNode = XPathAPI.selectSingleNode((Node)elt, (String)"asdl:hostname/text()", (Node)GatewayAuthority.this.envNS)) != null) {
                    this.hostname = hostnameNode.getNodeValue();
                }
                if ((pathNode = (Element)XPathAPI.selectSingleNode((Node)elt, (String)"asdl:path", (Node)GatewayAuthority.this.envNS)) != null) {
                    LSIDPath path;
                    this.path = path = new LSIDPath(pathNode);
                }
                if ((portNode = XPathAPI.selectSingleNode((Node)elt, (String)"asdl:port/text()", (Node)GatewayAuthority.this.envNS)) != null) {
                    this.port = Integer.parseInt(portNode.getNodeValue());
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getServiceName() {
            return GatewayAuthority.this.gatewayName;
        }

        public String getLocation() {
            if (this.protocol.equals(GatewayAuthority.HTTP)) {
                if (this.port < 0) {
                    return "http://" + this.hostname + "/" + this.path.getPath(this.lsid);
                }
                return "http://" + this.hostname + ":" + this.port + this.path.getPath(this.lsid);
            }
            if (this.protocol.equals(GatewayAuthority.FTP)) {
                return this.hostname;
            }
            if (this.protocol.equals(GatewayAuthority.SOAP)) {
                return this.path.getPath(this.lsid);
            }
            return null;
        }

        public String getPath() {
            if (this.protocol.equals(GatewayAuthority.FTP)) {
                return this.path.getPath(this.lsid);
            }
            if (this.protocol.equals(GatewayAuthority.HTTP)) {
                return this.path.type;
            }
            return null;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }

    private class LSIDEntry {
        LSID lsid;
        ServiceEntry[] dataServices;
        ServiceEntry[] metaDataServices;

        LSIDEntry(Element elt) throws TransformerException, LSIDServerException {
            String urn = elt.getAttribute(GatewayAuthority.URN_ATTR);
            try {
                this.lsid = new LSID(urn);
            }
            catch (MalformedLSIDException e) {
                throw new LSIDServerException((Exception)((Object)e), "Bad LSID in Gateway Authority ASDL.");
            }
            this.dataServices = this.loadServices(elt, GatewayAuthority.DATA_SERVICES);
            this.metaDataServices = this.loadServices(elt, GatewayAuthority.META_DATA_SERVICES);
        }

        private ServiceEntry[] loadServices(Element elt, String tagName) throws LSIDServerException {
            try {
                int i;
                String xpathServices = "asdl:" + tagName + "/" + GatewayAuthority.PREFIX + ":" + GatewayAuthority.SERVICE;
                String xpathPtrs = "asdl:" + tagName + "/" + GatewayAuthority.PREFIX + ":" + GatewayAuthority.SERVICE_PTR;
                int totalNodes = 0;
                int numServiceNodes = 0;
                NodeList serviceNodes = XPathAPI.selectNodeList((Node)elt, (String)xpathServices, (Node)GatewayAuthority.this.envNS);
                NodeList ptrNodes = XPathAPI.selectNodeList((Node)elt, (String)xpathPtrs, (Node)GatewayAuthority.this.envNS);
                if (serviceNodes != null) {
                    numServiceNodes = serviceNodes.getLength();
                    totalNodes += numServiceNodes;
                }
                if (ptrNodes != null) {
                    totalNodes += ptrNodes.getLength();
                }
                ServiceEntry[] services = new ServiceEntry[totalNodes];
                if (serviceNodes != null) {
                    i = 0;
                    while (i < serviceNodes.getLength()) {
                        Element serviceelt = (Element)serviceNodes.item(i);
                        services[i] = new ServiceEntry(serviceelt);
                        services[i].lsid = this.lsid;
                        ++i;
                    }
                }
                if (ptrNodes != null) {
                    i = 0;
                    while (i < ptrNodes.getLength()) {
                        Element ptrelt = (Element)ptrNodes.item(i);
                        String ptr = ptrelt.getAttribute(GatewayAuthority.NAME_ATTR);
                        if (ptr == null) {
                            throw new LSIDServerException("'service-ptr' element must have 'name' attribute");
                        }
                        ServiceEntry target = (ServiceEntry)GatewayAuthority.this.serviceEntries.get(ptr);
                        if (target == null) {
                            throw new LSIDServerException("Bad data service name link in ASDL: " + ptr);
                        }
                        services[numServiceNodes + i] = new ServiceEntry(target, this.lsid);
                        ++i;
                    }
                }
                return services;
            }
            catch (TransformerException e) {
                throw new LSIDServerException(e, "Error loading " + tagName + " from Gateway Authority ASDL");
            }
        }
    }
}

