/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.store.ActiveTypeEntry;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDiffState
implements Transaction.State {
    Transaction transaction;
    Diff diffMap = new Diff();
    private ActiveTypeEntry entry;

    public TypeDiffState(ActiveTypeEntry typeEntry) {
        this.entry = typeEntry;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.diffMap != null) {
                this.diffMap.clear();
            }
            this.entry = null;
        }
    }

    public Diff diff() throws IOException {
        return this.diffMap;
    }

    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    public synchronized void commit() throws IOException {
        this.applyDiff(this.diffMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void applyDiff(Diff diff) throws IOException {
        if (diff.isEmpty()) {
            return;
        }
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.entry.createWriter();
        try {
            String fid;
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                fid = feature.getID();
                if (!diff.modified2.containsKey(fid)) continue;
                SimpleFeature update = (SimpleFeature)diff.modified2.get(fid);
                if (update == TransactionStateDiff.NULL) {
                    writer.remove();
                    this.entry.listenerManager.fireFeaturesChanged(this.entry.getTypeName(), this.transaction, ReferencedEnvelope.reference((BoundingBox)feature.getBounds()), true);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes());
                    writer.write();
                    ReferencedEnvelope bounds = new ReferencedEnvelope();
                    bounds.include(feature.getBounds());
                    bounds.include(update.getBounds());
                    this.entry.listenerManager.fireFeaturesChanged(this.entry.getTypeName(), this.transaction, bounds, true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)e);
                }
            }
            for (SimpleFeature addedFeature : diff.added.values()) {
                fid = addedFeature.getID();
                SimpleFeature nextFeature = (SimpleFeature)writer.next();
                if (nextFeature == null) {
                    throw new DataSourceException("Could not add " + fid);
                }
                try {
                    nextFeature.setAttributes(addedFeature.getAttributes());
                    writer.write();
                    this.entry.listenerManager.fireFeaturesAdded(this.entry.getTypeName(), this.transaction, ReferencedEnvelope.reference((BoundingBox)nextFeature.getBounds()), true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)e);
                    return;
                }
            }
        }
        finally {
            writer.close();
            diff.clear();
            this.entry.listenerManager.fireChanged(this.entry.getTypeName(), this.transaction, true);
        }
    }

    public synchronized void rollback() throws IOException {
        this.diffMap.clear();
        this.entry.listenerManager.fireChanged(this.entry.getTypeName(), this.transaction, false);
    }

    public synchronized FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(this.entry.reader(Query.ALL, this.transaction), this.diffMap);
    }

    public synchronized FeatureWriter<SimpleFeatureType, SimpleFeature> writer() throws IOException {
        Diff diff = new Diff();
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.entry.createReader();
        return new DiffFeatureWriter(reader, diff){

            protected void fireNotification(int eventType, ReferencedEnvelope bounds) {
                switch (eventType) {
                    case 1: {
                        ((TypeDiffState)TypeDiffState.this).entry.listenerManager.fireFeaturesAdded(TypeDiffState.this.entry.getTypeName(), TypeDiffState.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        ((TypeDiffState)TypeDiffState.this).entry.listenerManager.fireFeaturesChanged(TypeDiffState.this.entry.getTypeName(), TypeDiffState.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        ((TypeDiffState)TypeDiffState.this).entry.listenerManager.fireFeaturesRemoved(TypeDiffState.this.entry.getTypeName(), TypeDiffState.this.transaction, bounds, false);
                    }
                }
            }
        };
    }
}

