/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import java.io.InputStream;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.stream.Locator;
import org.apache.jena.riot.stream.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorClassLoader
implements Locator {
    static Logger log = LoggerFactory.getLogger(LocatorClassLoader.class);
    private final ClassLoader classLoader;

    public LocatorClassLoader(ClassLoader _classLoader) {
        this.classLoader = _classLoader;
    }

    public boolean equals(Object other) {
        return other instanceof LocatorClassLoader && this.classLoader == ((LocatorClassLoader)other).classLoader;
    }

    public int hashCode() {
        return this.classLoader.hashCode();
    }

    @Override
    public TypedInputStream open(String resourceName) {
        if (this.classLoader == null) {
            return null;
        }
        InputStream in = this.classLoader.getResourceAsStream(resourceName);
        if (in == null) {
            if (StreamManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Failed to open: " + resourceName);
            }
            return null;
        }
        if (StreamManager.logAllLookups && log.isTraceEnabled()) {
            log.trace("Found: " + resourceName);
        }
        ContentType ct = RDFLanguages.guessContentType(resourceName);
        return new TypedInputStream(in, ct, null);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getName() {
        return "ClassLoaderLocator";
    }
}

