/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.eml;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ecoinformatics.eml.EMLParser;
import org.ecoinformatics.eml.SAXValidate;
import org.xml.sax.SAXException;

public class EMLParserServlet
extends HttpServlet {
    private ServletConfig servletconfig = null;
    private ServletContext context = null;
    private HttpServletRequest request;
    private static HttpServletResponse response;
    private static PrintWriter out;
    private Hashtable params = new Hashtable();
    private static final String namespaces = "eml://ecoinformatics.org/eml-2.0.0 http://knb.ecoinformatics.org/emlparser/schema/eml-2.0.0/eml.xsd       eml://ecoinformatics.org/eml-2.0.1  http://knb.ecoinformatics.org/emlparser/schema/eml-2.0.1/eml.xsd       eml://ecoinformatics.org/eml-2.1.0 eml.xsd       eml://ecoinformatics.org/literature-2.1.0 eml-literature.xsd       eml://ecoinformatics.org/project-2.1.0 eml-project.xsd       http://www.xml-cml.org/schema/stmml-1.1 stmml.xsd       http://www.xml-cml.org/schema/stmml stmml.xsd";
    private static final String NAMESPACEKEYWORD = "xmlns";
    public static final String EML2_1_0NAMESPACE = "eml://ecoinformatics.org/eml-2.1.0";
    public static final String EML2_0_1NAMESPACE = "eml://ecoinformatics.org/eml-2.0.1";
    public static final String EML2_0_0NAMESPACE = "eml://ecoinformatics.org/eml-2.0.0";

    public void init(ServletConfig servletconfig) throws ServletException {
        super.init(servletconfig);
        this.servletconfig = servletconfig;
        this.context = servletconfig.getServletContext();
        System.out.println("Starting EMLParserServlet");
    }

    public void destroy() {
        System.out.println("Destroying EMLParserServlet");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action;
        this.request = request;
        EMLParserServlet.response = response;
        StringBuffer html = new StringBuffer();
        out = response.getWriter();
        String ctype = request.getContentType();
        InputStream fileToParse = null;
        File tempfile = null;
        html.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD html 4.0//EN\">");
        html.append("<html>");
        html.append("<head>");
        html.append("<title>EML ID and References Parser</title>");
        html.append("<link rel=\"stylesheet\" type=\"text/css\" ");
        html.append("href=\"http://knb.ecoinformatics.org/default.css\">");
        html.append("</head>");
        html.append("<body>");
        html.append("<table class=\"tabledefault\" width=\"100%\">");
        html.append("<tbody>");
        html.append("<tr>");
        html.append("<td rowspan=\"2\">");
        html.append("<img src=\"http://knb.ecoinformatics.org/images/KNBLogo.gif\">");
        html.append("</td>");
        html.append("<td colspan=\"7\"><div class=\"title\">");
        html.append("EML ID and References Parser</div></td>");
        html.append("</tr>");
        html.append("<tr>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/\" ");
        html.append("class=\"toollink\"> KNB Home </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/data.html\" ");
        html.append("class=\"toollink\"> Data </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/people.html\" ");
        html.append("class=\"toollink\"> People </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/informatics\" ");
        html.append("class=\"toollink\"> Informatics </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/biodiversity\" ");
        html.append("class=\"toollink\"> Biocomplexity </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/education\" ");
        html.append("class=\"toollink\"> Education </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/software\" ");
        html.append("class=\"toollink\"> Software </a></td>");
        html.append("</tr>");
        html.append("</tbody>");
        html.append("</table>");
        html.append("<hr>");
        HttpSession sess = request.getSession(true);
        String sess_id = "";
        try {
            sess_id = sess.getId();
        }
        catch (IllegalStateException ise) {
            System.out.println("error in handleGetOrPost: this shouldn't happen: the session should be valid: " + ise.getMessage());
        }
        File tempdir = new File("/tmp/emlparser");
        if (!tempdir.exists()) {
            tempdir.mkdirs();
        }
        tempfile = new File("/tmp/emlparser/.tmpfile." + sess_id);
        if (ctype != null && ctype.startsWith("multipart/form-data")) {
            try {
                fileToParse = this.handleGetFile(request, response);
                int c = fileToParse.read();
                FileOutputStream fos = new FileOutputStream(tempfile);
                while (c != -1) {
                    fos.write(c);
                    c = fileToParse.read();
                }
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                out.println("<html><body><h1>Error handling multipart data: " + e.getMessage() + "</h1></body></html>");
                System.out.println("Error handling multipart data: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            Enumeration paramlist = request.getParameterNames();
            while (paramlist.hasMoreElements()) {
                String name = (String)paramlist.nextElement();
                String[] value = request.getParameterValues(name);
                this.params.put(name, value);
            }
        }
        if ((action = ((String[])this.params.get("action"))[0]).equals("parse")) {
            html.append(this.parse(tempfile));
        } else if (action.equals("textparse")) {
            String doctext = ((String[])this.params.get("doctext"))[0];
            if (doctext == null || doctext.trim().equals("")) {
                html.append("<h2>Error.  Submitted document is null.</h2>");
            } else {
                StringReader sr = new StringReader(doctext);
                FileWriter fw = new FileWriter(tempfile);
                int c = sr.read();
                while (c != -1) {
                    fw.write(c);
                    c = sr.read();
                }
                fw.flush();
                fw.close();
                html.append(this.parse(tempfile));
            }
        } else {
            html.append("<h2>Error.  Action '").append(action);
            html.append("' not registered</h2>");
        }
        tempfile.delete();
        html.append("<hr><a href=\"/emlparser\">Back</a> to the previous page.");
        html.append("</body></html>");
        response.setContentType("text/html");
        out.println(html.toString());
        out.flush();
    }

    private String parse(File tempfile) {
        StringBuffer html = new StringBuffer();
        try {
            if (tempfile != null) {
                EMLParser parser = new EMLParser(tempfile, new File("/var/www/org.ecoinformatics.knb/emlparser/lib/config.xml"));
                html.append("<h2>EML specific tests: Passed.</h2><p>The tests which ");
                html.append("are specific to EML, including validation that IDs are ");
                html.append("present and properly referenced, have passed.</p>");
            } else {
                html.append("<h2>Error: The file sent to the parser was null.</h2>");
            }
        }
        catch (Exception e) {
            html.append("<h2>EML specific tests: Failed.</h2><p>The following errors were found:");
            html.append("</p><p>").append(e.getMessage()).append("</p>");
        }
        try {
            FileReader xmlReader = new FileReader(tempfile);
            String namespaceInDoc = EMLParserServlet.findNamespace(xmlReader);
            ((Reader)xmlReader).close();
            System.out.println("The namespace in xml is " + namespaceInDoc);
            SAXValidate validator = new SAXValidate(true);
            validator.runTest(new FileReader(tempfile), "DEFAULT", namespaces, namespaceInDoc);
            html.append("<hr><h2>XML specific tests: Passed.</h2>");
            html.append("<p>Document is XML-schema valid. There were no XML errors found in your document.</p>");
        }
        catch (IOException ioe) {
            html.append("<hr><h2>IOException: Error reading file</h2>");
            html.append("<p>").append(ioe.getMessage()).append("</p>");
        }
        catch (ClassNotFoundException cnfe) {
            html.append("<hr><h2>Parser class not found</h2>");
            html.append("<p>").append(cnfe.getMessage()).append("</p>");
        }
        catch (SAXException se) {
            if (se.getMessage().indexOf("WARNING") != -1) {
                html.append("<hr><h2>XML-Schema Warning</h2><p>The following warnings ");
                html.append("were issued about your document: </p><p>");
                html.append(se.getMessage()).append("</p>");
            }
            html.append("<hr><h2>XML specific tests: Failed</h2><p>");
            html.append("The following errors were ");
            html.append("found:</p><p>").append(se.getMessage()).append("</p>");
        }
        return html.toString();
    }

    private InputStream handleGetFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Part part;
        Hashtable<String, FilePart> fileList = new Hashtable<String, FilePart>();
        MultipartParser mp = new MultipartParser(request, 0x800000);
        while ((part = mp.readNextPart()) != null) {
            String name = part.getName();
            if (part.isParam()) {
                ParamPart paramPart = (ParamPart)part;
                String value = paramPart.getStringValue();
                String[] s = new String[]{value};
                this.params.put(name, s);
                continue;
            }
            if (!part.isFile()) continue;
            FilePart filePart = (FilePart)part;
            fileList.put(name, filePart);
            break;
        }
        FilePart fp = (FilePart)fileList.get("filename");
        return fp.getInputStream();
    }

    public static String findNamespace(Reader xml) throws IOException {
        String namespace = null;
        String eml2_0_0NameSpace = EML2_0_0NAMESPACE;
        String eml2_0_1NameSpace = EML2_0_1NAMESPACE;
        String eml2_1_0NameSpace = EML2_1_0NAMESPACE;
        if (xml == null) {
            return namespace;
        }
        String targetLine = EMLParserServlet.getSchemaLine(xml);
        if (targetLine != null) {
            String prefix = EMLParserServlet.getPrefix(targetLine);
            int startIndex = 0;
            if (prefix != null) {
                String namespaceWithPrefix = "xmlns:" + prefix;
                startIndex = targetLine.indexOf(namespaceWithPrefix);
            } else {
                startIndex = targetLine.indexOf(NAMESPACEKEYWORD);
            }
            int start = 1;
            int end = 1;
            String namespaceString = null;
            int count = 0;
            if (startIndex != -1) {
                for (int i = startIndex; i < targetLine.length(); ++i) {
                    if (targetLine.charAt(i) == '\"') {
                        ++count;
                    }
                    if (targetLine.charAt(i) == '\"' && count == 1) {
                        start = i;
                    }
                    if (targetLine.charAt(i) != '\"' || count != 2) continue;
                    end = i;
                    break;
                }
            }
            if (start < end) {
                namespaceString = targetLine.substring(start + 1, end);
            }
            if (namespaceString != null) {
                namespace = namespaceString.indexOf(eml2_0_0NameSpace) != -1 ? eml2_0_0NameSpace : (namespaceString.indexOf(eml2_0_1NameSpace) != -1 ? eml2_0_1NameSpace : (namespaceString.indexOf(eml2_1_0NameSpace) != -1 ? eml2_1_0NameSpace : namespaceString));
            }
        }
        return namespace;
    }

    private static String getSchemaLine(Reader xml) throws IOException {
        String secondLine = null;
        int count = 0;
        boolean endIndex = false;
        boolean startIndex = false;
        boolean TARGETNUM = true;
        StringBuffer buffer = new StringBuffer();
        boolean comment = false;
        boolean processingInstruction = false;
        int thirdPreviousCharacter = 63;
        int secondPreviousCharacter = 63;
        int previousCharacter = 63;
        int currentCharacter = 63;
        int tmp = xml.read();
        while (tmp != -1) {
            currentCharacter = (char)tmp;
            if (currentCharacter == 45 && previousCharacter == 45 && secondPreviousCharacter == 33 && thirdPreviousCharacter == 60) {
                comment = true;
            }
            if (comment && currentCharacter == 62 && previousCharacter == 45 && secondPreviousCharacter == 45) {
                comment = false;
            }
            if (currentCharacter == 63 && previousCharacter == 60) {
                processingInstruction = true;
            }
            if (processingInstruction && currentCharacter == 62 && previousCharacter == 63) {
                processingInstruction = false;
            }
            if (currentCharacter != 33 && previousCharacter == 60 && !comment && !processingInstruction) {
                ++count;
            }
            if (count == 1 && currentCharacter != 62) {
                buffer.append((char)currentCharacter);
            }
            if (count == 1 && currentCharacter == 62) break;
            thirdPreviousCharacter = secondPreviousCharacter;
            secondPreviousCharacter = previousCharacter;
            previousCharacter = currentCharacter;
            tmp = xml.read();
        }
        secondLine = buffer.toString();
        return secondLine;
    }

    private static String getPrefix(String schemaLine) {
        String prefix = null;
        if (schemaLine.indexOf(" ") > 0) {
            String rootElement = "";
            try {
                rootElement = schemaLine.substring(0, schemaLine.indexOf(" "));
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                rootElement = schemaLine;
            }
            if (rootElement.indexOf(":") > 0) {
                prefix = rootElement.substring(0, rootElement.indexOf(":"));
            }
            if (prefix != null) {
                return prefix.trim();
            }
        }
        return null;
    }

    static {
        out = null;
    }
}

