/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBSAXNode;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.RelationHandler;
import edu.ucsb.nceas.metacat.SchemaLocationResolver;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.XMLSchema;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import edu.ucsb.nceas.utilities.triple.Triple;
import edu.ucsb.nceas.utilities.triple.TripleCollection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DBSAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    protected boolean atFirstElement;
    protected boolean processingDTD;
    protected String docname = null;
    protected String doctype;
    protected String catalogid = null;
    protected String systemid;
    private boolean stackCreated = false;
    protected Stack<DBSAXNode> nodeStack;
    protected Vector<DBSAXNode> nodeIndex;
    protected DBConnection connection = null;
    protected DocumentImpl currentDocument;
    protected Date createDate = null;
    protected Date updateDate = null;
    protected DBSAXNode rootNode;
    protected String action = null;
    protected String docid = null;
    protected String revision = null;
    protected String user = null;
    protected String[] groups = null;
    protected String pub = null;
    protected String encoding = null;
    protected int serverCode = 1;
    protected Hashtable<String, String> namespaces = new Hashtable();
    protected boolean hitTextNode = false;
    protected StringBuffer textBuffer = new StringBuffer();
    public static final int MAXDATACHARS = 4000;
    protected long endNodeId = -1L;
    private boolean isRevisionDoc = false;
    protected Vector<XMLSchema> schemaList = new Vector();
    TripleCollection tripleList = new TripleCollection();
    Triple currentTriple = new Triple();
    boolean startParseTriple = false;
    boolean hasTriple = false;
    protected boolean writeAccessRules = true;
    protected boolean ignoreDenyFirst = true;
    public static final String ECOGRID = "ecogrid://";
    private Logger logMetacat = Logger.getLogger(DBSAXHandler.class);

    private DBSAXHandler(DBConnection conn, Date createDate, Date updateDate) {
        this.connection = conn;
        this.atFirstElement = true;
        this.processingDTD = false;
        this.createDate = createDate;
        this.updateDate = updateDate;
        if (!this.stackCreated) {
            this.nodeStack = new Stack();
            this.nodeIndex = new Vector();
            this.stackCreated = true;
        }
    }

    public DBSAXHandler(DBConnection conn, String action, String docid, String revision, String user, String[] groups, String pub, int serverCode, Date createDate, Date updateDate, boolean writeAccessRules) {
        this(conn, createDate, updateDate);
        this.action = action;
        this.docid = docid;
        this.revision = revision;
        this.user = user;
        this.groups = groups;
        this.pub = pub;
        this.serverCode = serverCode;
        this.writeAccessRules = writeAccessRules;
    }

    @Override
    public void startDocument() throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.startDocument - starting document");
        this.rootNode = new DBSAXNode(this.connection, this.docid);
        this.nodeStack.push(this.rootNode);
    }

    @Override
    public void endDocument() throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.endDocument - ending document");
        try {
            if (this.doctype != null && MetacatUtil.getOptionList(PropertyService.getProperty("xml.packagedoctype")).contains(this.doctype) && this.hasTriple && !this.isRevisionDoc && !this.isRevisionDoc) {
                RelationHandler relationHandler = new RelationHandler(this.docid, this.doctype, this.connection, this.tripleList);
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("DBSaxHandler.endDocument - Failed to write triples into relation table" + e.getMessage()));
            throw new SAXException("Failed to write triples into relation table " + e.getMessage());
        }
        for (XMLSchema xmlSchema : this.schemaList) {
            String externalFileUri = xmlSchema.getExternalFileUri();
            String fileNamespace = xmlSchema.getFileNamespace();
            SchemaLocationResolver resolver = new SchemaLocationResolver(fileNamespace, externalFileUri);
            resolver.resolveNameSpace();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.startPrefixMapping - Starting namespace");
        this.namespaces.put(prefix, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.startElement - Start ELEMENT(qName) " + qName));
        this.logMetacat.debug((Object)("DBSaxHandler.startElement - Start ELEMENT(localName) " + localName));
        this.logMetacat.debug((Object)("DBSaxHandler.startElement - Start ELEMENT(uri) " + uri));
        DBSAXNode parentNode = null;
        DBSAXNode currentNode = null;
        try {
            parentNode = this.nodeStack.peek();
        }
        catch (EmptyStackException e) {
            parentNode = null;
        }
        if (this.hitTextNode && parentNode != null) {
            this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, parentNode);
            this.hitTextNode = false;
            this.textBuffer = null;
            this.textBuffer = new StringBuffer();
        }
        if (this.atFirstElement) {
            this.atFirstElement = false;
            if (this.docname == null) {
                this.docname = localName;
                this.doctype = uri != null && !uri.trim().equals("") ? uri : this.docname;
                this.logMetacat.debug((Object)("DBSaxHandler.startElement - DOCNAME-a: " + this.docname));
                this.logMetacat.debug((Object)("DBSaxHandler.startElement - DOCTYPE-a: " + this.doctype));
            } else if (this.doctype == null) {
                this.doctype = this.docname;
                this.logMetacat.debug((Object)("DBSaxHandler.startElement - DOCTYPE-b: " + this.doctype));
            }
            this.rootNode.writeNodename(this.docname);
            try {
                DBConnection dbConn = null;
                int serialNumber = -1;
                if (this.systemid != null) {
                    try {
                        dbConn = DBConnectionPool.getDBConnection("DBSAXHandler.startElement");
                        serialNumber = dbConn.getCheckOutSerialNumber();
                        String sql = "SELECT catalog_id FROM xml_catalog WHERE entry_type = 'DTD' AND public_id = ?";
                        PreparedStatement pstmt = dbConn.prepareStatement(sql);
                        pstmt.setString(1, this.doctype);
                        ResultSet rs = pstmt.executeQuery();
                        boolean hasRow = rs.next();
                        if (hasRow) {
                            this.catalogid = rs.getString(1);
                        }
                        pstmt.close();
                    }
                    finally {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                }
                if (!this.isRevisionDoc) {
                    this.currentDocument = new DocumentImpl(this.connection, this.rootNode.getNodeID(), this.docname, this.doctype, this.docid, this.revision, this.action, this.user, this.pub, this.catalogid, this.serverCode, this.createDate, this.updateDate);
                }
            }
            catch (Exception ane) {
                ane.printStackTrace(System.out);
                ane.printStackTrace(System.err);
                throw new SAXException("Error in DBSaxHandler.startElement for action " + this.action + " : " + ane.getMessage(), ane);
            }
        }
        currentNode = new DBSAXNode(this.connection, qName, localName, parentNode, this.rootNode.getNodeID(), this.docid, this.doctype);
        Enumeration<String> prefixes = this.namespaces.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String nsuri = this.namespaces.get(prefix);
            currentNode.setNamespace(prefix, nsuri, this.docid);
        }
        this.namespaces = null;
        this.namespaces = new Hashtable();
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeName = atts.getQName(i);
            String attributeValue = atts.getValue(i);
            this.endNodeId = currentNode.setAttribute(attributeName, attributeValue, this.docid);
            if (attributeName == null || attributeName.indexOf(":schemaLocation") == -1) continue;
            attributeValue = StringUtil.replaceTabsNewLines((String)attributeValue);
            attributeValue = StringUtil.replaceDuplicateSpaces((String)attributeValue);
            Vector parsedUri = StringUtil.toVector((String)attributeValue, (char)' ');
            for (int j = 0; j < parsedUri.size(); j += 2) {
                if (j + 1 >= parsedUri.size()) {
                    throw new SAXException("Odd number of elements found when parsing schema location: " + attributeValue + ". There should be an even number of uri/files in location.");
                }
                XMLSchema xmlSchema = new XMLSchema((String)parsedUri.get(j), (String)parsedUri.get(j + 1));
                this.schemaList.add(xmlSchema);
            }
        }
        this.nodeStack.push(currentNode);
        this.nodeIndex.addElement(currentNode);
        try {
            if (this.doctype != null && MetacatUtil.getOptionList(PropertyService.getProperty("xml.packagedoctype")).contains(this.doctype) && localName.equals("triple")) {
                this.startParseTriple = true;
                this.hasTriple = true;
                this.currentTriple = new Triple();
            }
        }
        catch (PropertyNotFoundException pnfe) {
            pnfe.printStackTrace(System.out);
            pnfe.printStackTrace(System.err);
            throw new SAXException("Error in DBSaxHandler.startElement for action " + this.action + " : " + pnfe.getMessage(), (Exception)((Object)pnfe));
        }
    }

    @Override
    public void characters(char[] cbuf, int start, int len) throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.characters - starting characters");
        this.textBuffer.append(new String(cbuf, start, len));
        this.hitTextNode = true;
        if (this.textBuffer.length() > 4000) {
            this.logMetacat.debug((Object)"DBSaxHandler.characters - Write text into DB in charaters when text buffer size is greater than maxmum number");
            DBSAXNode currentNode = this.nodeStack.peek();
            this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
            this.textBuffer = null;
            this.textBuffer = new StringBuffer();
        }
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.ignorableWhitespace - in ignorableWhitespace");
        DBSAXNode currentNode = this.nodeStack.peek();
        this.endNodeId = currentNode.writeChildNodeToDB("TEXT", null, new String(cbuf, start, len), this.docid);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.processingInstruction - in processing instructions");
        DBSAXNode currentNode = this.nodeStack.peek();
        this.endNodeId = currentNode.writeChildNodeToDB("PI", target, data, this.docid);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.endElement - End element " + qName));
        DBSAXNode currentNode = this.nodeStack.peek();
        if (this.hitTextNode) {
            this.logMetacat.debug((Object)"DBSaxHandler.endElement - Write text into DB in End Element");
            this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
            if (this.startParseTriple) {
                String content = this.textBuffer.toString().trim();
                if (localName.equals("subject")) {
                    this.currentTriple.setSubject(content);
                } else if (localName.equals("relationship")) {
                    this.currentTriple.setRelationship(content);
                } else if (localName.equals("object")) {
                    this.currentTriple.setObject(content);
                }
            }
        }
        this.hitTextNode = false;
        this.textBuffer = null;
        this.textBuffer = new StringBuffer();
        currentNode = this.nodeStack.pop();
        if (this.startParseTriple && localName.equals("triple")) {
            this.tripleList.addTriple(this.currentTriple);
            this.currentTriple = null;
            this.startParseTriple = false;
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.docname = name;
        this.doctype = publicId;
        this.systemid = systemId;
        this.processingDTD = true;
        DBSAXNode currentNode = this.nodeStack.peek();
        DBSAXNode dtdNode = new DBSAXNode(this.connection, name, publicId, systemId, currentNode, currentNode.getRootNodeID(), this.docid);
        this.logMetacat.debug((Object)"DBSaxHandler.startDTD - Start DTD");
        this.logMetacat.debug((Object)"DBSaxHandler.startDTD - Setting processingDTD to true");
        this.logMetacat.debug((Object)("DBSaxHandler.startDTD - DOCNAME: " + this.docname));
        this.logMetacat.debug((Object)("DBSaxHandler.startDTD - DOCTYPE: " + this.doctype));
        this.logMetacat.debug((Object)("DBSaxHandler.startDTD - SYSID: " + this.systemid));
    }

    @Override
    public void endDTD() throws SAXException {
        this.processingDTD = false;
        this.logMetacat.debug((Object)"DBSaxHandler.endDTD - Setting processingDTD to false");
        this.logMetacat.debug((Object)"DBSaxHandler.endDTD - end DTD");
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.comment - starting comment");
        if (!this.processingDTD) {
            DBSAXNode currentNode = this.nodeStack.peek();
            this.endNodeId = currentNode.writeChildNodeToDB("COMMENT", null, new String(ch, start, length), this.docid);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.startCDATA - starting CDATA");
    }

    @Override
    public void endCDATA() throws SAXException {
        this.logMetacat.debug((Object)"DBSaxHandler.endCDATA - end CDATA");
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.startEntity - starting entity: " + name));
        if (name.equals("[dtd]")) {
            this.processingDTD = true;
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.endEntity - ending entity: " + name));
        if (name.equals("[dtd]")) {
            this.processingDTD = false;
        }
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.elementDecl - element declaration: " + name + " " + model));
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.attributeDecl - attribute declaration: " + eName + " " + aName + " " + type + " " + valueDefault + " " + value));
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.internalEntityDecl - internal entity declaration: " + name + " " + value));
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.logMetacat.debug((Object)("DBSaxHandler.externalEntityDecl - external entity declaration: " + name + " " + publicId + " " + systemId));
        this.processingDTD = false;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.logMetacat.fatal((Object)("DBSaxHandler.fatalError - " + exception.getMessage()));
        throw new SAXException("Fatal processing error.", exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.logMetacat.error((Object)("DBSaxHandler.error - " + exception.getMessage()));
        throw new SAXException(exception.getMessage(), exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.logMetacat.warn((Object)("DBSaxHandler.warning - " + exception.getMessage()));
        throw new SAXException(exception.getMessage(), exception);
    }

    public String getDocname() {
        return this.docname;
    }

    public boolean processingDTD() {
        return this.processingDTD;
    }

    public boolean getIsRevisionDoc() {
        return this.isRevisionDoc;
    }

    public void setIsRevisionDoc(boolean isRevisionDoc) {
        this.isRevisionDoc = isRevisionDoc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected long writeTextForDBSAXNode(long previousEndNodeId, StringBuffer strBuffer, DBSAXNode node) throws SAXException {
        long nodeId = previousEndNodeId;
        if (strBuffer == null || node == null) {
            return nodeId;
        }
        boolean moredata = true;
        String normalizedData = strBuffer.toString();
        this.logMetacat.debug((Object)("DBSAXHandler.writeTextForDBSAXNode - Before normalize in write process: " + normalizedData));
        String afterNormalize = MetacatUtil.normalize(normalizedData);
        this.logMetacat.debug((Object)("DBSAXHandler.writeTextForDBSAXNode - After normalize in write process: " + afterNormalize));
        strBuffer = new StringBuffer(afterNormalize);
        int bufferSize = strBuffer.length();
        boolean start = false;
        if (bufferSize > 0) {
            this.logMetacat.debug((Object)"DBSAXHandler.writeTextForDBSAXNode - Write text into DB");
            nodeId = node.writeChildNodeToDB("TEXT", null, new String(strBuffer), this.docid);
        }
        return nodeId;
    }

    public long getRootNodeId() {
        return this.rootNode.getNodeID();
    }

    public String getDocumentType() {
        return this.doctype;
    }

    public String getDocumentName() {
        return this.docname;
    }

    public String getCatalogId() {
        return this.catalogid;
    }
}

